/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.writer;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.gobblin.writer.DataWriter;
import org.apache.gobblin.writer.FsDataWriterBuilder;
import org.apache.gobblin.writer.GobblinOrcWriter;

public class GobblinOrcWriterBuilder
extends FsDataWriterBuilder<Schema, GenericRecord> {
    public DataWriter<GenericRecord> build() throws IOException {
        Preconditions.checkNotNull((Object)this.destination);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.writerId) ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)this.schema);
        switch (this.destination.getType()) {
            case HDFS: {
                return new GobblinOrcWriter(this, this.destination.getProperties());
            }
        }
        throw new RuntimeException("Unknown destination type: " + this.destination.getType());
    }
}

