/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.retention.profile;

import com.typesafe.config.Config;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Properties;
import org.apache.gobblin.config.client.ConfigClient;
import org.apache.gobblin.config.client.ConfigClientCache;
import org.apache.gobblin.config.client.api.ConfigStoreFactoryDoesNotExistsException;
import org.apache.gobblin.config.client.api.VersionStabilityPolicy;
import org.apache.gobblin.config.store.api.ConfigStoreCreationException;
import org.apache.gobblin.config.store.api.VersionDoesNotExistException;
import org.apache.gobblin.data.management.retention.dataset.CleanableIcebergDataset;
import org.apache.gobblin.data.management.retention.dataset.ConfigurableCleanableDataset;
import org.apache.gobblin.data.management.retention.profile.ManagedCleanableDatasetFinder;
import org.apache.gobblin.data.management.version.FileSystemDatasetVersion;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.LoggerFactory;

public class ManagedIcebergCleanableDatasetFinder
extends ManagedCleanableDatasetFinder {
    private static final String ICEBERG_CONFIG_PREFIX = "/iceberg";
    private final ConfigClient client;

    public ManagedIcebergCleanableDatasetFinder(FileSystem fs, Properties jobProps, Config config) {
        this(fs, jobProps, config, ConfigClientCache.getClient((VersionStabilityPolicy)VersionStabilityPolicy.STRONG_LOCAL_STABILITY));
    }

    public ManagedIcebergCleanableDatasetFinder(FileSystem fs, Properties jobProps, Config config, ConfigClient client) {
        super(fs, jobProps, config, client);
        this.client = client;
    }

    @Override
    public ConfigurableCleanableDataset<FileSystemDatasetVersion> datasetAtPath(Path path) throws IOException {
        try {
            return new CleanableIcebergDataset<FileSystemDatasetVersion>(this.fs, this.props, path, this.client.getConfig(this.props.getProperty("gobblin.config.management.store.uri") + ICEBERG_CONFIG_PREFIX + path.toString()), LoggerFactory.getLogger(CleanableIcebergDataset.class));
        }
        catch (URISyntaxException | ConfigStoreFactoryDoesNotExistsException | ConfigStoreCreationException | VersionDoesNotExistException var3) {
            throw new IllegalArgumentException(var3);
        }
    }
}

