/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.retention.policy;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.gobblin.data.management.retention.policy.RetentionPolicy;
import org.apache.gobblin.data.management.version.DatasetVersion;
import org.apache.gobblin.util.ClassAliasResolver;
import org.apache.gobblin.util.PropertiesUtils;

public class CombineRetentionPolicy<T extends DatasetVersion>
implements RetentionPolicy<T> {
    public static final String COMBINE_RETENTION_POLICIES = "gobblin.retention.combine.retention.policy.classes";
    public static final String RETENTION_POLICIES_PREFIX = "gobblin.retention.combine.retention.policy.class.";
    public static final String DELETE_SETS_COMBINE_OPERATION = "gobblin.retention.combine.retention.policy.delete.sets.combine.operation";
    private static final Splitter COMMA_BASED_SPLITTER = Splitter.on((String)",").omitEmptyStrings().trimResults();
    private final List<RetentionPolicy<T>> retentionPolicies;
    private final DeletableCombineOperation combineOperation;

    public CombineRetentionPolicy(List<RetentionPolicy<T>> retentionPolicies, DeletableCombineOperation combineOperation) {
        this.combineOperation = combineOperation;
        this.retentionPolicies = retentionPolicies;
    }

    public CombineRetentionPolicy(Properties props) throws IOException {
        Preconditions.checkArgument((boolean)props.containsKey(DELETE_SETS_COMBINE_OPERATION), (Object)"Combine operation not specified.");
        this.retentionPolicies = this.findRetentionPolicies(props);
        if (this.retentionPolicies.size() == 0) {
            throw new IOException("No retention policies specified for " + CombineRetentionPolicy.class.getCanonicalName());
        }
        this.combineOperation = DeletableCombineOperation.valueOf(props.getProperty(DELETE_SETS_COMBINE_OPERATION).toUpperCase());
    }

    private List<RetentionPolicy<T>> findRetentionPolicies(Properties props) {
        ImmutableList.Builder builder = ImmutableList.builder();
        ClassAliasResolver aliasResolver = new ClassAliasResolver(RetentionPolicy.class);
        List retentionPolicyClasses = props.containsKey(COMBINE_RETENTION_POLICIES) ? COMMA_BASED_SPLITTER.splitToList((CharSequence)props.getProperty(COMBINE_RETENTION_POLICIES)) : PropertiesUtils.getValuesAsList((Properties)props, (Optional)Optional.of((Object)RETENTION_POLICIES_PREFIX));
        for (String retentionPolicyClass : retentionPolicyClasses) {
            try {
                builder.add((Object)((RetentionPolicy)ConstructorUtils.invokeConstructor(Class.forName(aliasResolver.resolve(retentionPolicyClass)), (Object[])new Object[]{props})));
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return builder.build();
    }

    @Override
    public Class<T> versionClass() {
        if (this.retentionPolicies.size() == 1) {
            return this.retentionPolicies.get(0).versionClass();
        }
        Class<DatasetVersion> klazz = this.retentionPolicies.get(0).versionClass();
        for (RetentionPolicy<T> policy : this.retentionPolicies) {
            klazz = this.commonSuperclass(klazz, policy.versionClass());
        }
        return klazz;
    }

    @Override
    public Collection<T> listDeletableVersions(final List<T> allVersions) {
        ArrayList candidateDeletableVersions = Lists.newArrayList((Iterable)Iterables.transform(this.retentionPolicies, (Function)new Function<RetentionPolicy<T>, Set<T>>(){

            @Nullable
            public Set<T> apply(RetentionPolicy<T> input) {
                return Sets.newHashSet(input.listDeletableVersions(allVersions));
            }
        }));
        switch (this.combineOperation) {
            case INTERSECT: {
                return this.intersectDatasetVersions(candidateDeletableVersions);
            }
            case UNION: {
                return this.unionDatasetVersions(candidateDeletableVersions);
            }
        }
        throw new RuntimeException("Combine operation " + (Object)((Object)this.combineOperation) + " not recognized.");
    }

    @VisibleForTesting
    public Class<T> commonSuperclass(Class<T> classA, Class<T> classB) {
        if (classA.isAssignableFrom(classB)) {
            return classA;
        }
        Class<T> klazz = classA;
        while (!klazz.isAssignableFrom(classB)) {
            klazz = klazz.getSuperclass();
        }
        if (DatasetVersion.class.isAssignableFrom(klazz)) {
            return klazz;
        }
        return DatasetVersion.class;
    }

    private Set<T> intersectDatasetVersions(Collection<Set<T>> sets) {
        if (sets.size() <= 0) {
            return Sets.newHashSet();
        }
        Iterator<Set<T>> it = sets.iterator();
        Sets.SetView outputSet = it.next();
        while (it.hasNext()) {
            outputSet = Sets.intersection(outputSet, it.next());
        }
        return outputSet;
    }

    private Set<T> unionDatasetVersions(Collection<Set<T>> sets) {
        if (sets.size() <= 0) {
            return Sets.newHashSet();
        }
        Iterator<Set<T>> it = sets.iterator();
        Sets.SetView outputSet = it.next();
        while (it.hasNext()) {
            outputSet = Sets.union(outputSet, it.next());
        }
        return outputSet;
    }

    public static enum DeletableCombineOperation {
        INTERSECT,
        UNION;

    }
}

