/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.retention;

import com.codahale.metrics.Meter;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.io.Closer;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.typesafe.config.Config;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.gobblin.configuration.DynamicConfigGenerator;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.data.management.retention.dataset.CleanableDataset;
import org.apache.gobblin.data.management.retention.profile.MultiCleanableDatasetFinder;
import org.apache.gobblin.dataset.Dataset;
import org.apache.gobblin.dataset.DatasetsFinder;
import org.apache.gobblin.instrumented.Instrumentable;
import org.apache.gobblin.instrumented.Instrumented;
import org.apache.gobblin.metrics.GobblinMetrics;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.Tag;
import org.apache.gobblin.metrics.event.EventSubmitter;
import org.apache.gobblin.runtime.DynamicConfigGeneratorFactory;
import org.apache.gobblin.util.AzkabanTags;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.gobblin.util.ExecutorsUtils;
import org.apache.gobblin.util.RateControlledFileSystem;
import org.apache.gobblin.util.WriterUtils;
import org.apache.gobblin.util.executors.ScalingThreadPoolExecutor;
import org.apache.hadoop.fs.FileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatasetCleaner
implements Instrumentable,
Closeable {
    public static final String CONFIGURATION_KEY_PREFIX = "gobblin.retention.";
    public static final String MAX_CONCURRENT_DATASETS_CLEANED = "gobblin.retention.max.concurrent.datasets.cleaned";
    public static final String DATASET_CLEAN_HDFS_CALLS_PER_SECOND_LIMIT = "gobblin.retention.hdfs.calls.per.second.limit";
    public static final String DEFAULT_MAX_CONCURRENT_DATASETS_CLEANED = "100";
    private static Logger LOG = LoggerFactory.getLogger(DatasetCleaner.class);
    private final DatasetsFinder<Dataset> datasetFinder;
    private final ListeningExecutorService service;
    private final Closer closer;
    private final boolean isMetricEnabled;
    private MetricContext metricContext;
    private final EventSubmitter eventSubmitter;
    private Optional<Meter> datasetsCleanSuccessMeter = Optional.absent();
    private Optional<Meter> datasetsCleanFailureMeter = Optional.absent();
    private Optional<CountDownLatch> finishCleanSignal;
    private final List<Throwable> throwables;

    public DatasetCleaner(FileSystem fs, Properties props) throws IOException {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)props);
        Config propsAsConfig = ConfigUtils.propertiesToConfig((Properties)props);
        DynamicConfigGenerator dynamicConfigGenerator = DynamicConfigGeneratorFactory.createDynamicConfigGenerator((Config)propsAsConfig);
        Config dynamicConfig = dynamicConfigGenerator.generateDynamicConfig(propsAsConfig);
        properties.putAll((Map<?, ?>)ConfigUtils.configToProperties((Config)dynamicConfig));
        State state = new State(properties);
        FileSystem targetFs = properties.containsKey("writer.fs.uri") ? WriterUtils.getWriterFs((State)state) : fs;
        this.closer = Closer.create();
        ArrayList tags = Lists.newArrayList();
        tags.addAll(Tag.fromMap((Map)AzkabanTags.getAzkabanTags()));
        this.metricContext = (MetricContext)this.closer.register((Closeable)Instrumented.getMetricContext((State)state, DatasetCleaner.class, (List)tags));
        this.isMetricEnabled = GobblinMetrics.isEnabled((Properties)properties);
        this.eventSubmitter = new EventSubmitter.Builder(this.metricContext, "gobblin.data.management.retention").build();
        try {
            FileSystem optionalRateControlledFs = targetFs;
            if (properties.contains(DATASET_CLEAN_HDFS_CALLS_PER_SECOND_LIMIT)) {
                optionalRateControlledFs = (FileSystem)this.closer.register((Closeable)new RateControlledFileSystem(targetFs, Long.parseLong(properties.getProperty(DATASET_CLEAN_HDFS_CALLS_PER_SECOND_LIMIT))));
                ((RateControlledFileSystem)optionalRateControlledFs).startRateControl();
            }
            this.datasetFinder = new MultiCleanableDatasetFinder(optionalRateControlledFs, properties, this.eventSubmitter);
        }
        catch (NumberFormatException exception) {
            throw new IOException(exception);
        }
        catch (ExecutionException exception) {
            throw new IOException(exception);
        }
        ScalingThreadPoolExecutor executor = ScalingThreadPoolExecutor.newScalingThreadPool((int)0, (int)Integer.parseInt(properties.getProperty(MAX_CONCURRENT_DATASETS_CLEANED, DEFAULT_MAX_CONCURRENT_DATASETS_CLEANED)), (long)100L, (ThreadFactory)ExecutorsUtils.newThreadFactory((Optional)Optional.of((Object)LOG), (Optional)Optional.of((Object)"Dataset-cleaner-pool-%d")));
        this.service = ExecutorsUtils.loggingDecorator((ExecutorService)executor);
        this.throwables = Lists.newArrayList();
    }

    public void clean() throws IOException {
        List dataSets = this.datasetFinder.findDatasets();
        this.finishCleanSignal = Optional.of((Object)new CountDownLatch(dataSets.size()));
        for (final Dataset dataset : dataSets) {
            ListenableFuture future = this.service.submit((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    if (dataset instanceof CleanableDataset) {
                        ((CleanableDataset)dataset).clean();
                    }
                    return null;
                }
            });
            Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<Void>(){

                public void onFailure(Throwable throwable) {
                    ((CountDownLatch)DatasetCleaner.this.finishCleanSignal.get()).countDown();
                    LOG.warn("Exception caught when cleaning " + dataset.datasetURN() + ".", throwable);
                    DatasetCleaner.this.throwables.add(throwable);
                    Instrumented.markMeter((Optional)DatasetCleaner.this.datasetsCleanFailureMeter);
                    DatasetCleaner.this.eventSubmitter.submit("CleanFailed", (Map)ImmutableMap.of((Object)"failureContext", (Object)ExceptionUtils.getFullStackTrace((Throwable)throwable), (Object)"datasetUrn", (Object)dataset.datasetURN()));
                }

                public void onSuccess(Void arg0) {
                    ((CountDownLatch)DatasetCleaner.this.finishCleanSignal.get()).countDown();
                    LOG.info("Successfully cleaned: " + dataset.datasetURN());
                    Instrumented.markMeter((Optional)DatasetCleaner.this.datasetsCleanSuccessMeter);
                }
            });
        }
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.finishCleanSignal.isPresent()) {
                ((CountDownLatch)this.finishCleanSignal.get()).await();
            }
            if (!this.throwables.isEmpty()) {
                for (Throwable t : this.throwables) {
                    LOG.error("Failed clean due to ", t);
                }
                throw new RuntimeException("Clean failed for one or more datasets");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Not all datasets finish cleanning", e);
        }
        finally {
            ExecutorsUtils.shutdownExecutorService((ExecutorService)this.service, (Optional)Optional.of((Object)LOG));
            this.closer.close();
        }
    }

    public MetricContext getMetricContext() {
        return this.metricContext;
    }

    public boolean isInstrumentationEnabled() {
        return this.isMetricEnabled;
    }

    public List<Tag<?>> generateTags(State state) {
        return Lists.newArrayList();
    }

    public void switchMetricContext(List<Tag<?>> tags) {
        this.metricContext = (MetricContext)this.closer.register((Closeable)Instrumented.newContextFromReferenceContext((MetricContext)this.metricContext, tags, (Optional)Optional.absent()));
        this.regenerateMetrics();
    }

    public void switchMetricContext(MetricContext context) {
        this.metricContext = context;
        this.regenerateMetrics();
    }

    protected void regenerateMetrics() {
        if (this.isInstrumentationEnabled()) {
            this.datasetsCleanFailureMeter = Optional.of((Object)this.metricContext.meter("gobblin.retention.datasets.clean.failure"));
            this.datasetsCleanSuccessMeter = Optional.of((Object)this.metricContext.meter("gobblin.retention.datasets.clean.success"));
        }
    }

    public static class DatasetCleanerMetrics {
        public static final String DATASETS_CLEAN_SUCCESS = "gobblin.retention.datasets.clean.success";
        public static final String DATASETS_CLEAN_FAILURE = "gobblin.retention.datasets.clean.failure";
    }
}

