/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.partition;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.apache.gobblin.data.management.copy.CopyConfiguration;
import org.apache.gobblin.data.management.copy.CopyEntity;
import org.apache.gobblin.data.management.copy.CopyableDataset;
import org.apache.gobblin.data.management.copy.CopyableDatasetBase;
import org.apache.gobblin.data.management.copy.IterableCopyableDataset;
import org.apache.gobblin.data.management.copy.IterableCopyableDatasetImpl;
import org.apache.gobblin.data.management.copy.prioritization.PrioritizedCopyableDataset;
import org.apache.gobblin.data.management.partition.FileSet;
import org.apache.gobblin.util.request_allocation.PushDownRequestor;
import org.apache.gobblin.util.request_allocation.Requestor;
import org.apache.hadoop.fs.FileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyableDatasetRequestor
implements PushDownRequestor<FileSet<CopyEntity>> {
    private static final Logger log = LoggerFactory.getLogger(CopyableDatasetRequestor.class);
    private final FileSystem targetFs;
    private final CopyConfiguration copyConfiguration;
    private final IterableCopyableDataset dataset;

    public Iterator<FileSet<CopyEntity>> iterator() {
        try {
            return this.injectRequestor(this.dataset.getFileSetIterator(this.targetFs, this.copyConfiguration));
        }
        catch (Throwable exc) {
            if (this.copyConfiguration.isAbortOnSingleDatasetFailure()) {
                throw new RuntimeException(String.format("Could not get FileSets for dataset %s", this.dataset.datasetURN()), exc);
            }
            log.error(String.format("Could not get FileSets for dataset %s. Skipping.", this.dataset.datasetURN()), exc);
            return Iterators.emptyIterator();
        }
    }

    public Iterator<FileSet<CopyEntity>> getRequests(Comparator<FileSet<CopyEntity>> prioritizer) throws IOException {
        if (this.dataset instanceof PrioritizedCopyableDataset) {
            return ((PrioritizedCopyableDataset)this.dataset).getFileSetIterator(this.targetFs, this.copyConfiguration, prioritizer, this);
        }
        ArrayList entities = Lists.newArrayList(this.injectRequestor(this.dataset.getFileSetIterator(this.targetFs, this.copyConfiguration)));
        Collections.sort(entities, prioritizer);
        return entities.iterator();
    }

    private Iterator<FileSet<CopyEntity>> injectRequestor(Iterator<FileSet<CopyEntity>> iterator) {
        return Iterators.transform(iterator, (Function)new Function<FileSet<CopyEntity>, FileSet<CopyEntity>>(){

            public FileSet<CopyEntity> apply(FileSet<CopyEntity> input) {
                input.setRequestor((Requestor<FileSet<CopyEntity>>)CopyableDatasetRequestor.this);
                return input;
            }
        });
    }

    public CopyableDatasetRequestor(FileSystem targetFs, CopyConfiguration copyConfiguration, IterableCopyableDataset dataset) {
        this.targetFs = targetFs;
        this.copyConfiguration = copyConfiguration;
        this.dataset = dataset;
    }

    public FileSystem getTargetFs() {
        return this.targetFs;
    }

    public CopyConfiguration getCopyConfiguration() {
        return this.copyConfiguration;
    }

    public IterableCopyableDataset getDataset() {
        return this.dataset;
    }

    public static class Factory
    implements Function<CopyableDatasetBase, CopyableDatasetRequestor> {
        private final FileSystem targetFs;
        private final CopyConfiguration copyConfiguration;
        private final Logger log;

        @Nullable
        public CopyableDatasetRequestor apply(CopyableDatasetBase input) {
            IterableCopyableDataset iterableCopyableDataset;
            if (input instanceof IterableCopyableDataset) {
                iterableCopyableDataset = (IterableCopyableDataset)input;
            } else if (input instanceof CopyableDataset) {
                iterableCopyableDataset = new IterableCopyableDatasetImpl((CopyableDataset)input);
            } else {
                this.log.error(String.format("Cannot process %s, can only copy %s or %s.", input == null ? null : input.getClass().getName(), CopyableDataset.class.getName(), IterableCopyableDataset.class.getName()));
                return null;
            }
            return new CopyableDatasetRequestor(this.targetFs, this.copyConfiguration, iterableCopyableDataset);
        }

        public Factory(FileSystem targetFs, CopyConfiguration copyConfiguration, Logger log) {
            this.targetFs = targetFs;
            this.copyConfiguration = copyConfiguration;
            this.log = log;
        }
    }
}

