/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy.replication;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.fs.Path;

public class HadoopFsReplicaConfig {
    public static final String HDFS_COLO_KEY = "cluster.colo";
    public static final String HDFS_CLUSTERNAME_KEY = "cluster.name";
    public static final String HDFS_FILESYSTEM_URI_KEY = "cluster.FsURI";
    public static final String HDFS_PATH_KEY = "path";
    private final String colo;
    private final String clustername;
    private final URI fsURI;
    private final Path path;

    public HadoopFsReplicaConfig(Config config) {
        Preconditions.checkArgument((boolean)config.hasPath(HDFS_COLO_KEY));
        Preconditions.checkArgument((boolean)config.hasPath(HDFS_CLUSTERNAME_KEY));
        Preconditions.checkArgument((boolean)config.hasPath(HDFS_PATH_KEY));
        Preconditions.checkArgument((boolean)config.hasPath(HDFS_FILESYSTEM_URI_KEY));
        this.colo = config.getString(HDFS_COLO_KEY);
        this.clustername = config.getString(HDFS_CLUSTERNAME_KEY);
        this.path = new Path(config.getString(HDFS_PATH_KEY));
        try {
            this.fsURI = new URI(config.getString(HDFS_FILESYSTEM_URI_KEY));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("can not build URI based on " + config.getString(HDFS_FILESYSTEM_URI_KEY));
        }
    }

    public String toString() {
        return Objects.toStringHelper(this.getClass()).add("colo", (Object)this.colo).add("name", (Object)this.clustername).add("FilesystemURI", (Object)this.fsURI).add("rootPath", (Object)this.path).toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.clustername == null ? 0 : this.clustername.hashCode());
        result = 31 * result + (this.colo == null ? 0 : this.colo.hashCode());
        result = 31 * result + (this.fsURI == null ? 0 : this.fsURI.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HadoopFsReplicaConfig other = (HadoopFsReplicaConfig)obj;
        if (this.clustername == null ? other.clustername != null : !this.clustername.equals(other.clustername)) {
            return false;
        }
        if (this.colo == null ? other.colo != null : !this.colo.equals(other.colo)) {
            return false;
        }
        if (this.fsURI == null ? other.fsURI != null : !this.fsURI.equals(other.fsURI)) {
            return false;
        }
        return !(this.path == null ? other.path != null : !this.path.equals((Object)other.path));
    }

    public String getColo() {
        return this.colo;
    }

    public String getClustername() {
        return this.clustername;
    }

    public URI getFsURI() {
        return this.fsURI;
    }

    public Path getPath() {
        return this.path;
    }
}

