/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy.predicates;

import com.google.common.base.Predicate;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.hadoop.hive.metastore.api.Table;

public class TableTypeFilter
implements Predicate<Table> {
    public static final String FILTER_TYPE = "tableTypeFilter.type";
    private final TABLE_TYPE tableType;

    public TableTypeFilter(Properties props) {
        this.tableType = TABLE_TYPE.valueOf(props.getProperty(FILTER_TYPE, TABLE_TYPE.SNAPSHOT.name()).toUpperCase());
    }

    public boolean apply(@Nullable Table input) {
        if (input == null) {
            return false;
        }
        switch (this.tableType) {
            case SNAPSHOT: {
                return input.getPartitionKeys() == null || input.getPartitionKeys().size() == 0;
            }
            case PARTITIONED: {
                return input.getPartitionKeys() != null && input.getPartitionKeys().size() > 0;
            }
        }
        throw new UnsupportedOperationException("Invalid type: " + (Object)((Object)this.tableType));
    }

    private static enum TABLE_TYPE {
        SNAPSHOT,
        PARTITIONED;

    }
}

