/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy.hive;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.data.management.copy.CopyConfiguration;
import org.apache.gobblin.data.management.copy.CopyEntity;
import org.apache.gobblin.data.management.copy.hive.HiveCopyEntityHelper;
import org.apache.gobblin.data.management.copy.hive.HiveDatasetFinder;
import org.apache.gobblin.data.management.copy.hive.HiveUtils;
import org.apache.gobblin.data.management.copy.prioritization.PrioritizedCopyableDataset;
import org.apache.gobblin.data.management.partition.FileSet;
import org.apache.gobblin.hive.HiveMetastoreClientPool;
import org.apache.gobblin.instrumented.Instrumented;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.Tag;
import org.apache.gobblin.util.AutoReturnableObject;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.gobblin.util.PathUtils;
import org.apache.gobblin.util.request_allocation.PushDownRequestor;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alpha
public class HiveDataset
implements PrioritizedCopyableDataset {
    private static final Logger log = LoggerFactory.getLogger(HiveDataset.class);
    private static Splitter SPLIT_ON_DOT = Splitter.on((String)".").omitEmptyStrings().trimResults();
    public static final ImmutableSet<TableType> COPYABLE_TABLES = ImmutableSet.of((Object)TableType.EXTERNAL_TABLE, (Object)TableType.MANAGED_TABLE);
    public static final String REGISTERER = "registerer";
    public static final String REGISTRATION_GENERATION_TIME_MILLIS = "registrationGenerationTimeMillis";
    public static final String DATASET_NAME_PATTERN_KEY = "hive.datasetNamePattern";
    public static final String DATABASE = "Database";
    public static final String TABLE = "Table";
    public static final String DATABASE_TOKEN = "$DB";
    public static final String TABLE_TOKEN = "$TABLE";
    public static final String LOGICAL_DB_TOKEN = "$LOGICAL_DB";
    public static final String LOGICAL_TABLE_TOKEN = "$LOGICAL_TABLE";
    private String datasetPath;
    protected final transient Properties properties;
    protected final transient FileSystem fs;
    protected final transient HiveMetastoreClientPool clientPool;
    private final transient MetricContext metricContext;
    protected final transient Table table;
    protected final transient Config datasetConfig;
    protected final Optional<Path> tableRootPath;
    protected final String tableIdentifier;
    protected final Optional<String> datasetNamePattern;
    protected final HiveDatasetFinder.DbAndTable dbAndTable;
    protected final HiveDatasetFinder.DbAndTable logicalDbAndTable;

    public HiveDataset(FileSystem fs, HiveMetastoreClientPool clientPool, Table table, Properties properties) {
        this(fs, clientPool, table, properties, ConfigFactory.empty());
    }

    public HiveDataset(FileSystem fs, HiveMetastoreClientPool clientPool, Table table, Config datasetConfig) {
        this(fs, clientPool, table, new Properties(), datasetConfig);
    }

    public HiveDataset(FileSystem fs, HiveMetastoreClientPool clientPool, Table table, Properties properties, Config datasetConfig) {
        this.fs = fs;
        this.clientPool = clientPool;
        this.table = table;
        this.properties = properties;
        this.tableRootPath = PathUtils.isGlob((Path)this.table.getDataLocation()) ? Optional.absent() : Optional.fromNullable((Object)this.table.getDataLocation());
        this.tableIdentifier = this.table.getDbName() + "." + this.table.getTableName();
        this.datasetNamePattern = Optional.fromNullable((Object)ConfigUtils.getString((Config)datasetConfig, (String)DATASET_NAME_PATTERN_KEY, null));
        this.dbAndTable = new HiveDatasetFinder.DbAndTable(table.getDbName(), table.getTableName());
        this.logicalDbAndTable = this.datasetNamePattern.isPresent() ? HiveDataset.parseLogicalDbAndTable((String)this.datasetNamePattern.get(), this.dbAndTable, LOGICAL_DB_TOKEN, LOGICAL_TABLE_TOKEN) : this.dbAndTable;
        this.datasetConfig = HiveDataset.resolveConfig(datasetConfig, this.dbAndTable, this.logicalDbAndTable);
        this.metricContext = Instrumented.getMetricContext((State)new State(properties), HiveDataset.class, (List)Lists.newArrayList((Object[])new Tag[]{new Tag(DATABASE, (Object)table.getDbName()), new Tag(TABLE, (Object)table.getTableName())}));
    }

    @Override
    public Iterator<FileSet<CopyEntity>> getFileSetIterator(FileSystem targetFs, CopyConfiguration configuration) throws IOException {
        if (!this.canCopyTable()) {
            return Iterators.emptyIterator();
        }
        try {
            return new HiveCopyEntityHelper(this, configuration, targetFs).getCopyEntities(configuration);
        }
        catch (IOException ioe) {
            log.error("Failed to copy table " + this.table, (Throwable)ioe);
            return Iterators.emptyIterator();
        }
    }

    @Override
    public Iterator<FileSet<CopyEntity>> getFileSetIterator(FileSystem targetFs, CopyConfiguration configuration, Comparator<FileSet<CopyEntity>> prioritizer, PushDownRequestor<FileSet<CopyEntity>> requestor) throws IOException {
        if (!this.canCopyTable()) {
            return Iterators.emptyIterator();
        }
        try {
            ArrayList fileSetList = Lists.newArrayList(new HiveCopyEntityHelper(this, configuration, targetFs).getCopyEntities(configuration, prioritizer, requestor));
            Collections.sort(fileSetList, prioritizer);
            return fileSetList.iterator();
        }
        catch (IOException ioe) {
            log.error("Failed to copy table " + this.table, (Throwable)ioe);
            return Iterators.emptyIterator();
        }
    }

    public String datasetURN() {
        return this.table.getCompleteName();
    }

    public static String resolveTemplate(String rawString, Table table) {
        if (StringUtils.isBlank((CharSequence)rawString)) {
            return rawString;
        }
        return StringUtils.replaceEach((String)rawString, (String[])new String[]{DATABASE_TOKEN, TABLE_TOKEN}, (String[])new String[]{table.getDbName(), table.getTableName()});
    }

    @VisibleForTesting
    protected static HiveDatasetFinder.DbAndTable parseLogicalDbAndTable(String datasetNamePattern, HiveDatasetFinder.DbAndTable dbAndTable, String logicalDbToken, String logicalTableToken) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)datasetNamePattern), (Object)"Dataset name pattern must not be empty.");
        ArrayList datasetNameSplit = Lists.newArrayList((Iterable)SPLIT_ON_DOT.split((CharSequence)datasetNamePattern));
        Preconditions.checkArgument((datasetNameSplit.size() == 2 ? 1 : 0) != 0, (Object)"Dataset name pattern must of the format: dbPrefix_$LOGICAL_DB_dbPostfix.tablePrefix_$LOGICAL_TABLE_tablePostfix (prefix / postfix are optional)");
        String dbNamePattern = (String)datasetNameSplit.get(0);
        String tableNamePattern = (String)datasetNameSplit.get(1);
        String logicalDb = HiveDataset.extractTokenValueFromEntity(dbAndTable.getDb(), dbNamePattern, logicalDbToken);
        String logicalTable = HiveDataset.extractTokenValueFromEntity(dbAndTable.getTable(), tableNamePattern, logicalTableToken);
        return new HiveDatasetFinder.DbAndTable(logicalDb, logicalTable);
    }

    @VisibleForTesting
    protected static String extractTokenValueFromEntity(String sourceEntity, String sourceTemplate, String token) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)sourceEntity), (Object)"Source entity should not be blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)sourceTemplate), (Object)"Source template should not be blank");
        Preconditions.checkArgument((boolean)sourceTemplate.contains(token), (Object)String.format("Source template: %s should contain token: %s", sourceTemplate, token));
        String extractedValue = sourceEntity;
        ArrayList preAndPostFix = Lists.newArrayList((Iterable)Splitter.on((String)token).trimResults().split((CharSequence)sourceTemplate));
        extractedValue = StringUtils.removeStart((String)extractedValue, (String)((String)preAndPostFix.get(0)));
        extractedValue = StringUtils.removeEnd((String)extractedValue, (String)((String)preAndPostFix.get(1)));
        return extractedValue;
    }

    @VisibleForTesting
    protected static Config resolveConfig(Config datasetConfig, HiveDatasetFinder.DbAndTable realDbAndTable, HiveDatasetFinder.DbAndTable logicalDbAndTable) {
        Preconditions.checkNotNull((Object)datasetConfig, (Object)"Dataset config should not be null");
        Preconditions.checkNotNull((Object)realDbAndTable, (Object)"Real DB and table should not be null");
        Preconditions.checkNotNull((Object)logicalDbAndTable, (Object)"Logical DB and table should not be null");
        ImmutableMap.Builder immutableMapBuilder = ImmutableMap.builder();
        Config resolvedConfig = datasetConfig.resolve();
        for (Map.Entry entry : resolvedConfig.entrySet()) {
            if (ConfigValueType.LIST.equals((Object)((ConfigValue)entry.getValue()).valueType())) {
                List rawValueList = resolvedConfig.getStringList((String)entry.getKey());
                ArrayList resolvedValueList = Lists.newArrayList();
                for (String rawValue : rawValueList) {
                    String resolvedValue = StringUtils.replaceEach((String)rawValue, (String[])new String[]{DATABASE_TOKEN, TABLE_TOKEN, LOGICAL_DB_TOKEN, LOGICAL_TABLE_TOKEN}, (String[])new String[]{realDbAndTable.getDb(), realDbAndTable.getTable(), logicalDbAndTable.getDb(), logicalDbAndTable.getTable()});
                    resolvedValueList.add(resolvedValue);
                }
                StringBuilder listToStringWithQuotes = new StringBuilder();
                for (String resolvedValueStr : resolvedValueList) {
                    if (listToStringWithQuotes.length() > 0) {
                        listToStringWithQuotes.append(",");
                    }
                    listToStringWithQuotes.append("\"").append(resolvedValueStr).append("\"");
                }
                immutableMapBuilder.put(entry.getKey(), (Object)listToStringWithQuotes.toString());
                continue;
            }
            String resolvedValue = StringUtils.replaceEach((String)resolvedConfig.getString((String)entry.getKey()), (String[])new String[]{DATABASE_TOKEN, TABLE_TOKEN, LOGICAL_DB_TOKEN, LOGICAL_TABLE_TOKEN}, (String[])new String[]{realDbAndTable.getDb(), realDbAndTable.getTable(), logicalDbAndTable.getDb(), logicalDbAndTable.getTable()});
            immutableMapBuilder.put(entry.getKey(), (Object)resolvedValue);
        }
        return ConfigFactory.parseMap((Map)immutableMapBuilder.build());
    }

    public static List<Partition> sortPartitions(List<Partition> partitions) {
        Collections.sort(partitions, new Comparator<Partition>(){

            @Override
            public int compare(Partition o1, Partition o2) {
                return o1.getCompleteName().compareTo(o2.getCompleteName());
            }
        });
        return partitions;
    }

    public List<Partition> getPartitionsFromDataset() throws IOException {
        try (AutoReturnableObject client = this.getClientPool().getClient();){
            List<Partition> partitions = HiveUtils.getPartitions((IMetaStoreClient)client.get(), this.getTable(), (Optional<String>)Optional.absent());
            List<Partition> list = HiveDataset.sortPartitions(partitions);
            return list;
        }
    }

    private boolean canCopyTable() {
        if (!COPYABLE_TABLES.contains((Object)this.table.getTableType())) {
            log.warn(String.format("Not copying %s: tables of type %s are not copyable.", this.table.getCompleteName(), this.table.getTableType()));
            return false;
        }
        return true;
    }

    public FileSystem getFs() {
        return this.fs;
    }

    public HiveMetastoreClientPool getClientPool() {
        return this.clientPool;
    }

    public MetricContext getMetricContext() {
        return this.metricContext;
    }

    public Table getTable() {
        return this.table;
    }

    public Config getDatasetConfig() {
        return this.datasetConfig;
    }

    public Optional<Path> getTableRootPath() {
        return this.tableRootPath;
    }

    public String getTableIdentifier() {
        return this.tableIdentifier;
    }

    public Optional<String> getDatasetNamePattern() {
        return this.datasetNamePattern;
    }

    public HiveDatasetFinder.DbAndTable getDbAndTable() {
        return this.dbAndTable;
    }

    public HiveDatasetFinder.DbAndTable getLogicalDbAndTable() {
        return this.logicalDbAndTable;
    }

    public String toString() {
        return "HiveDataset(datasetPath=" + this.getDatasetPath() + ", properties=" + this.getProperties() + ", fs=" + this.getFs() + ", clientPool=" + this.getClientPool() + ", metricContext=" + this.getMetricContext() + ", table=" + this.getTable() + ", datasetConfig=" + this.getDatasetConfig() + ", tableRootPath=" + this.getTableRootPath() + ", tableIdentifier=" + this.getTableIdentifier() + ", datasetNamePattern=" + this.getDatasetNamePattern() + ", dbAndTable=" + this.getDbAndTable() + ", logicalDbAndTable=" + this.getLogicalDbAndTable() + ")";
    }

    @Override
    public String getDatasetPath() {
        return this.datasetPath;
    }

    public void setDatasetPath(String datasetPath) {
        this.datasetPath = datasetPath;
    }

    public Properties getProperties() {
        return this.properties;
    }
}

