/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.gobblin.data.management.copy.CopyConfiguration;
import org.apache.gobblin.data.management.copy.CopyEntity;
import org.apache.gobblin.data.management.copy.CopyableDataset;
import org.apache.gobblin.data.management.copy.IterableCopyableDataset;
import org.apache.gobblin.data.management.partition.FileSet;
import org.apache.gobblin.dataset.Dataset;
import org.apache.hadoop.fs.FileSystem;

public class IterableCopyableDatasetImpl
implements IterableCopyableDataset {
    private final CopyableDataset dataset;

    @Override
    public Iterator<FileSet<CopyEntity>> getFileSetIterator(FileSystem targetFs, CopyConfiguration configuration) throws IOException {
        return IterableCopyableDatasetImpl.partitionCopyableFiles(this.dataset, this.dataset.getCopyableFiles(targetFs, configuration));
    }

    public String datasetURN() {
        return this.dataset.datasetURN();
    }

    private static Iterator<FileSet<CopyEntity>> partitionCopyableFiles(Dataset dataset, Collection<? extends CopyEntity> files) {
        HashMap partitionBuildersMaps = Maps.newHashMap();
        for (CopyEntity copyEntity : files) {
            if (!partitionBuildersMaps.containsKey(copyEntity.getFileSet())) {
                partitionBuildersMaps.put(copyEntity.getFileSet(), new FileSet.Builder(copyEntity.getFileSet(), dataset));
            }
            ((FileSet.Builder)partitionBuildersMaps.get(copyEntity.getFileSet())).add(copyEntity);
        }
        return Iterators.transform(partitionBuildersMaps.values().iterator(), (Function)new Function<FileSet.Builder<CopyEntity>, FileSet<CopyEntity>>(){

            @Nullable
            public FileSet<CopyEntity> apply(@Nonnull FileSet.Builder<CopyEntity> input) {
                return input.build();
            }
        });
    }

    public IterableCopyableDatasetImpl(CopyableDataset dataset) {
        this.dataset = dataset;
    }
}

