/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.gobblin.data.management.copy.AllEqualComparator;
import org.apache.gobblin.data.management.copy.CopyEntity;
import org.apache.gobblin.data.management.partition.FileSet;
import org.apache.gobblin.source.workunit.WorkUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConcurrentBoundedWorkUnitList {
    private static final Logger log = LoggerFactory.getLogger(ConcurrentBoundedWorkUnitList.class);
    private final TreeMap<FileSet<CopyEntity>, List<WorkUnit>> workUnitsMap;
    private final Comparator<FileSet<CopyEntity>> comparator;
    private final int maxSize;
    private final int strictMaxSize;
    private int currentSize = 0;
    private boolean rejectedFileSet;

    public ConcurrentBoundedWorkUnitList(int maxSize, Comparator<FileSet<CopyEntity>> comparator, double strictLimitMultiplier) {
        this.maxSize = maxSize;
        double actualStrictLimitMultiplier = Math.min(2.147483647E9 / (double)this.maxSize, Math.max(1.0, strictLimitMultiplier));
        this.strictMaxSize = (int)((double)this.maxSize * actualStrictLimitMultiplier);
        this.comparator = comparator == null ? new AllEqualComparator() : comparator;
        this.workUnitsMap = new TreeMap(new AugmentedComparator(this.comparator));
        this.rejectedFileSet = false;
    }

    public boolean addFileSet(FileSet<CopyEntity> fileSet, List<WorkUnit> workUnits) {
        boolean addedWorkunits = this.addFileSetImpl(fileSet, workUnits);
        if (!addedWorkunits) {
            this.rejectedFileSet = true;
        }
        return addedWorkunits;
    }

    private synchronized boolean addFileSetImpl(FileSet<CopyEntity> fileSet, List<WorkUnit> workUnits) {
        if (this.currentSize + workUnits.size() > this.strictMaxSize) {
            if (this.comparator.compare(this.workUnitsMap.lastKey(), fileSet) <= 0) {
                return false;
            }
            int tmpSize = this.currentSize;
            HashSet partitionsToDelete = Sets.newHashSet();
            for (FileSet<CopyEntity> existingFileSet : this.workUnitsMap.descendingKeySet()) {
                if (this.comparator.compare(existingFileSet, fileSet) <= 0) {
                    return false;
                }
                partitionsToDelete.add(existingFileSet);
                if ((tmpSize -= this.workUnitsMap.get(existingFileSet).size()) + workUnits.size() > this.strictMaxSize) continue;
                break;
            }
            for (FileSet<CopyEntity> fileSetToRemove : partitionsToDelete) {
                List<WorkUnit> workUnitsRemoved = this.workUnitsMap.remove(fileSetToRemove);
                this.currentSize -= workUnitsRemoved.size();
            }
        }
        if (!this.workUnitsMap.containsKey(fileSet)) {
            this.workUnitsMap.put(fileSet, workUnits);
        } else {
            this.workUnitsMap.get(fileSet).addAll(workUnits);
        }
        this.currentSize += workUnits.size();
        log.info(String.format("Added %d work units to bounded list. Total size: %d, soft limit: %d, hard limit: %d.", workUnits.size(), this.currentSize, this.maxSize, this.strictMaxSize));
        return true;
    }

    public boolean hasRejectedFileSet() {
        return this.rejectedFileSet;
    }

    public synchronized boolean isFull() {
        return this.currentSize >= this.maxSize;
    }

    public List<WorkUnit> getWorkUnits() {
        ImmutableList.Builder allWorkUnits = ImmutableList.builder();
        for (List<WorkUnit> workUnits : this.workUnitsMap.values()) {
            allWorkUnits.addAll(workUnits);
        }
        return allWorkUnits.build();
    }

    public Map<FileSet<CopyEntity>, List<WorkUnit>> getRawWorkUnitMap() {
        return this.workUnitsMap;
    }

    public static ConcurrentBoundedWorkUnitListBuilder builder() {
        return new ConcurrentBoundedWorkUnitListBuilder();
    }

    public Comparator<FileSet<CopyEntity>> getComparator() {
        return this.comparator;
    }

    public static class ConcurrentBoundedWorkUnitListBuilder {
        private int maxSize;
        private Comparator<FileSet<CopyEntity>> comparator;
        private double strictLimitMultiplier;

        ConcurrentBoundedWorkUnitListBuilder() {
        }

        public ConcurrentBoundedWorkUnitListBuilder maxSize(int maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public ConcurrentBoundedWorkUnitListBuilder comparator(Comparator<FileSet<CopyEntity>> comparator) {
            this.comparator = comparator;
            return this;
        }

        public ConcurrentBoundedWorkUnitListBuilder strictLimitMultiplier(double strictLimitMultiplier) {
            this.strictLimitMultiplier = strictLimitMultiplier;
            return this;
        }

        public ConcurrentBoundedWorkUnitList build() {
            return new ConcurrentBoundedWorkUnitList(this.maxSize, this.comparator, this.strictLimitMultiplier);
        }

        public String toString() {
            return "ConcurrentBoundedWorkUnitList.ConcurrentBoundedWorkUnitListBuilder(maxSize=" + this.maxSize + ", comparator=" + this.comparator + ", strictLimitMultiplier=" + this.strictLimitMultiplier + ")";
        }
    }

    private static class AugmentedComparator
    implements Comparator<FileSet<CopyEntity>> {
        private final Comparator<FileSet<CopyEntity>> userProvidedComparator;

        public AugmentedComparator(Comparator<FileSet<CopyEntity>> userProvidedComparator) {
            this.userProvidedComparator = userProvidedComparator;
        }

        @Override
        public int compare(FileSet<CopyEntity> p1, FileSet<CopyEntity> p2) {
            int userProvidedCompare = this.userProvidedComparator.compare(p1, p2);
            if (userProvidedCompare == 0) {
                int datasetCompare = p1.getDataset().datasetURN().compareTo(p2.getDataset().datasetURN());
                if (datasetCompare == 0) {
                    return p1.getName().compareTo(p2.getName());
                }
                return datasetCompare;
            }
            return userProvidedCompare;
        }
    }
}

