/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.conversion.hive.task;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.DataConversionException;
import org.apache.gobblin.data.management.conversion.hive.entities.HiveProcessingEntity;
import org.apache.gobblin.data.management.copy.hive.HiveDatasetFinder;
import org.apache.gobblin.data.management.copy.hive.HiveUtils;
import org.apache.gobblin.hive.HiveMetastoreClientPool;
import org.apache.gobblin.util.AutoReturnableObject;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.avro.AvroObjectInspectorGenerator;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveConverterUtils {
    private static final Logger log = LoggerFactory.getLogger(HiveConverterUtils.class);
    private static final String PUBLISHED_TABLE_SUBDIRECTORY = "final";
    private static final String HIVE_PARTITIONS_INFO = "/";
    private static final String HIVE_PARTITIONS_TYPE = ":";
    public static final String HIVE_DATASET_PARTITION_OVERWRITE = "hive.dataset.partition.overwrite";
    public static final boolean DEFAULT_HIVE_DATASET_PARTITION_OVERWRITE = true;
    public static final String HIVE_DATASET_DESTINATION_SKIP_SETGROUP = "hive.dataset.destination.skip.setGroup";
    public static final boolean DEFAULT_HIVE_DATASET_DESTINATION_SKIP_SETGROUP = false;

    public static String getStagingTableName(String stagingTableNamePrefix) {
        int randomNumber = new Random().nextInt(100);
        String uniqueStagingTableQualifier = String.format("%s%s", System.currentTimeMillis(), randomNumber);
        return stagingTableNamePrefix + "_" + uniqueStagingTableQualifier;
    }

    public static String getOutputDataLocation(String outputDataLocation) {
        return outputDataLocation + HIVE_PARTITIONS_INFO + PUBLISHED_TABLE_SUBDIRECTORY;
    }

    public static String getStagingDataLocation(String outputDataLocation, String stagingTableName) {
        return outputDataLocation + HIVE_PARTITIONS_INFO + stagingTableName;
    }

    public static String generateCreateDuplicateTableDDL(String inputDbName, String inputTblName, String tblName, String tblLocation, Optional<String> optionalDbName) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)tblName));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)tblLocation));
        String dbName = optionalDbName.isPresent() ? (String)optionalDbName.get() : "default";
        return String.format("CREATE EXTERNAL TABLE IF NOT EXISTS `%s`.`%s` LIKE `%s`.`%s` LOCATION %n  '%s' %n", dbName, tblName, inputDbName, inputTblName, tblLocation);
    }

    public static String generateAlterTblPropsDML(String tableName, Optional<String> optionalDbName, Schema schema) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)tableName));
        Preconditions.checkArgument((schema != null ? 1 : 0) != 0);
        String dbName = optionalDbName.isPresent() ? (String)optionalDbName.get() : "default";
        try {
            Pair<String, String> orcSchemaProps = HiveConverterUtils.getORCSchemaPropsFromAvroSchema(schema);
            String dml = String.format("ALTER TABLE `%s`.`%s` SET TBLPROPERTIES ('columns'='%s', 'columns.types'='%s')", dbName, tableName, orcSchemaProps.getLeft(), orcSchemaProps.getRight());
            return dml;
        }
        catch (Exception e) {
            log.error("Cannot generate add partition DDL due to ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static Pair<String, String> getORCSchemaPropsFromAvroSchema(Schema avroSchema) throws SerDeException {
        AvroObjectInspectorGenerator objectInspectorGenerator = new AvroObjectInspectorGenerator(avroSchema);
        String columns = Joiner.on((String)",").join((Iterable)objectInspectorGenerator.getColumnNames());
        String columnTypes = Joiner.on((String)",").join((Iterable)objectInspectorGenerator.getColumnTypes().stream().map(x -> x.getTypeName()).collect(Collectors.toList()));
        return new ImmutablePair((Object)columns, (Object)columnTypes);
    }

    public static String generateStagingCTASStatementFromSelectStar(HiveDatasetFinder.DbAndTable outputDbAndTable, HiveDatasetFinder.DbAndTable sourceEntity, Map<String, String> partitionDMLInfo, StorageFormat storageFormat, String outputTableLocation) {
        StringBuilder sourceQueryBuilder = new StringBuilder("SELECT * FROM `").append(sourceEntity.getDb()).append("`.`").append(sourceEntity.getTable()).append("`");
        if (partitionDMLInfo != null && !partitionDMLInfo.isEmpty()) {
            sourceQueryBuilder.append(" WHERE ");
            sourceQueryBuilder.append(partitionDMLInfo.entrySet().stream().map(e -> "`" + (String)e.getKey() + "`='" + (String)e.getValue() + "'").collect(Collectors.joining(" AND ")));
        }
        return HiveConverterUtils.generateStagingCTASStatement(outputDbAndTable, sourceQueryBuilder.toString(), storageFormat, outputTableLocation);
    }

    public static String generateStagingCTASStatement(HiveDatasetFinder.DbAndTable outputDbAndTable, String sourceQuery, StorageFormat storageFormat, String outputTableLocation) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)outputDbAndTable.getDb()) && !Strings.isNullOrEmpty((String)outputDbAndTable.getTable()) ? 1 : 0) != 0, (Object)("Invalid output db and table " + outputDbAndTable));
        return String.format("CREATE TEMPORARY TABLE `%s`.`%s` STORED AS %s LOCATION '%s' AS %s", outputDbAndTable.getDb(), outputDbAndTable.getTable(), storageFormat.getHiveName(), outputTableLocation, sourceQuery);
    }

    public static String generateTableCopy(String inputTblName, String outputTblName, String inputDbName, String outputDbName, Optional<Map<String, String>> optionalPartitionDMLInfo) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)inputTblName));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)outputTblName));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)inputDbName));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)outputDbName));
        StringBuilder dmlQuery = new StringBuilder();
        dmlQuery.append(String.format("INSERT OVERWRITE TABLE `%s`.`%s` %n", outputDbName, outputTblName));
        if (optionalPartitionDMLInfo.isPresent() && ((Map)optionalPartitionDMLInfo.get()).size() > 0) {
            dmlQuery.append((CharSequence)HiveConverterUtils.partitionKeyValues(optionalPartitionDMLInfo));
        }
        dmlQuery.append(String.format("SELECT * FROM `%s`.`%s`", inputDbName, inputTblName));
        if (optionalPartitionDMLInfo.isPresent() && ((Map)optionalPartitionDMLInfo.get()).size() > 0) {
            dmlQuery.append(" WHERE ");
            String partitionsAndValues = ((Map)optionalPartitionDMLInfo.get()).entrySet().stream().map(e -> "`" + (String)e.getKey() + "`='" + (String)e.getValue() + "'").collect(Collectors.joining(" AND "));
            dmlQuery.append(partitionsAndValues);
        }
        return dmlQuery.toString();
    }

    protected static StringBuilder partitionKeyValues(Optional<Map<String, String>> optionalPartitionDMLInfo) {
        if (!optionalPartitionDMLInfo.isPresent()) {
            return new StringBuilder();
        }
        return new StringBuilder("PARTITION (").append(Joiner.on((String)", ").join(((Map)optionalPartitionDMLInfo.get()).entrySet().stream().map(e -> "`" + (String)e.getKey() + "`").iterator())).append(") \n");
    }

    public static void populatePartitionInfo(HiveProcessingEntity conversionEntity, Map<String, String> partitionsDDLInfo, Map<String, String> partitionsDMLInfo) {
        String partitionsInfoString = null;
        String partitionsTypeString = null;
        if (conversionEntity.getPartition().isPresent()) {
            partitionsInfoString = ((Partition)conversionEntity.getPartition().get()).getName();
            partitionsTypeString = ((Partition)conversionEntity.getPartition().get()).getSchema().getProperty("partition_columns.types");
        }
        if (StringUtils.isNotBlank(partitionsInfoString) || StringUtils.isNotBlank(partitionsTypeString)) {
            if (StringUtils.isBlank(partitionsInfoString) || StringUtils.isBlank(partitionsTypeString)) {
                throw new IllegalArgumentException("Both partitions info and partitions must be present, if one is specified");
            }
            List pInfo = Splitter.on((String)HIVE_PARTITIONS_INFO).omitEmptyStrings().trimResults().splitToList((CharSequence)partitionsInfoString);
            List pType = Splitter.on((String)HIVE_PARTITIONS_TYPE).omitEmptyStrings().trimResults().splitToList((CharSequence)partitionsTypeString);
            log.debug("PartitionsInfoString: " + partitionsInfoString);
            log.debug("PartitionsTypeString: " + partitionsTypeString);
            if (pInfo.size() != pType.size()) {
                throw new IllegalArgumentException("partitions info and partitions type list should of same size");
            }
            for (int i = 0; i < pInfo.size(); ++i) {
                List partitionInfoParts = Splitter.on((String)"=").omitEmptyStrings().trimResults().splitToList((CharSequence)pInfo.get(i));
                String partitionType = (String)pType.get(i);
                if (partitionInfoParts.size() != 2) {
                    throw new IllegalArgumentException(String.format("Partition details should be of the format partitionName=partitionValue. Recieved: %s", pInfo.get(i)));
                }
                partitionsDDLInfo.put((String)partitionInfoParts.get(0), partitionType);
                partitionsDMLInfo.put((String)partitionInfoParts.get(0), (String)partitionInfoParts.get(1));
            }
        }
    }

    public static void createStagingDirectory(FileSystem fs, String destination, HiveProcessingEntity conversionEntity, WorkUnitState workUnit) {
        Path destinationPath = new Path(destination);
        try {
            FsPermission permission;
            String group = null;
            if (conversionEntity.getTable().getDataLocation() != null) {
                FileStatus sourceDataFileStatus = fs.getFileStatus(conversionEntity.getTable().getDataLocation());
                permission = sourceDataFileStatus.getPermission();
                group = sourceDataFileStatus.getGroup();
            } else {
                permission = FsPermission.getDefault();
            }
            if (!fs.mkdirs(destinationPath, permission)) {
                throw new RuntimeException(String.format("Failed to create path %s with permissions %s", destinationPath, permission));
            }
            fs.setPermission(destinationPath, permission);
            if (group != null && !workUnit.getPropAsBoolean(HIVE_DATASET_DESTINATION_SKIP_SETGROUP, false)) {
                fs.setOwner(destinationPath, null, group);
            }
            log.info(String.format("Created %s with permissions %s and group %s", destinationPath, permission, group));
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    public static String getStagingDataPartitionDirName(HiveProcessingEntity conversionEntity, List<String> sourceDataPathIdentifier) {
        if (conversionEntity.getPartition().isPresent()) {
            StringBuilder dirNamePrefix = new StringBuilder();
            String sourceHivePartitionLocation = ((Partition)conversionEntity.getPartition().get()).getDataLocation().toString();
            if (null != sourceDataPathIdentifier && null != sourceHivePartitionLocation) {
                for (String hint : sourceDataPathIdentifier) {
                    if (!sourceHivePartitionLocation.toLowerCase().contains(hint.toLowerCase())) continue;
                    dirNamePrefix.append(hint.toLowerCase()).append("_");
                }
            }
            return dirNamePrefix + ((Partition)conversionEntity.getPartition().get()).getName();
        }
        return "";
    }

    public static Optional<Path> getDestinationPartitionLocation(Optional<org.apache.hadoop.hive.metastore.api.Table> table, WorkUnitState state, String partitionName) throws DataConversionException {
        if (!table.isPresent()) {
            return Optional.absent();
        }
        try {
            Optional partitionOptional;
            HiveMetastoreClientPool pool = HiveMetastoreClientPool.get((Properties)state.getJobState().getProperties(), (Optional)Optional.fromNullable((Object)state.getJobState().getProp("hive.dataset.hive.metastore.uri")));
            try (AutoReturnableObject client = pool.getClient();){
                partitionOptional = Optional.of((Object)((IMetaStoreClient)client.get()).getPartition(((org.apache.hadoop.hive.metastore.api.Table)table.get()).getDbName(), ((org.apache.hadoop.hive.metastore.api.Table)table.get()).getTableName(), partitionName));
            }
            catch (NoSuchObjectException e) {
                return Optional.absent();
            }
            if (partitionOptional.isPresent()) {
                Table qlTable = new Table((org.apache.hadoop.hive.metastore.api.Table)table.get());
                Partition qlPartition = new Partition(qlTable, (org.apache.hadoop.hive.metastore.api.Partition)partitionOptional.get());
                return Optional.of((Object)qlPartition.getDataLocation());
            }
        }
        catch (IOException | HiveException | TException e) {
            throw new DataConversionException("Could not fetch destination table metadata", e);
        }
        return Optional.absent();
    }

    public static String updatePartitionLocation(String outputDataPartitionLocation, WorkUnitState workUnitState, Optional<Path> destPartitionLocation) throws DataConversionException {
        if (workUnitState.getPropAsBoolean(HIVE_DATASET_PARTITION_OVERWRITE, true)) {
            return outputDataPartitionLocation;
        }
        if (!destPartitionLocation.isPresent()) {
            return outputDataPartitionLocation;
        }
        long timeStamp = System.currentTimeMillis();
        return StringUtils.join(Arrays.asList(outputDataPartitionLocation, timeStamp), (char)'/');
    }

    public static Pair<Optional<org.apache.hadoop.hive.metastore.api.Table>, Optional<List<Partition>>> getDestinationTableMeta(String dbName, String tableName, Properties props) {
        Optional table = Optional.absent();
        Optional partitions = Optional.absent();
        try {
            HiveMetastoreClientPool pool = HiveMetastoreClientPool.get((Properties)props, (Optional)Optional.fromNullable((Object)props.getProperty("hive.dataset.hive.metastore.uri")));
            try (AutoReturnableObject client = pool.getClient();){
                Table qlTable;
                table = Optional.of((Object)((IMetaStoreClient)client.get()).getTable(dbName, tableName));
                if (table.isPresent() && (qlTable = new Table((org.apache.hadoop.hive.metastore.api.Table)table.get())).isPartitioned()) {
                    partitions = Optional.of(HiveUtils.getPartitions((IMetaStoreClient)client.get(), qlTable, (Optional<String>)Optional.absent()));
                }
            }
        }
        catch (NoSuchObjectException e) {
            return ImmutablePair.of((Object)table, (Object)partitions);
        }
        catch (IOException | TException e) {
            throw new RuntimeException("Could not fetch destination table metadata", e);
        }
        return ImmutablePair.of((Object)table, (Object)partitions);
    }

    public static enum StorageFormat {
        TEXT_FILE("TEXTFILE"),
        SEQUENCE_FILE("SEQUENCEFILE"),
        ORC("ORC"),
        PARQUET("PARQUET"),
        AVRO("AVRO"),
        RC_FILE("RCFILE");

        private final String hiveName;

        private StorageFormat(String hiveName) {
            this.hiveName = hiveName;
        }

        public String getHiveName() {
            return this.hiveName;
        }
    }
}

