/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.conversion.hive.source;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import java.util.List;
import org.apache.gobblin.broker.iface.SharedResourcesBroker;
import org.apache.gobblin.configuration.SourceState;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.data.management.conversion.hive.dataset.ConvertibleHiveDataset;
import org.apache.gobblin.data.management.conversion.hive.dataset.ConvertibleHiveDatasetFinder;
import org.apache.gobblin.data.management.conversion.hive.source.HiveSource;
import org.apache.gobblin.data.management.conversion.hive.source.HiveWorkUnit;
import org.apache.gobblin.data.management.conversion.hive.utils.LineageUtils;
import org.apache.gobblin.dataset.DatasetDescriptor;
import org.apache.gobblin.dataset.Descriptor;
import org.apache.gobblin.metrics.event.lineage.LineageInfo;
import org.apache.gobblin.source.workunit.WorkUnit;

public class HiveAvroToOrcSource
extends HiveSource {
    private Optional<LineageInfo> lineageInfo;

    @Override
    public List<WorkUnit> getWorkunits(SourceState state) {
        if (!state.contains("hive.dataset.finder.class")) {
            state.setProp("hive.dataset.finder.class", (Object)ConvertibleHiveDatasetFinder.class.getName());
        }
        if (!state.contains("hive.dataset.configPrefix")) {
            state.setProp("hive.dataset.configPrefix", (Object)"hive.conversion.avro");
        }
        this.lineageInfo = LineageInfo.getLineageInfo((SharedResourcesBroker)state.getBroker());
        List<WorkUnit> workunits = super.getWorkunits(state);
        for (WorkUnit workUnit : workunits) {
            if (!LineageUtils.shouldSetLineageInfo(workUnit)) continue;
            this.setSourceLineageInfo(workUnit, this.lineageInfo);
        }
        return workunits;
    }

    @VisibleForTesting
    public void setSourceLineageInfo(WorkUnit workUnit, Optional<LineageInfo> lineageInfo) {
        HiveWorkUnit hiveWorkUnit = new HiveWorkUnit(workUnit);
        ConvertibleHiveDataset convertibleHiveDataset = (ConvertibleHiveDataset)hiveWorkUnit.getHiveDataset();
        DatasetDescriptor sourceDataset = convertibleHiveDataset.getSourceDataset();
        if (lineageInfo.isPresent()) {
            ((LineageInfo)lineageInfo.get()).setSource((Descriptor)sourceDataset, (State)workUnit);
        }
    }
}

