/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.conversion.hive.query;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.data.management.conversion.hive.entities.QueryBasedHivePublishEntity;
import org.apache.gobblin.data.management.conversion.hive.task.HiveConverterUtils;
import org.apache.gobblin.util.AvroUtils;
import org.apache.gobblin.util.HiveAvroTypeConstants;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.UnionTypeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveAvroORCQueryGenerator {
    private static final Logger log = LoggerFactory.getLogger(HiveAvroORCQueryGenerator.class);
    private static final String SERIALIZED_PUBLISH_TABLE_COMMANDS = "serialized.publish.table.commands";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final String ORC_COMPRESSION_KEY = "orc.compress";
    public static final String ORC_ROW_INDEX_STRIDE_KEY = "orc.row.index.stride";
    private static final String DEFAULT_DB_NAME = "default";
    private static final String DEFAULT_ROW_FORMAT_SERDE = "org.apache.hadoop.hive.ql.io.orc.OrcSerde";
    private static final String DEFAULT_ORC_INPUT_FORMAT = "org.apache.hadoop.hive.ql.io.orc.OrcInputFormat";
    private static final String DEFAULT_ORC_OUTPUT_FORMAT = "org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat";
    private static final String DEFAULT_ORC_COMPRESSION = "ZLIB";
    private static final String DEFAULT_ORC_ROW_INDEX_STRIDE = "268435456";
    private static final Properties DEFAULT_TBL_PROPERTIES = new Properties();
    private static final Function<Map<String, String>, String> PARTITION_SPEC_GENERATOR;
    private static final Function<String, String> QUOTE_PARTITION_VALUES;

    public static String generateCreateTableDDL(Schema schema, String tblName, String tblLocation, Optional<String> optionalDbName, Optional<Map<String, String>> optionalPartitionDDLInfo, Optional<List<String>> optionalClusterInfo, Optional<Map<String, COLUMN_SORT_ORDER>> optionalSortOrderInfo, Optional<Integer> optionalNumOfBuckets, Optional<String> optionalRowFormatSerde, Optional<String> optionalInputFormat, Optional<String> optionalOutputFormat, Properties tableProperties, boolean isEvolutionEnabled, boolean casePreserved, Optional<Table> destinationTableMeta, Map<String, String> hiveColumns) {
        Preconditions.checkNotNull((Object)schema);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)tblName));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)tblLocation));
        String dbName = optionalDbName.isPresent() ? (String)optionalDbName.get() : DEFAULT_DB_NAME;
        String rowFormatSerde = optionalRowFormatSerde.isPresent() ? (String)optionalRowFormatSerde.get() : DEFAULT_ROW_FORMAT_SERDE;
        String inputFormat = optionalInputFormat.isPresent() ? (String)optionalInputFormat.get() : DEFAULT_ORC_INPUT_FORMAT;
        String outputFormat = optionalOutputFormat.isPresent() ? (String)optionalOutputFormat.get() : DEFAULT_ORC_OUTPUT_FORMAT;
        tableProperties = HiveAvroORCQueryGenerator.getTableProperties(tableProperties);
        StringBuilder ddl = new StringBuilder();
        ddl.append(String.format("CREATE EXTERNAL TABLE IF NOT EXISTS `%s`.`%s` ", dbName, tblName));
        ddl.append("( \n");
        if (tableProperties.containsKey("schema.original")) {
            tableProperties.setProperty(tableProperties.getProperty("schema.original"), AvroUtils.sanitizeSchemaString((String)schema.toString()));
            tableProperties.remove("schema.original");
        }
        if (isEvolutionEnabled || !destinationTableMeta.isPresent()) {
            log.info("Generating DDL using source schema");
            ddl.append(HiveAvroORCQueryGenerator.generateAvroToHiveColumnMapping(schema, (Optional<Map<String, String>>)Optional.of(hiveColumns), true, dbName + "." + tblName));
            if (casePreserved) {
                try {
                    Pair<String, String> orcSchemaProps = HiveConverterUtils.getORCSchemaPropsFromAvroSchema(schema);
                    tableProperties.setProperty("columns", (String)orcSchemaProps.getLeft());
                    tableProperties.setProperty("columns.types", (String)orcSchemaProps.getRight());
                }
                catch (SerDeException e) {
                    log.error("Cannot generate add partition DDL due to ", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        } else {
            log.info("Generating DDL using destination schema");
            ddl.append(HiveAvroORCQueryGenerator.generateDestinationToHiveColumnMapping((Optional<Map<String, String>>)Optional.of(hiveColumns), (Table)destinationTableMeta.get()));
        }
        ddl.append(") \n");
        if (optionalPartitionDDLInfo.isPresent() && ((Map)optionalPartitionDDLInfo.get()).size() > 0) {
            ddl.append("PARTITIONED BY ( ");
            boolean isFirst = true;
            Map partitionInfoMap = (Map)optionalPartitionDDLInfo.get();
            for (Map.Entry entry : partitionInfoMap.entrySet()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    ddl.append(", ");
                }
                ddl.append(String.format("`%s` %s", entry.getKey(), entry.getValue()));
            }
            ddl.append(" ) \n");
        }
        if (optionalClusterInfo.isPresent()) {
            if (!optionalNumOfBuckets.isPresent()) {
                throw new IllegalArgumentException(String.format("CLUSTERED BY requested, but no NUM_BUCKETS specified for table %s.%s", dbName, tblName));
            }
            ddl.append("CLUSTERED BY ( ");
            boolean isFirst = true;
            for (Object clusterByCol : (List)optionalClusterInfo.get()) {
                if (!hiveColumns.containsKey(clusterByCol)) {
                    throw new IllegalArgumentException(String.format("Requested CLUSTERED BY column: %s is not present in schema for table %s.%s", clusterByCol, dbName, tblName));
                }
                if (isFirst) {
                    isFirst = false;
                } else {
                    ddl.append(", ");
                }
                ddl.append(String.format("`%s`", clusterByCol));
            }
            ddl.append(" ) ");
            if (optionalSortOrderInfo.isPresent() && ((Map)optionalSortOrderInfo.get()).size() > 0) {
                Map sortOrderInfoMap = (Map)optionalSortOrderInfo.get();
                ddl.append("SORTED BY ( ");
                isFirst = true;
                for (Map.Entry entry : sortOrderInfoMap.entrySet()) {
                    if (!hiveColumns.containsKey(entry.getKey())) {
                        throw new IllegalArgumentException(String.format("Requested SORTED BY column: %s is not present in schema for table %s.%s", entry.getKey(), dbName, tblName));
                    }
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        ddl.append(", ");
                    }
                    ddl.append(String.format("`%s` %s", entry.getKey(), entry.getValue()));
                }
                ddl.append(" ) ");
            }
            ddl.append(String.format(" INTO %s BUCKETS %n", optionalNumOfBuckets.get()));
        } else if (optionalSortOrderInfo.isPresent()) {
            throw new IllegalArgumentException(String.format("SORTED BY requested, but no CLUSTERED BY specified for table %s.%s", dbName, tblName));
        }
        ddl.append("ROW FORMAT SERDE \n");
        ddl.append(String.format("  '%s' %n", rowFormatSerde));
        ddl.append("STORED AS INPUTFORMAT \n");
        ddl.append(String.format("  '%s' %n", inputFormat));
        ddl.append("OUTPUTFORMAT \n");
        ddl.append(String.format("  '%s' %n", outputFormat));
        ddl.append("LOCATION \n");
        ddl.append(String.format("  '%s' %n", tblLocation));
        if (null != tableProperties && tableProperties.size() > 0) {
            ddl.append("TBLPROPERTIES ( \n");
            boolean isFirst = true;
            for (String property : tableProperties.stringPropertyNames()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    ddl.append(", \n");
                }
                ddl.append(String.format("  '%s'='%s'", property, tableProperties.getProperty(property)));
            }
            ddl.append(") \n");
        }
        return ddl.toString();
    }

    private static Properties getTableProperties(Properties tableProperties) {
        if (null == tableProperties || tableProperties.size() == 0) {
            return (Properties)DEFAULT_TBL_PROPERTIES.clone();
        }
        for (String property : DEFAULT_TBL_PROPERTIES.stringPropertyNames()) {
            if (tableProperties.containsKey(property)) continue;
            tableProperties.put(property, DEFAULT_TBL_PROPERTIES.get(property));
        }
        return tableProperties;
    }

    public static List<String> generateCreatePartitionDDL(String dbName, String tableName, String partitionLocation, Map<String, String> partitionsDMLInfo, Optional<String> format) {
        if (null == partitionsDMLInfo || partitionsDMLInfo.size() == 0) {
            return Collections.emptyList();
        }
        StringBuilder partitionSpecs = new StringBuilder();
        partitionSpecs.append("PARTITION (");
        boolean isFirstPartitionSpec = true;
        for (Map.Entry<String, String> partition : partitionsDMLInfo.entrySet()) {
            if (isFirstPartitionSpec) {
                isFirstPartitionSpec = false;
            } else {
                partitionSpecs.append(", ");
            }
            partitionSpecs.append(String.format("`%s`='%s'", partition.getKey(), partition.getValue()));
        }
        partitionSpecs.append(") \n");
        ArrayList ddls = Lists.newArrayList();
        ddls.add(String.format("USE %s%n", dbName));
        if (format.isPresent()) {
            ddls.add(String.format("ALTER TABLE `%s` ADD IF NOT EXISTS %s FILEFORMAT %s LOCATION '%s' ", tableName, partitionSpecs, format.get(), partitionLocation));
        } else {
            ddls.add(String.format("ALTER TABLE `%s` ADD IF NOT EXISTS %s LOCATION '%s' ", tableName, partitionSpecs, partitionLocation));
        }
        return ddls;
    }

    public static List<String> generateCreatePartitionDDL(String dbName, String tableName, String partitionLocation, Map<String, String> partitionsDMLInfo) {
        return HiveAvroORCQueryGenerator.generateCreatePartitionDDL(dbName, tableName, partitionLocation, partitionsDMLInfo, (Optional<String>)Optional.absent());
    }

    public static String generateDropTableDDL(String dbName, String tableName) {
        return String.format("DROP TABLE IF EXISTS `%s`.`%s`", dbName, tableName);
    }

    private static String generateAvroToHiveColumnMapping(Schema schema, Optional<Map<String, String>> hiveColumns, boolean topLevel, String datasetName) {
        if (topLevel && !schema.getType().equals((Object)Schema.Type.RECORD)) {
            throw new IllegalArgumentException(String.format("Schema for table must be of type RECORD. Received type: %s for dataset %s", schema.getType(), datasetName));
        }
        StringBuilder columns = new StringBuilder();
        switch (schema.getType()) {
            case RECORD: {
                boolean isFirst = true;
                if (topLevel) {
                    for (Schema.Field field : schema.getFields()) {
                        String flattenSource;
                        if (isFirst) {
                            isFirst = false;
                        } else {
                            columns.append(", \n");
                        }
                        String type = HiveAvroORCQueryGenerator.generateAvroToHiveColumnMapping(field.schema(), hiveColumns, false, datasetName);
                        if (hiveColumns.isPresent()) {
                            ((Map)hiveColumns.get()).put(field.name(), type);
                        }
                        if (StringUtils.isBlank((CharSequence)(flattenSource = field.getProp("flatten_source")))) {
                            flattenSource = field.name();
                        }
                        columns.append(String.format("  `%s` %s COMMENT 'from flatten_source %s'", field.name(), type, flattenSource));
                    }
                    break;
                }
                columns.append((String)HiveAvroTypeConstants.AVRO_TO_HIVE_COLUMN_MAPPING_V_12.get(schema.getType())).append("<");
                for (Schema.Field field : schema.getFields()) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        columns.append(",");
                    }
                    String type = HiveAvroORCQueryGenerator.generateAvroToHiveColumnMapping(field.schema(), hiveColumns, false, datasetName);
                    columns.append("`").append(field.name()).append("`").append(":").append(type);
                }
                columns.append(">");
                break;
            }
            case UNION: {
                Optional<Schema> optionalType = HiveAvroORCQueryGenerator.isOfOptionType(schema);
                if (optionalType.isPresent()) {
                    Schema optionalTypeSchema = (Schema)optionalType.get();
                    columns.append(HiveAvroORCQueryGenerator.generateAvroToHiveColumnMapping(optionalTypeSchema, hiveColumns, false, datasetName));
                    break;
                }
                columns.append((String)HiveAvroTypeConstants.AVRO_TO_HIVE_COLUMN_MAPPING_V_12.get(schema.getType())).append("<");
                boolean isFirst = true;
                for (Schema unionMember : schema.getTypes()) {
                    if (Schema.Type.NULL.equals((Object)unionMember.getType())) continue;
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        columns.append(",");
                    }
                    columns.append(HiveAvroORCQueryGenerator.generateAvroToHiveColumnMapping(unionMember, hiveColumns, false, datasetName));
                }
                columns.append(">");
                break;
            }
            case MAP: {
                columns.append((String)HiveAvroTypeConstants.AVRO_TO_HIVE_COLUMN_MAPPING_V_12.get(schema.getType())).append("<");
                columns.append("string,").append(HiveAvroORCQueryGenerator.generateAvroToHiveColumnMapping(schema.getValueType(), hiveColumns, false, datasetName));
                columns.append(">");
                break;
            }
            case ARRAY: {
                columns.append((String)HiveAvroTypeConstants.AVRO_TO_HIVE_COLUMN_MAPPING_V_12.get(schema.getType())).append("<");
                columns.append(HiveAvroORCQueryGenerator.generateAvroToHiveColumnMapping(schema.getElementType(), hiveColumns, false, datasetName));
                columns.append(">");
                break;
            }
            case NULL: {
                break;
            }
            case BYTES: 
            case DOUBLE: 
            case ENUM: 
            case FIXED: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case STRING: 
            case BOOLEAN: {
                boolean isLogicalTypeSet = false;
                try {
                    String hiveSpecificLogicalType = HiveAvroORCQueryGenerator.generateHiveSpecificLogicalType(schema);
                    if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{hiveSpecificLogicalType})) {
                        isLogicalTypeSet = true;
                        columns.append(hiveSpecificLogicalType);
                        break;
                    }
                }
                catch (AvroSerdeException ae) {
                    log.error("Failed to generate logical type string for field" + schema.getName() + " due to:", (Throwable)ae);
                }
                LogicalType logicalType = LogicalTypes.fromSchemaIgnoreInvalid((Schema)schema);
                if (logicalType != null) {
                    switch (logicalType.getName().toLowerCase()) {
                        case "date": {
                            LogicalTypes.Date dateType = (LogicalTypes.Date)logicalType;
                            dateType.validate(schema);
                            columns.append("date");
                            isLogicalTypeSet = true;
                            break;
                        }
                        case "decimal": {
                            LogicalTypes.Decimal decimalType = (LogicalTypes.Decimal)logicalType;
                            decimalType.validate(schema);
                            columns.append(String.format("decimal(%s, %s)", decimalType.getPrecision(), decimalType.getScale()));
                            isLogicalTypeSet = true;
                            break;
                        }
                        case "time-millis": {
                            LogicalTypes.TimeMillis timeMillsType = (LogicalTypes.TimeMillis)logicalType;
                            timeMillsType.validate(schema);
                            columns.append("timestamp");
                            isLogicalTypeSet = true;
                            break;
                        }
                        default: {
                            log.error("Unsupported logical type" + schema.getLogicalType().getName() + ", fallback to physical type");
                        }
                    }
                }
                if (isLogicalTypeSet) break;
                columns.append((String)HiveAvroTypeConstants.AVRO_TO_HIVE_COLUMN_MAPPING_V_12.get(schema.getType()));
                break;
            }
            default: {
                String exceptionMessage = String.format("DDL query generation failed for \"%s\" of dataset %s", schema, datasetName);
                log.error(exceptionMessage);
                throw new AvroRuntimeException(exceptionMessage);
            }
        }
        return columns.toString();
    }

    public static String generateHiveSpecificLogicalType(Schema schema) throws AvroSerdeException {
        Schema.Type type = schema.getType();
        if (type == Schema.Type.STRING && "varchar".equalsIgnoreCase(schema.getProp("logicalType"))) {
            int maxLength = 0;
            try {
                maxLength = schema.getJsonProp("maxLength").getValueAsInt();
            }
            catch (Exception ex) {
                throw new AvroSerdeException("Failed to obtain maxLength value from file schema: " + schema, (Throwable)ex);
            }
            return String.format("varchar(%s)", maxLength);
        }
        return "";
    }

    private static String generateDestinationToHiveColumnMapping(Optional<Map<String, String>> hiveColumns, Table destinationTableMeta) {
        StringBuilder columns = new StringBuilder();
        boolean isFirst = true;
        List fieldList = destinationTableMeta.getSd().getCols();
        for (FieldSchema field : fieldList) {
            if (isFirst) {
                isFirst = false;
            } else {
                columns.append(", \n");
            }
            String name = field.getName();
            String type = HiveAvroORCQueryGenerator.escapeHiveType(field.getType());
            String comment = field.getComment();
            if (hiveColumns.isPresent()) {
                ((Map)hiveColumns.get()).put(name, type);
            }
            columns.append(String.format("  `%s` %s COMMENT '%s'", name, type, HiveAvroORCQueryGenerator.escapeStringForHive(comment)));
        }
        return columns.toString();
    }

    public static String escapeHiveType(String type) {
        TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString((String)type);
        if (ObjectInspector.Category.PRIMITIVE.equals((Object)typeInfo.getCategory())) {
            return type;
        }
        if (ObjectInspector.Category.LIST.equals((Object)typeInfo.getCategory())) {
            ListTypeInfo listTypeInfo = (ListTypeInfo)typeInfo;
            return "array<" + HiveAvroORCQueryGenerator.escapeHiveType(listTypeInfo.getListElementTypeInfo().getTypeName()) + ">";
        }
        if (ObjectInspector.Category.MAP.equals((Object)typeInfo.getCategory())) {
            MapTypeInfo mapTypeInfo = (MapTypeInfo)typeInfo;
            return "map<" + HiveAvroORCQueryGenerator.escapeHiveType(mapTypeInfo.getMapKeyTypeInfo().getTypeName()) + "," + HiveAvroORCQueryGenerator.escapeHiveType(mapTypeInfo.getMapValueTypeInfo().getTypeName()) + ">";
        }
        if (ObjectInspector.Category.STRUCT.equals((Object)typeInfo.getCategory())) {
            StructTypeInfo structTypeInfo = (StructTypeInfo)typeInfo;
            ArrayList allStructFieldNames = structTypeInfo.getAllStructFieldNames();
            ArrayList allStructFieldTypeInfos = structTypeInfo.getAllStructFieldTypeInfos();
            StringBuilder sb = new StringBuilder();
            sb.append("struct<");
            for (int i = 0; i < allStructFieldNames.size(); ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append("`");
                sb.append((String)allStructFieldNames.get(i));
                sb.append("`");
                sb.append(":");
                sb.append(HiveAvroORCQueryGenerator.escapeHiveType(((TypeInfo)allStructFieldTypeInfos.get(i)).getTypeName()));
            }
            sb.append(">");
            return sb.toString();
        }
        if (ObjectInspector.Category.UNION.equals((Object)typeInfo.getCategory())) {
            UnionTypeInfo unionTypeInfo = (UnionTypeInfo)typeInfo;
            List allUnionObjectTypeInfos = unionTypeInfo.getAllUnionObjectTypeInfos();
            StringBuilder sb = new StringBuilder();
            sb.append("uniontype<");
            for (int i = 0; i < allUnionObjectTypeInfos.size(); ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(HiveAvroORCQueryGenerator.escapeHiveType(((TypeInfo)allUnionObjectTypeInfos.get(i)).getTypeName()));
            }
            sb.append(">");
            return sb.toString();
        }
        throw new RuntimeException("Unknown type encountered: " + type);
    }

    private static Optional<Schema> isOfOptionType(Schema schema) {
        Preconditions.checkNotNull((Object)schema);
        if (!Schema.Type.UNION.equals((Object)schema.getType())) {
            return Optional.absent();
        }
        List types = schema.getTypes();
        if (null != types && types.size() == 2) {
            Schema first = (Schema)types.get(0);
            Schema second = (Schema)types.get(1);
            if (Schema.Type.NULL.equals((Object)first.getType()) && !Schema.Type.NULL.equals((Object)second.getType())) {
                return Optional.of((Object)second);
            }
            if (!Schema.Type.NULL.equals((Object)first.getType()) && Schema.Type.NULL.equals((Object)second.getType())) {
                return Optional.of((Object)first);
            }
        }
        return Optional.absent();
    }

    public static String generateTableMappingDML(Schema inputAvroSchema, Schema outputOrcSchema, String inputTblName, String outputTblName, Optional<String> optionalInputDbName, Optional<String> optionalOutputDbName, Optional<Map<String, String>> optionalPartitionDMLInfo, Optional<Boolean> optionalOverwriteTable, Optional<Boolean> optionalCreateIfNotExists, boolean isEvolutionEnabled, Optional<Table> destinationTableMeta, Optional<Integer> rowLimit) {
        List fieldList;
        boolean isFirst;
        boolean isFirstPartitionSpec;
        Preconditions.checkNotNull((Object)inputAvroSchema);
        Preconditions.checkNotNull((Object)outputOrcSchema);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)inputTblName));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)outputTblName));
        String inputDbName = optionalInputDbName.isPresent() ? (String)optionalInputDbName.get() : DEFAULT_DB_NAME;
        String outputDbName = optionalOutputDbName.isPresent() ? (String)optionalOutputDbName.get() : DEFAULT_DB_NAME;
        boolean shouldOverwriteTable = optionalOverwriteTable.isPresent() ? (Boolean)optionalOverwriteTable.get() : true;
        boolean shouldCreateIfNotExists = optionalCreateIfNotExists.isPresent() ? (Boolean)optionalCreateIfNotExists.get() : false;
        log.debug("Input Schema: " + inputAvroSchema.toString());
        log.debug("Output Schema: " + outputOrcSchema.toString());
        StringBuilder dmlQuery = new StringBuilder();
        if (shouldOverwriteTable) {
            dmlQuery.append(String.format("INSERT OVERWRITE TABLE `%s`.`%s` %n", outputDbName, outputTblName));
        } else {
            dmlQuery.append(String.format("INSERT INTO TABLE `%s`.`%s` %n", outputDbName, outputTblName));
        }
        if (optionalPartitionDMLInfo.isPresent() && ((Map)optionalPartitionDMLInfo.get()).size() > 0) {
            dmlQuery.append("PARTITION (");
            isFirstPartitionSpec = true;
            for (Map.Entry entry : ((Map)optionalPartitionDMLInfo.get()).entrySet()) {
                if (isFirstPartitionSpec) {
                    isFirstPartitionSpec = false;
                } else {
                    dmlQuery.append(", ");
                }
                dmlQuery.append(String.format("`%s`='%s'", entry.getKey(), entry.getValue()));
            }
            dmlQuery.append(") \n");
        }
        if (shouldCreateIfNotExists) {
            dmlQuery.append(" IF NOT EXISTS \n");
        }
        dmlQuery.append("SELECT \n");
        if (isEvolutionEnabled || !destinationTableMeta.isPresent()) {
            log.info("Generating DML using source schema");
            isFirst = true;
            fieldList = outputOrcSchema.getFields();
            for (Schema.Field field : fieldList) {
                String flattenSource = field.getProp("flatten_source");
                String colName = StringUtils.isNotBlank((CharSequence)flattenSource) ? flattenSource : field.name();
                colName = colName.replaceAll("\\.", "`.`");
                if (isFirst) {
                    isFirst = false;
                } else {
                    dmlQuery.append(", \n");
                }
                dmlQuery.append(String.format("  `%s`", colName));
            }
        } else {
            log.info("Generating DML using destination schema");
            isFirst = true;
            fieldList = ((Table)destinationTableMeta.get()).getSd().getCols();
            for (Schema.Field field : fieldList) {
                String colName = "";
                if (field.isSetComment() && field.getComment().startsWith("from flatten_source ")) {
                    colName = field.getComment().replaceAll("from flatten_source ", "").trim();
                } else {
                    List evolvedFieldList = outputOrcSchema.getFields();
                    for (Schema.Field evolvedField : evolvedFieldList) {
                        if (!evolvedField.name().equalsIgnoreCase(field.getName())) continue;
                        String flattenSource = evolvedField.getProp("flatten_source");
                        if (StringUtils.isNotBlank((CharSequence)flattenSource)) {
                            colName = flattenSource;
                            break;
                        }
                        colName = evolvedField.name();
                        break;
                    }
                }
                if (!StringUtils.isNotBlank((CharSequence)(colName = colName.replaceAll("\\.", "`.`")))) continue;
                if (isFirst) {
                    isFirst = false;
                } else {
                    dmlQuery.append(", \n");
                }
                dmlQuery.append(String.format("  `%s`", colName));
            }
        }
        dmlQuery.append(String.format(" %n FROM `%s`.`%s` ", inputDbName, inputTblName));
        if (optionalPartitionDMLInfo.isPresent() && ((Map)optionalPartitionDMLInfo.get()).size() > 0) {
            dmlQuery.append("WHERE ");
            isFirstPartitionSpec = true;
            for (Map.Entry entry : ((Map)optionalPartitionDMLInfo.get()).entrySet()) {
                if (isFirstPartitionSpec) {
                    isFirstPartitionSpec = false;
                } else {
                    dmlQuery.append(" AND ");
                }
                dmlQuery.append(String.format("`%s`='%s'", entry.getKey(), entry.getValue()));
            }
            dmlQuery.append(" \n");
        }
        if (rowLimit.isPresent()) {
            dmlQuery.append(String.format("LIMIT %s", rowLimit.get()));
        }
        return dmlQuery.toString();
    }

    public static Schema readSchemaFromString(String schemaStr) throws IOException {
        return new Schema.Parser().parse(schemaStr);
    }

    public static List<String> generateEvolutionDDL(String stagingTableName, String finalTableName, Optional<String> optionalStagingDbName, Optional<String> optionalFinalDbName, Schema evolvedSchema, boolean isEvolutionEnabled, Map<String, String> evolvedColumns, Optional<Table> destinationTableMeta, Properties tableProperties) {
        if (!isEvolutionEnabled || !destinationTableMeta.isPresent()) {
            return Collections.emptyList();
        }
        String stagingDbName = optionalStagingDbName.isPresent() ? (String)optionalStagingDbName.get() : DEFAULT_DB_NAME;
        String finalDbName = optionalFinalDbName.isPresent() ? (String)optionalFinalDbName.get() : DEFAULT_DB_NAME;
        ArrayList ddl = Lists.newArrayList();
        Table destinationTable = (Table)destinationTableMeta.get();
        if (destinationTable.getSd().getCols().size() == 0) {
            log.warn("Destination Table: " + destinationTable + " does not has column details in StorageDescriptor. It is probably of Avro type. Cannot evolve via traditional HQL, so skipping evolution checks.");
            return ddl;
        }
        for (Map.Entry<String, String> evolvedColumn : evolvedColumns.entrySet()) {
            boolean found = false;
            for (FieldSchema destinationField : destinationTable.getSd().getCols()) {
                boolean typeEvolved;
                if (!destinationField.getName().equalsIgnoreCase(evolvedColumn.getKey())) continue;
                try {
                    typeEvolved = HiveAvroORCQueryGenerator.isTypeEvolved(evolvedColumn.getValue(), destinationField.getType());
                }
                catch (Exception e) {
                    throw new RuntimeException(String.format("Unable to evolve schema for table %s.%s", finalDbName, finalTableName), e);
                }
                if (typeEvolved) {
                    ddl.add(String.format("USE %s%n", finalDbName));
                    ddl.add(String.format("ALTER TABLE `%s` CHANGE COLUMN `%s` `%s` %s COMMENT '%s'", finalTableName, evolvedColumn.getKey(), evolvedColumn.getKey(), evolvedColumn.getValue(), HiveAvroORCQueryGenerator.escapeStringForHive(destinationField.getComment())));
                }
                found = true;
                break;
            }
            if (found) continue;
            String flattenSource = evolvedSchema.getField(evolvedColumn.getKey()).getProp("flatten_source");
            if (StringUtils.isBlank((CharSequence)flattenSource)) {
                flattenSource = evolvedSchema.getField(evolvedColumn.getKey()).name();
            }
            ddl.add(String.format("USE %s%n", finalDbName));
            ddl.add(String.format("ALTER TABLE `%s` ADD COLUMNS (`%s` %s COMMENT 'from flatten_source %s')", finalTableName, evolvedColumn.getKey(), evolvedColumn.getValue(), flattenSource));
        }
        ddl.add(String.format("USE %s%n", finalDbName));
        for (String property : tableProperties.stringPropertyNames()) {
            ddl.add(String.format("ALTER TABLE `%s` SET TBLPROPERTIES ('%s'='%s')", finalTableName, property, tableProperties.getProperty(property)));
        }
        return ddl;
    }

    public static List<String> generateDropPartitionsDDL(String dbName, String finalTableName, Map<String, String> partitionsDMLInfo) {
        if (null == partitionsDMLInfo || partitionsDMLInfo.isEmpty()) {
            return Collections.emptyList();
        }
        StringBuilder partitionSpecs = new StringBuilder();
        partitionSpecs.append("PARTITION (");
        boolean isFirstPartitionSpec = true;
        for (Map.Entry<String, String> partition : partitionsDMLInfo.entrySet()) {
            if (isFirstPartitionSpec) {
                isFirstPartitionSpec = false;
            } else {
                partitionSpecs.append(", ");
            }
            partitionSpecs.append(String.format("`%s`='%s'", partition.getKey(), partition.getValue()));
        }
        partitionSpecs.append(") ");
        ArrayList ddls = Lists.newArrayList();
        ddls.add(String.format("USE %s%n", dbName));
        ddls.add(String.format("ALTER TABLE %s DROP IF EXISTS %s", finalTableName, partitionSpecs));
        return ddls;
    }

    public static List<String> generateDropPartitionsDDL(String dbName, String finalTableName, List<Map<String, String>> partitionDMLInfos) {
        if (partitionDMLInfos.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList ddls = Lists.newArrayList();
        ddls.add(String.format("USE %s %n", dbName));
        ddls.add(String.format("ALTER TABLE %s DROP IF EXISTS %s", finalTableName, Joiner.on((String)",").join(Iterables.transform(partitionDMLInfos, PARTITION_SPEC_GENERATOR))));
        return ddls;
    }

    public static List<String> generateCreateOrUpdateViewDDL(String tableDbName, String tableName, String viewDbName, String viewName, boolean shouldUpdateView) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)tableName), (Object)"Table name should not be empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)viewName), (Object)"View name should not be empty");
        String resolvedTableDbName = StringUtils.isBlank((CharSequence)tableDbName) ? DEFAULT_DB_NAME : tableDbName;
        String resolvedViewDbName = StringUtils.isBlank((CharSequence)viewDbName) ? DEFAULT_DB_NAME : viewDbName;
        ArrayList ddls = Lists.newArrayList();
        ddls.add(String.format("CREATE VIEW IF NOT EXISTS `%s`.`%s` AS SELECT * FROM `%s`.`%s`", resolvedViewDbName, viewName, resolvedTableDbName, tableName));
        if (shouldUpdateView) {
            ddls.add(String.format("ALTER VIEW `%s`.`%s` AS SELECT * FROM `%s`.`%s`", resolvedViewDbName, viewName, resolvedTableDbName, tableName));
        }
        return ddls;
    }

    public static List<String> generateAlterTableOrPartitionStorageFormatDDL(String dbName, String tableName, Optional<Map<String, String>> partitionsDMLInfo, String format) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)tableName), (Object)"Table name should not be empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)format), (Object)"Format should not be empty");
        String resolvedDbName = StringUtils.isBlank((CharSequence)dbName) ? DEFAULT_DB_NAME : dbName;
        StringBuilder partitionSpecs = new StringBuilder();
        if (partitionsDMLInfo.isPresent()) {
            partitionSpecs.append("PARTITION (");
            boolean isFirstPartitionSpec = true;
            for (Map.Entry partition : ((Map)partitionsDMLInfo.get()).entrySet()) {
                if (isFirstPartitionSpec) {
                    isFirstPartitionSpec = false;
                } else {
                    partitionSpecs.append(", ");
                }
                partitionSpecs.append(String.format("`%s`='%s'", partition.getKey(), partition.getValue()));
            }
            partitionSpecs.append(") ");
        }
        ArrayList ddls = Lists.newArrayList();
        ddls.add(String.format("USE %s%n", resolvedDbName));
        ddls.add(String.format("ALTER TABLE %s %s SET FILEFORMAT %s", tableName, partitionSpecs, format));
        return ddls;
    }

    public static void serializePublishCommands(State state, QueryBasedHivePublishEntity queryBasedHivePublishEntity) {
        state.setProp(SERIALIZED_PUBLISH_TABLE_COMMANDS, (Object)GSON.toJson((Object)queryBasedHivePublishEntity));
    }

    public static QueryBasedHivePublishEntity deserializePublishCommands(State state) {
        QueryBasedHivePublishEntity queryBasedHivePublishEntity = (QueryBasedHivePublishEntity)GSON.fromJson(state.getProp(SERIALIZED_PUBLISH_TABLE_COMMANDS), QueryBasedHivePublishEntity.class);
        return queryBasedHivePublishEntity == null ? new QueryBasedHivePublishEntity() : queryBasedHivePublishEntity;
    }

    public static boolean isTypeEvolved(String evolvedType, String destinationType) {
        if (evolvedType.equalsIgnoreCase(destinationType)) {
            return false;
        }
        if (HiveAvroTypeConstants.HIVE_COMPATIBLE_TYPES.containsKey(destinationType)) {
            if (((Set)HiveAvroTypeConstants.HIVE_COMPATIBLE_TYPES.get(destinationType)).contains(evolvedType)) {
                return true;
            }
            throw new RuntimeException(String.format("Incompatible type evolution from: %s to: %s", destinationType, evolvedType));
        }
        return true;
    }

    private static String escapeStringForHive(String st) {
        char backslash = '\\';
        char singleQuote = '\'';
        char semicolon = ';';
        String escapedSingleQuote = String.valueOf(backslash) + String.valueOf(singleQuote);
        String escapedSemicolon = String.valueOf(backslash) + String.valueOf(semicolon);
        st = st.replace(String.valueOf(singleQuote), escapedSingleQuote).replace(String.valueOf(semicolon), escapedSemicolon);
        return st;
    }

    static {
        DEFAULT_TBL_PROPERTIES.setProperty(ORC_COMPRESSION_KEY, DEFAULT_ORC_COMPRESSION);
        DEFAULT_TBL_PROPERTIES.setProperty(ORC_ROW_INDEX_STRIDE_KEY, DEFAULT_ORC_ROW_INDEX_STRIDE);
        PARTITION_SPEC_GENERATOR = new Function<Map<String, String>, String>(){

            public String apply(Map<String, String> partitionDMLInfo) {
                if (partitionDMLInfo == null) {
                    return "";
                }
                return String.format(" PARTITION (%s)", Joiner.on((String)",").withKeyValueSeparator("=").join(Maps.transformValues(partitionDMLInfo, (Function)QUOTE_PARTITION_VALUES)));
            }
        };
        QUOTE_PARTITION_VALUES = new Function<String, String>(){

            public String apply(String value) {
                return String.format("'%s'", value);
            }
        };
    }

    public static enum COLUMN_SORT_ORDER {
        ASC("ASC"),
        DESC("DESC");

        private final String order;

        private COLUMN_SORT_ORDER(String s) {
            this.order = s;
        }

        public String toString() {
            return "HiveAvroORCQueryGenerator.COLUMN_SORT_ORDER." + this.name() + "(order=" + this.order + ")";
        }
    }
}

