/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.schema_check;

import java.util.HashSet;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.gobblin.util.schema_check.AvroSchemaCheckStrategy;

public class AvroSchemaCheckDefaultStrategy
implements AvroSchemaCheckStrategy {
    @Override
    public boolean compare(Schema expected, Schema toValidate) {
        if (toValidate.getType() != expected.getType() || !toValidate.getName().equals(expected.getName())) {
            return false;
        }
        switch (toValidate.getType()) {
            case NULL: 
            case BOOLEAN: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BYTES: 
            case STRING: {
                return true;
            }
            case ARRAY: {
                return this.compare(toValidate.getElementType(), expected.getElementType());
            }
            case MAP: {
                return this.compare(toValidate.getValueType(), expected.getValueType());
            }
            case FIXED: {
                return toValidate.getFixedSize() == expected.getFixedSize();
            }
            case ENUM: {
                HashSet expectedSymbols = new HashSet(expected.getEnumSymbols());
                HashSet toValidateSymbols = new HashSet(toValidate.getEnumSymbols());
                if (expectedSymbols.size() != toValidateSymbols.size()) {
                    return false;
                }
                return expectedSymbols.containsAll(toValidateSymbols);
            }
            case RECORD: {
                if (toValidate.getFields().size() != expected.getFields().size()) {
                    return false;
                }
                for (Schema.Field expectedFiled : expected.getFields()) {
                    Schema.Field toValidateField = toValidate.getField(expectedFiled.name());
                    if (toValidateField == null) {
                        return false;
                    }
                    if (this.compare(toValidateField.schema(), expectedFiled.schema())) continue;
                    return false;
                }
                return true;
            }
            case UNION: {
                if (toValidate.getTypes().size() != expected.getTypes().size()) {
                    return false;
                }
                HashSet types = new HashSet(expected.getTypes());
                for (Schema toValidateType : toValidate.getTypes()) {
                    Schema equalSchema = null;
                    for (Schema type : types) {
                        if (!this.compare(type, toValidateType)) continue;
                        equalSchema = type;
                        break;
                    }
                    if (equalSchema == null) {
                        return false;
                    }
                    types.remove(equalSchema);
                }
                return true;
            }
        }
        throw new AvroRuntimeException("Unknown schema type: " + toValidate.getType());
    }
}

