/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.retention.profile;

import com.google.common.base.Optional;
import java.util.Properties;
import org.apache.gobblin.data.management.retention.profile.MultiDatasetFinder;
import org.apache.gobblin.metrics.event.EventSubmitter;
import org.apache.hadoop.fs.FileSystem;

public class MultiCleanableDatasetFinder
extends MultiDatasetFinder {
    public static final String TAGS_TO_IMPORT_KEY = "gobblin.retention.tag";
    public static final String DATASET_FINDER_CLASS_KEY = "gobblin.retention.dataset.finder.class";
    public static final String DEPRECATED_DATASET_PROFILE_CLASS_KEY = "gobblin.retention.dataset.profile.class";

    public MultiCleanableDatasetFinder(FileSystem fs, Properties jobProps) {
        this(fs, jobProps, new EventSubmitter.Builder(Optional.absent(), "noMessage").build());
    }

    public MultiCleanableDatasetFinder(FileSystem fs, Properties jobProps, EventSubmitter eventSubmitter) {
        super(fs, jobProps, eventSubmitter);
    }

    @Override
    protected String datasetFinderClassKey() {
        if (this.jobProps.containsKey(DEPRECATED_DATASET_PROFILE_CLASS_KEY)) {
            return DEPRECATED_DATASET_PROFILE_CLASS_KEY;
        }
        return DATASET_FINDER_CLASS_KEY;
    }

    @Override
    protected String datasetFinderImportedByKey() {
        return TAGS_TO_IMPORT_KEY;
    }
}

