/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.retention.dataset;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.gobblin.data.management.policy.EmbeddedRetentionSelectionPolicy;
import org.apache.gobblin.data.management.policy.SelectNothingPolicy;
import org.apache.gobblin.data.management.policy.VersionSelectionPolicy;
import org.apache.gobblin.data.management.retention.action.RetentionAction;
import org.apache.gobblin.data.management.retention.dataset.CleanableDataset;
import org.apache.gobblin.data.management.retention.dataset.FsCleanableHelper;
import org.apache.gobblin.data.management.retention.policy.RetentionPolicy;
import org.apache.gobblin.data.management.trash.ProxiedTrash;
import org.apache.gobblin.data.management.version.FileSystemDatasetVersion;
import org.apache.gobblin.data.management.version.finder.VersionFinder;
import org.apache.gobblin.dataset.FileSystemDataset;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.hadoop.fs.FileSystem;
import org.slf4j.Logger;

public abstract class MultiVersionCleanableDatasetBase<T extends FileSystemDatasetVersion>
implements CleanableDataset,
FileSystemDataset {
    @Deprecated
    public static final String CONFIGURATION_KEY_PREFIX = "gobblin.retention.";
    @Deprecated
    public static final String SIMULATE_KEY = "gobblin.retention.simulate";
    public static final String SIMULATE_DEFAULT = FsCleanableHelper.SIMULATE_DEFAULT;
    @Deprecated
    public static final String SKIP_TRASH_KEY = "gobblin.retention.skip.trash";
    public static final String SKIP_TRASH_DEFAULT = FsCleanableHelper.SKIP_TRASH_DEFAULT;
    @Deprecated
    public static final String DELETE_EMPTY_DIRECTORIES_KEY = "gobblin.retention.delete.empty.directories";
    public static final String DELETE_EMPTY_DIRECTORIES_DEFAULT = FsCleanableHelper.DELETE_EMPTY_DIRECTORIES_DEFAULT;
    @Deprecated
    public static final String DELETE_AS_OWNER_KEY = "gobblin.retention.delete.as.owner";
    public static final String DELETE_AS_OWNER_DEFAULT = FsCleanableHelper.DELETE_AS_OWNER_DEFAULT;
    public static final String IS_DATASET_BLACKLISTED_KEY = "gobblin.retention.dataset.is.blacklisted";
    public static final String IS_DATASET_BLACKLISTED_DEFAULT = Boolean.toString(false);
    protected final FileSystem fs;
    @Deprecated
    protected final ProxiedTrash trash;
    @VisibleForTesting
    protected final boolean isDatasetBlacklisted;
    private final FsCleanableHelper fsCleanableHelper;
    protected final Logger log;
    @Deprecated
    protected final boolean simulate;
    @Deprecated
    protected final boolean skipTrash;
    @Deprecated
    protected final boolean deleteEmptyDirectories;
    @Deprecated
    protected final boolean deleteAsOwner;

    public abstract List<VersionFinderAndPolicy<T>> getVersionFindersAndPolicies();

    public MultiVersionCleanableDatasetBase(FileSystem fs, Properties props, Config config, Logger log) throws IOException {
        this(fs, props, Boolean.valueOf(props.getProperty(SIMULATE_KEY, SIMULATE_DEFAULT)), Boolean.valueOf(props.getProperty(SKIP_TRASH_KEY, SKIP_TRASH_DEFAULT)), Boolean.valueOf(props.getProperty(DELETE_EMPTY_DIRECTORIES_KEY, DELETE_EMPTY_DIRECTORIES_DEFAULT)), Boolean.valueOf(props.getProperty(DELETE_AS_OWNER_KEY, DELETE_AS_OWNER_DEFAULT)), ConfigUtils.getBoolean((Config)config, (String)IS_DATASET_BLACKLISTED_KEY, (boolean)Boolean.valueOf(IS_DATASET_BLACKLISTED_DEFAULT)), log);
    }

    public MultiVersionCleanableDatasetBase(FileSystem fs, Properties props, Logger log) throws IOException {
        this(fs, props, ConfigFactory.parseMap((Map)ImmutableMap.of((Object)IS_DATASET_BLACKLISTED_KEY, (Object)IS_DATASET_BLACKLISTED_DEFAULT)), log);
    }

    public MultiVersionCleanableDatasetBase(FileSystem fs, Properties properties, boolean simulate, boolean skipTrash, boolean deleteEmptyDirectories, boolean deleteAsOwner, boolean isDatasetBlacklisted, Logger log) throws IOException {
        this.log = log;
        this.fsCleanableHelper = new FsCleanableHelper(fs, properties, simulate, skipTrash, deleteEmptyDirectories, deleteAsOwner, log);
        this.fs = fs;
        this.simulate = simulate;
        this.skipTrash = skipTrash;
        this.deleteEmptyDirectories = deleteEmptyDirectories;
        this.trash = this.fsCleanableHelper.getTrash();
        this.deleteAsOwner = deleteAsOwner;
        this.isDatasetBlacklisted = isDatasetBlacklisted;
    }

    public MultiVersionCleanableDatasetBase(FileSystem fs, Properties properties, boolean simulate, boolean skipTrash, boolean deleteEmptyDirectories, boolean deleteAsOwner, Logger log) throws IOException {
        this(fs, properties, simulate, skipTrash, deleteEmptyDirectories, deleteAsOwner, Boolean.parseBoolean(IS_DATASET_BLACKLISTED_DEFAULT), log);
    }

    @Override
    public void clean() throws IOException {
        if (this.isDatasetBlacklisted) {
            this.log.info("Dataset blacklisted. Cleanup skipped for " + this.datasetRoot());
            return;
        }
        boolean atLeastOneFailureSeen = false;
        for (VersionFinderAndPolicy<T> versionFinderAndPolicy : this.getVersionFindersAndPolicies()) {
            VersionSelectionPolicy<T> selectionPolicy = versionFinderAndPolicy.getVersionSelectionPolicy();
            VersionFinder<T> versionFinder = versionFinderAndPolicy.getVersionFinder();
            if (!selectionPolicy.versionClass().isAssignableFrom(versionFinder.versionClass())) {
                throw new IOException("Incompatible dataset version classes.");
            }
            this.log.info(String.format("Cleaning dataset %s. Using version finder %s and policy %s", this, versionFinder.getClass().getName(), selectionPolicy));
            ArrayList versions = Lists.newArrayList(versionFinder.findDatasetVersions(this));
            if (versions.isEmpty()) {
                this.log.warn("No dataset version can be found. Ignoring.");
                continue;
            }
            Collections.sort(versions, Collections.reverseOrder());
            Collection<T> deletableVersions = selectionPolicy.listSelectedVersions(versions);
            this.cleanImpl(deletableVersions);
            ArrayList allVersions = Lists.newArrayList();
            for (FileSystemDatasetVersion ver : versions) {
                allVersions.add(ver);
            }
            for (RetentionAction retentionAction : versionFinderAndPolicy.getRetentionActions()) {
                try {
                    retentionAction.execute(allVersions);
                }
                catch (Throwable t) {
                    atLeastOneFailureSeen = true;
                    this.log.error(String.format("RetentionAction %s failed for dataset %s", retentionAction.getClass().getName(), this.datasetRoot()), t);
                }
            }
        }
        if (atLeastOneFailureSeen) {
            throw new RuntimeException(String.format("At least one failure happened while processing %s. Look for previous logs for failures", this.datasetRoot()));
        }
    }

    protected void cleanImpl(Collection<T> deletableVersions) throws IOException {
        this.fsCleanableHelper.clean(deletableVersions, this);
    }

    public String toString() {
        return this.datasetRoot().toString();
    }

    public String datasetURN() {
        return this.datasetRoot().toString();
    }

    public boolean isDatasetBlacklisted() {
        return this.isDatasetBlacklisted;
    }

    public static class VersionFinderAndPolicy<T extends FileSystemDatasetVersion> {
        private final VersionSelectionPolicy<T> versionSelectionPolicy;
        private final VersionFinder<? extends T> versionFinder;
        private final List<RetentionAction> retentionActions;
        private final Config config;

        @Deprecated
        public VersionFinderAndPolicy(VersionSelectionPolicy<T> versionSelectionPolicy, VersionFinder<? extends T> versionFinder, Config config) {
            this.versionSelectionPolicy = versionSelectionPolicy;
            this.versionFinder = versionFinder;
            this.retentionActions = Lists.newArrayList();
            this.config = config;
        }

        public VersionFinderAndPolicy(RetentionPolicy<T> retentionPolicy, VersionFinder<? extends T> versionFinder, Config config) {
            this(new EmbeddedRetentionSelectionPolicy<T>(retentionPolicy), versionFinder, config);
        }

        public static <T extends FileSystemDatasetVersion> VersionFinderAndPolicyBuilder<T> builder() {
            return new VersionFinderAndPolicyBuilder();
        }

        public VersionSelectionPolicy<T> getVersionSelectionPolicy() {
            return this.versionSelectionPolicy;
        }

        public VersionFinder<? extends T> getVersionFinder() {
            return this.versionFinder;
        }

        public List<RetentionAction> getRetentionActions() {
            return this.retentionActions;
        }

        public Config getConfig() {
            return this.config;
        }

        @ConstructorProperties(value={"versionSelectionPolicy", "versionFinder", "retentionActions", "config"})
        public VersionFinderAndPolicy(VersionSelectionPolicy<T> versionSelectionPolicy, VersionFinder<? extends T> versionFinder, List<RetentionAction> retentionActions, Config config) {
            this.versionSelectionPolicy = versionSelectionPolicy;
            this.versionFinder = versionFinder;
            this.retentionActions = retentionActions;
            this.config = config;
        }

        public static class VersionFinderAndPolicyBuilder<T extends FileSystemDatasetVersion> {
            private VersionSelectionPolicy<T> versionSelectionPolicy;
            private VersionFinder<? extends T> versionFinder;
            private ArrayList<RetentionAction> retentionActions;
            private Config config;

            public VersionFinderAndPolicy<T> build() {
                SelectNothingPolicy localVersionSelectionPolicy = this.versionSelectionPolicy == null ? new SelectNothingPolicy(new Properties()) : this.versionSelectionPolicy;
                ArrayList localRetentionActions = this.retentionActions == null ? Lists.newArrayList() : Lists.newArrayList(this.retentionActions);
                return new VersionFinderAndPolicy<T>(localVersionSelectionPolicy, this.versionFinder, localRetentionActions, this.config);
            }

            VersionFinderAndPolicyBuilder() {
            }

            public VersionFinderAndPolicyBuilder<T> versionSelectionPolicy(VersionSelectionPolicy<T> versionSelectionPolicy) {
                this.versionSelectionPolicy = versionSelectionPolicy;
                return this;
            }

            public VersionFinderAndPolicyBuilder<T> versionFinder(VersionFinder<? extends T> versionFinder) {
                this.versionFinder = versionFinder;
                return this;
            }

            public VersionFinderAndPolicyBuilder<T> retentionAction(RetentionAction retentionAction) {
                if (this.retentionActions == null) {
                    this.retentionActions = new ArrayList();
                }
                this.retentionActions.add(retentionAction);
                return this;
            }

            public VersionFinderAndPolicyBuilder<T> retentionActions(Collection<? extends RetentionAction> retentionActions) {
                if (this.retentionActions == null) {
                    this.retentionActions = new ArrayList();
                }
                this.retentionActions.addAll(retentionActions);
                return this;
            }

            public VersionFinderAndPolicyBuilder<T> clearRetentionActions() {
                if (this.retentionActions != null) {
                    this.retentionActions.clear();
                }
                return this;
            }

            public VersionFinderAndPolicyBuilder<T> config(Config config) {
                this.config = config;
                return this;
            }

            public String toString() {
                return "MultiVersionCleanableDatasetBase.VersionFinderAndPolicy.VersionFinderAndPolicyBuilder(versionSelectionPolicy=" + this.versionSelectionPolicy + ", versionFinder=" + this.versionFinder + ", retentionActions=" + this.retentionActions + ", config=" + this.config + ")";
            }
        }
    }
}

