/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.retention.dataset;

import com.typesafe.config.Config;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.gobblin.data.management.trash.ProxiedTrash;
import org.apache.gobblin.data.management.trash.TrashFactory;
import org.apache.gobblin.data.management.version.FileSystemDatasetVersion;
import org.apache.gobblin.dataset.FileSystemDataset;
import org.apache.gobblin.util.PathUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;

public class FsCleanableHelper {
    public static final String CONFIGURATION_KEY_PREFIX = "gobblin.retention.";
    public static final String SIMULATE_KEY = "gobblin.retention.simulate";
    public static final String SIMULATE_DEFAULT = Boolean.toString(false);
    public static final String SKIP_TRASH_KEY = "gobblin.retention.skip.trash";
    public static final String SKIP_TRASH_DEFAULT = Boolean.toString(false);
    public static final String DELETE_EMPTY_DIRECTORIES_KEY = "gobblin.retention.delete.empty.directories";
    public static final String DELETE_EMPTY_DIRECTORIES_DEFAULT = Boolean.toString(true);
    public static final String DELETE_AS_OWNER_KEY = "gobblin.retention.delete.as.owner";
    public static final String DELETE_AS_OWNER_DEFAULT = Boolean.toString(true);
    protected final FileSystem fs;
    protected final ProxiedTrash trash;
    protected final boolean simulate;
    protected final boolean skipTrash;
    protected final boolean deleteEmptyDirectories;
    protected final boolean deleteAsOwner;
    protected final Logger log;

    public FsCleanableHelper(FileSystem fs, Properties properties, boolean simulate, boolean skipTrash, boolean deleteEmptyDirectories, boolean deleteAsOwner, Logger log) throws IOException {
        this.log = log;
        this.fs = fs;
        this.simulate = simulate;
        this.skipTrash = skipTrash;
        this.deleteEmptyDirectories = deleteEmptyDirectories;
        Properties thisProperties = new Properties();
        thisProperties.putAll((Map<?, ?>)properties);
        if (this.simulate) {
            thisProperties.setProperty("gobblin.trash.simulate", Boolean.toString(true));
        }
        if (this.skipTrash) {
            thisProperties.setProperty("gobblin.trash.skip.trash", Boolean.toString(true));
        }
        this.trash = TrashFactory.createProxiedTrash(this.fs, thisProperties);
        this.deleteAsOwner = deleteAsOwner;
    }

    public FsCleanableHelper(FileSystem fs, Properties props, Config config, Logger log) throws IOException {
        this(fs, props, Boolean.valueOf(props.getProperty(SIMULATE_KEY, SIMULATE_DEFAULT)), Boolean.valueOf(props.getProperty(SKIP_TRASH_KEY, SKIP_TRASH_DEFAULT)), Boolean.valueOf(props.getProperty(DELETE_EMPTY_DIRECTORIES_KEY, DELETE_EMPTY_DIRECTORIES_DEFAULT)), Boolean.valueOf(props.getProperty(DELETE_AS_OWNER_KEY, DELETE_AS_OWNER_DEFAULT)), log);
    }

    public void clean(FileSystemDatasetVersion versionToDelete, Set<Path> possiblyEmptyDirectories) throws IOException {
        this.log.info("Deleting dataset version " + versionToDelete);
        Set<Path> pathsToDelete = versionToDelete.getPaths();
        this.log.info("Deleting paths: " + Arrays.toString(pathsToDelete.toArray()));
        boolean deletedAllPaths = true;
        for (Path path : pathsToDelete) {
            boolean successfullyDeleted;
            if (!this.fs.exists(path)) {
                this.log.info(String.format("Path %s in dataset version %s does not exist", path, versionToDelete));
                continue;
            }
            boolean bl = successfullyDeleted = this.deleteAsOwner ? this.trash.moveToTrashAsOwner(path) : this.trash.moveToTrash(path);
            if (successfullyDeleted) {
                possiblyEmptyDirectories.add(path.getParent());
                continue;
            }
            this.log.error("Failed to delete path " + path + " in dataset version " + versionToDelete);
            deletedAllPaths = false;
        }
        if (!deletedAllPaths) {
            this.log.error("Failed to delete some paths in dataset version " + versionToDelete);
        }
    }

    public void clean(Collection<? extends FileSystemDatasetVersion> deletableVersions, FileSystemDataset fsDataset) throws IOException {
        if (deletableVersions.isEmpty()) {
            this.log.warn("No deletable dataset version can be found. Ignoring.");
            return;
        }
        HashSet<Path> possiblyEmptyDirectories = new HashSet<Path>();
        for (FileSystemDatasetVersion fileSystemDatasetVersion : deletableVersions) {
            this.clean(fileSystemDatasetVersion, possiblyEmptyDirectories);
        }
        this.cleanEmptyDirectories(possiblyEmptyDirectories, fsDataset);
    }

    public void cleanEmptyDirectories(Set<Path> possiblyEmptyDirectories, FileSystemDataset fsDataset) throws IOException {
        if (this.deleteEmptyDirectories && !this.simulate) {
            for (Path parentDirectory : possiblyEmptyDirectories) {
                PathUtils.deleteEmptyParentDirectories((FileSystem)this.fs, (Path)fsDataset.datasetRoot(), (Path)parentDirectory);
            }
        }
    }

    public ProxiedTrash getTrash() {
        return this.trash;
    }
}

