/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.retention.action;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigRenderOptions;
import java.io.IOException;
import java.util.List;
import org.apache.gobblin.data.management.retention.action.AccessControlAction;
import org.apache.gobblin.data.management.retention.action.RetentionAction;
import org.apache.gobblin.data.management.version.DatasetVersion;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.hadoop.fs.FileSystem;

public class MultiAccessControlAction
extends RetentionAction {
    private final List<AccessControlAction> embeddedAccessControlActions = Lists.newArrayList();
    private static final String POLICIES_KEY = "policies";

    private MultiAccessControlAction(Config actionConfig, FileSystem fs, Config jobConfig) {
        super(actionConfig, fs, jobConfig);
        for (String policy : ConfigUtils.getStringList((Config)actionConfig, (String)POLICIES_KEY)) {
            Preconditions.checkArgument((boolean)actionConfig.hasPath(policy), (Object)String.format("Policy %s is specified at key %s but actionConfig does not have config for this policy.Complete actionConfig %s", policy, POLICIES_KEY, actionConfig.root().render(ConfigRenderOptions.concise())));
            this.embeddedAccessControlActions.add(new AccessControlAction(actionConfig.getConfig(policy), fs, jobConfig));
        }
    }

    @Override
    public void execute(List<DatasetVersion> allVersions) throws IOException {
        for (AccessControlAction aca : this.embeddedAccessControlActions) {
            aca.execute(allVersions);
        }
    }

    public static class MultiAccessControlActionFactory
    implements RetentionAction.RetentionActionFactory {
        private static String ACCESS_CONTROL_KEY = "accessControl";
        private static String LEGACY_ACCESS_CONTROL_KEY = "gobblin.retention." + ACCESS_CONTROL_KEY;

        @Override
        public MultiAccessControlAction createRetentionAction(Config config, FileSystem fs, Config jobConfig) {
            Preconditions.checkArgument((boolean)this.canCreateWithConfig(config), (Object)("Can not create MultiAccessControlAction with config " + config.root().render(ConfigRenderOptions.concise())));
            if (config.hasPath(LEGACY_ACCESS_CONTROL_KEY)) {
                return new MultiAccessControlAction(config.getConfig(LEGACY_ACCESS_CONTROL_KEY), fs, jobConfig);
            }
            if (config.hasPath(ACCESS_CONTROL_KEY)) {
                return new MultiAccessControlAction(config.getConfig(ACCESS_CONTROL_KEY), fs, jobConfig);
            }
            throw new IllegalStateException("RetentionActionFactory.canCreateWithConfig returned true but could not create MultiAccessControlAction");
        }

        @Override
        public boolean canCreateWithConfig(Config config) {
            return config.hasPath(LEGACY_ACCESS_CONTROL_KEY) || config.hasPath(ACCESS_CONTROL_KEY);
        }
    }
}

