/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.partition;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import lombok.NonNull;
import org.apache.gobblin.data.management.copy.CopyEntity;
import org.apache.gobblin.data.management.copy.CopyableFile;
import org.apache.gobblin.data.management.partition.StaticFileSet;
import org.apache.gobblin.dataset.Dataset;
import org.apache.gobblin.util.request_allocation.Request;
import org.apache.gobblin.util.request_allocation.Requestor;

public abstract class FileSet<T extends CopyEntity>
implements Request<FileSet<CopyEntity>> {
    @NonNull
    private final String name;
    private final Dataset dataset;
    private ImmutableList<T> generatedEntities;
    private long totalSize = -1L;
    private int totalEntities = -1;
    private Requestor<FileSet<CopyEntity>> requestor;

    public ImmutableList<T> getFiles() {
        this.ensureFilesGenerated();
        return this.generatedEntities;
    }

    public long getTotalSizeInBytes() {
        this.ensureStatsComputed();
        return this.totalSize;
    }

    public int getTotalEntities() {
        this.ensureStatsComputed();
        return this.totalEntities;
    }

    private void ensureFilesGenerated() {
        if (this.generatedEntities == null) {
            try {
                this.generatedEntities = ImmutableList.copyOf(this.generateCopyEntities());
            }
            catch (Exception exc) {
                throw new RuntimeException("Failed to generate files for file set " + this.name, exc);
            }
            this.recomputeStats();
        }
    }

    private void ensureStatsComputed() {
        this.ensureFilesGenerated();
        if (this.totalEntities < 0 || this.totalSize < 0L) {
            this.recomputeStats();
        }
    }

    private void recomputeStats() {
        this.totalEntities = this.generatedEntities.size();
        this.totalSize = 0L;
        for (CopyEntity copyEntity : this.generatedEntities) {
            if (!(copyEntity instanceof CopyableFile)) continue;
            this.totalSize += ((CopyableFile)copyEntity).getOrigin().getLen();
        }
    }

    protected abstract Collection<T> generateCopyEntities() throws IOException;

    public String toString() {
        return this.dataset.datasetURN() + "@" + this.name;
    }

    @ConstructorProperties(value={"name", "dataset"})
    protected FileSet(@NonNull String name, Dataset dataset) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.name = name;
        this.dataset = dataset;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public void setRequestor(Requestor<FileSet<CopyEntity>> requestor) {
        this.requestor = requestor;
    }

    public Requestor<FileSet<CopyEntity>> getRequestor() {
        return this.requestor;
    }

    public static class Builder<T extends CopyEntity> {
        private final String name;
        private final List<T> files = Lists.newArrayList();
        private final Dataset dataset;

        public Builder(String name, Dataset dataset) {
            if (name == null) {
                throw new RuntimeException("Name cannot be null.");
            }
            this.name = name;
            this.dataset = dataset;
        }

        public Builder<T> add(T t) {
            this.files.add(t);
            return this;
        }

        public Builder<T> add(Collection<T> collection) {
            this.files.addAll(collection);
            return this;
        }

        public FileSet<T> build() {
            return new StaticFileSet<T>(this.name, this.dataset, this.files);
        }
    }
}

