/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy.hive;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Closer;
import com.google.gson.Gson;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.beans.ConstructorProperties;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.gobblin.commit.CommitStep;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.data.management.copy.CopyConfiguration;
import org.apache.gobblin.data.management.copy.CopyEntity;
import org.apache.gobblin.data.management.copy.CopyableFile;
import org.apache.gobblin.data.management.copy.OwnerAndPermission;
import org.apache.gobblin.data.management.copy.entities.PostPublishStep;
import org.apache.gobblin.data.management.copy.hive.HiveDataset;
import org.apache.gobblin.data.management.copy.hive.HiveLocationDescriptor;
import org.apache.gobblin.data.management.copy.hive.HivePartitionExtendedFilter;
import org.apache.gobblin.data.management.copy.hive.HivePartitionExtendedFilterFactory;
import org.apache.gobblin.data.management.copy.hive.HivePartitionFileSet;
import org.apache.gobblin.data.management.copy.hive.HivePartitionsDeregisterFileSet;
import org.apache.gobblin.data.management.copy.hive.HiveTableLocationNotMatchException;
import org.apache.gobblin.data.management.copy.hive.HiveTargetPathHelper;
import org.apache.gobblin.data.management.copy.hive.HiveUtils;
import org.apache.gobblin.data.management.copy.hive.PartitionFilterGenerator;
import org.apache.gobblin.data.management.copy.hive.UnpartitionedTableFileSet;
import org.apache.gobblin.data.management.copy.hive.avro.HiveAvroCopyEntityHelper;
import org.apache.gobblin.data.management.partition.FileSet;
import org.apache.gobblin.dataset.DatasetDescriptor;
import org.apache.gobblin.hive.HiveMetastoreClientPool;
import org.apache.gobblin.hive.HiveRegProps;
import org.apache.gobblin.hive.HiveRegisterStep;
import org.apache.gobblin.hive.PartitionDeregisterStep;
import org.apache.gobblin.hive.TableDeregisterStep;
import org.apache.gobblin.hive.metastore.HiveMetaStoreUtils;
import org.apache.gobblin.hive.spec.HiveSpec;
import org.apache.gobblin.hive.spec.SimpleHiveSpec;
import org.apache.gobblin.metrics.event.EventSubmitter;
import org.apache.gobblin.metrics.event.MultiTimingEvent;
import org.apache.gobblin.util.ClassAliasResolver;
import org.apache.gobblin.util.PathUtils;
import org.apache.gobblin.util.commit.DeleteFileCommitStep;
import org.apache.gobblin.util.filesystem.DataFileVersionStrategy;
import org.apache.gobblin.util.filesystem.ModTimeDataFileVersionStrategy;
import org.apache.gobblin.util.reflection.GobblinConstructorUtils;
import org.apache.gobblin.util.request_allocation.PushDownRequestor;
import org.apache.gobblin.util.request_allocation.Requestor;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InvalidInputException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveCopyEntityHelper {
    private static final Logger log = LoggerFactory.getLogger(HiveCopyEntityHelper.class);
    public static final String EXISTING_ENTITY_POLICY_KEY = "hive.dataset.existing.entity.conflict.policy";
    public static final String DEFAULT_EXISTING_ENTITY_POLICY = ExistingEntityPolicy.ABORT.name();
    public static final String UNMANAGED_DATA_POLICY_KEY = "hive.dataset.unmanaged.data.conflict.policy";
    public static final String DEFAULT_UNMANAGED_DATA_POLICY = UnmanagedDataPolicy.ABORT.name();
    public static final String TARGET_METASTORE_URI_KEY = "hive.dataset.copy.target.metastore.uri";
    public static final String TARGET_DATABASE_KEY = "hive.dataset.copy.target.database";
    public static final String COPY_PARTITIONS_FILTER_CONSTANT = "hive.dataset.copy.partition.filter.constant";
    public static final String COPY_PARTITION_FILTER_GENERATOR = "hive.dataset.copy.partition.filter.generator";
    public static final String FAST_PARTITION_SKIP_PREDICATE = "hive.dataset.copy.fast.partition.skip.predicate";
    public static final String FAST_TABLE_SKIP_PREDICATE = "hive.dataset.copy.fast.table.skip.predicate";
    public static final String DELETE_FILES_ON_DEREGISTER = "hive.dataset.copy.deregister.fileDeleteMethod";
    public static final DeregisterFileDeleteMethod DEFAULT_DEREGISTER_DELETE_METHOD = DeregisterFileDeleteMethod.NO_DELETE;
    public static final String HIVE_PARTITION_EXTENDED_FILTER_TYPE = "hive.dataset.extendedFilterType";
    static final Gson gson = new Gson();
    private static final String source_client = "source_client";
    private static final String target_client = "target_client";
    public static final String GOBBLIN_DISTCP = "gobblin-distcp";
    private final long startTime;
    private final HiveDataset dataset;
    private final CopyConfiguration configuration;
    private final FileSystem targetFs;
    private final HiveMetastoreClientPool targetClientPool;
    private final String targetDatabase;
    private final HiveRegProps hiveRegProps;
    private Optional<org.apache.hadoop.hive.ql.metadata.Table> existingTargetTable;
    private final org.apache.hadoop.hive.ql.metadata.Table targetTable;
    private final Optional<String> targetURI;
    private final ExistingEntityPolicy existingEntityPolicy;
    private final UnmanagedDataPolicy unmanagedDataPolicy;
    private final Optional<String> partitionFilter;
    private Optional<? extends HivePartitionExtendedFilter> hivePartitionExtendedFilter;
    private final Optional<Predicate<HivePartitionFileSet>> fastPartitionSkip;
    private final Optional<Predicate<HiveCopyEntityHelper>> fastTableSkip;
    private final DeregisterFileDeleteMethod deleteMethod;
    private final Optional<CommitStep> tableRegistrationStep;
    private final Map<List<String>, Partition> sourcePartitions;
    private final Map<List<String>, Partition> targetPartitions;
    private final boolean enforceFileSizeMatch;
    private final EventSubmitter eventSubmitter;
    protected final HiveTargetPathHelper targetPathHelper;

    HiveCopyEntityHelper(HiveDataset dataset, CopyConfiguration configuration, FileSystem targetFs) throws IOException {
        try (Closer closer = Closer.create();){
            log.info("Finding copy entities for table " + dataset.table.getCompleteName());
            this.eventSubmitter = new EventSubmitter.Builder(dataset.getMetricContext(), "hive.dataset.copy").build();
            MultiTimingEvent multiTimer = (MultiTimingEvent)closer.register((Closeable)new MultiTimingEvent(this.eventSubmitter, "HiveCopySetup", true));
            this.startTime = System.currentTimeMillis();
            this.dataset = dataset;
            this.configuration = configuration;
            this.targetFs = targetFs;
            this.targetPathHelper = new HiveTargetPathHelper(this.dataset);
            this.enforceFileSizeMatch = configuration.isEnforceFileLengthMatch();
            this.hiveRegProps = new HiveRegProps(new State(this.dataset.getProperties()));
            this.targetURI = Optional.fromNullable((Object)this.dataset.getProperties().getProperty(TARGET_METASTORE_URI_KEY));
            this.targetClientPool = HiveMetastoreClientPool.get((Properties)this.dataset.getProperties(), this.targetURI);
            this.targetDatabase = (String)Optional.fromNullable((Object)this.dataset.getProperties().getProperty(TARGET_DATABASE_KEY)).or((Object)this.dataset.table.getDbName());
            this.existingEntityPolicy = ExistingEntityPolicy.valueOf(this.dataset.getProperties().getProperty(EXISTING_ENTITY_POLICY_KEY, DEFAULT_EXISTING_ENTITY_POLICY).toUpperCase());
            this.unmanagedDataPolicy = UnmanagedDataPolicy.valueOf(this.dataset.getProperties().getProperty(UNMANAGED_DATA_POLICY_KEY, DEFAULT_UNMANAGED_DATA_POLICY).toUpperCase());
            DeregisterFileDeleteMethod deregisterFileDeleteMethod = this.deleteMethod = this.dataset.getProperties().containsKey(DELETE_FILES_ON_DEREGISTER) ? DeregisterFileDeleteMethod.valueOf(this.dataset.getProperties().getProperty(DELETE_FILES_ON_DEREGISTER).toUpperCase()) : DEFAULT_DEREGISTER_DELETE_METHOD;
            if (this.dataset.getProperties().containsKey(COPY_PARTITION_FILTER_GENERATOR)) {
                try {
                    PartitionFilterGenerator generator = (PartitionFilterGenerator)GobblinConstructorUtils.invokeFirstConstructor(Class.forName(this.dataset.getProperties().getProperty(COPY_PARTITION_FILTER_GENERATOR)), (List[])new List[]{Lists.newArrayList((Object[])new Object[]{this.dataset.getProperties()}), Lists.newArrayList()});
                    this.partitionFilter = Optional.of((Object)generator.getFilter(this.dataset));
                    log.info(String.format("Dynamic partition filter for table %s: %s.", this.dataset.table.getCompleteName(), this.partitionFilter.get()));
                }
                catch (ReflectiveOperationException roe) {
                    throw new IOException(roe);
                }
            } else {
                this.partitionFilter = Optional.fromNullable((Object)this.dataset.getProperties().getProperty(COPY_PARTITIONS_FILTER_CONSTANT));
            }
            if (this.dataset.getProperties().containsKey(HIVE_PARTITION_EXTENDED_FILTER_TYPE)) {
                String filterType = dataset.getProperties().getProperty(HIVE_PARTITION_EXTENDED_FILTER_TYPE);
                try {
                    Config config = ConfigFactory.parseProperties((Properties)this.dataset.getProperties());
                    this.hivePartitionExtendedFilter = Optional.of((Object)((HivePartitionExtendedFilterFactory)new ClassAliasResolver(HivePartitionExtendedFilterFactory.class).resolveClass(filterType).newInstance()).createFilter(config));
                }
                catch (ReflectiveOperationException roe) {
                    log.error("Error: Could not find filter with alias " + filterType);
                    closer.close();
                    throw new IOException(roe);
                }
            } else {
                this.hivePartitionExtendedFilter = Optional.absent();
            }
            try {
                this.fastPartitionSkip = this.dataset.getProperties().containsKey(FAST_PARTITION_SKIP_PREDICATE) ? Optional.of((Object)GobblinConstructorUtils.invokeFirstConstructor(Class.forName(this.dataset.getProperties().getProperty(FAST_PARTITION_SKIP_PREDICATE)), (List[])new List[]{Lists.newArrayList((Object[])new Object[]{this}), Lists.newArrayList()})) : Optional.absent();
                this.fastTableSkip = this.dataset.getProperties().containsKey(FAST_TABLE_SKIP_PREDICATE) ? Optional.of((Object)GobblinConstructorUtils.invokeFirstConstructor(Class.forName(this.dataset.getProperties().getProperty(FAST_TABLE_SKIP_PREDICATE)), (List[])new List[]{Lists.newArrayList()})) : Optional.absent();
            }
            catch (ReflectiveOperationException roe) {
                closer.close();
                throw new IOException(roe);
            }
            ImmutableMap namedPools = ImmutableMap.of((Object)source_client, (Object)this.dataset.clientPool, (Object)target_client, (Object)this.targetClientPool);
            multiTimer.nextStage("GetTables");
            try (HiveMetastoreClientPool.MultiClient multiClient = HiveMetastoreClientPool.safeGetClients((Map)namedPools);){
                this.existingTargetTable = multiClient.getClient(target_client).tableExists(this.targetDatabase, this.dataset.table.getTableName()) ? Optional.of((Object)new org.apache.hadoop.hive.ql.metadata.Table(multiClient.getClient(target_client).getTable(this.targetDatabase, this.dataset.table.getTableName()))) : Optional.absent();
                Path targetPath = this.getTargetLocation(this.dataset.fs, this.targetFs, this.dataset.table.getDataLocation(), (Optional<Partition>)Optional.absent());
                this.targetTable = this.getTargetTable(this.dataset.table, targetPath);
                SimpleHiveSpec tableHiveSpec = new SimpleHiveSpec.Builder(targetPath).withTable(HiveMetaStoreUtils.getHiveTable((Table)this.targetTable.getTTable())).build();
                HiveRegisterStep tableRegistrationStep = new HiveRegisterStep(this.targetURI, (HiveSpec)tableHiveSpec, this.hiveRegProps);
                this.tableRegistrationStep = Optional.of((Object)tableRegistrationStep);
                if (this.existingTargetTable.isPresent() && ((org.apache.hadoop.hive.ql.metadata.Table)this.existingTargetTable.get()).isPartitioned()) {
                    this.checkPartitionedTableCompatibility(this.targetTable, (org.apache.hadoop.hive.ql.metadata.Table)this.existingTargetTable.get());
                }
                if (this.dataset.table.isPartitioned()) {
                    this.sourcePartitions = HiveUtils.getPartitionsMap(multiClient.getClient(source_client), this.dataset.table, this.partitionFilter, this.hivePartitionExtendedFilter);
                    HiveAvroCopyEntityHelper.updatePartitionAttributesIfAvro(this.targetTable, this.sourcePartitions, this);
                    this.targetPartitions = this.existingTargetTable.isPresent() ? Maps.newHashMap(HiveUtils.getPartitionsMap(multiClient.getClient(target_client), (org.apache.hadoop.hive.ql.metadata.Table)this.existingTargetTable.get(), this.partitionFilter, this.hivePartitionExtendedFilter)) : Maps.newHashMap();
                } else {
                    this.sourcePartitions = Maps.newHashMap();
                    this.targetPartitions = Maps.newHashMap();
                }
            }
            catch (TException te) {
                closer.close();
                throw new IOException("Failed to generate work units for table " + dataset.table.getCompleteName(), te);
            }
        }
    }

    Iterator<FileSet<CopyEntity>> getCopyEntities(CopyConfiguration configuration) throws IOException {
        return this.getCopyEntities(configuration, null, null);
    }

    Iterator<FileSet<CopyEntity>> getCopyEntities(CopyConfiguration configuration, Comparator<FileSet<CopyEntity>> prioritizer, PushDownRequestor<FileSet<CopyEntity>> requestor) throws IOException {
        if (this.dataset.table.isPartitioned()) {
            return new PartitionIterator(this.sourcePartitions, configuration, prioritizer, requestor);
        }
        UnpartitionedTableFileSet fileSet = new UnpartitionedTableFileSet(this.dataset.table.getCompleteName(), this.dataset, this);
        return Iterators.singletonIterator((Object)fileSet);
    }

    private org.apache.hadoop.hive.ql.metadata.Table getTargetTable(org.apache.hadoop.hive.ql.metadata.Table originTable, Path targetLocation) throws IOException {
        try {
            org.apache.hadoop.hive.ql.metadata.Table targetTable = originTable.copy();
            HiveCopyEntityHelper.addMetadataToTargetTable(targetTable, targetLocation, this.targetDatabase, this.startTime);
            HiveAvroCopyEntityHelper.updateTableAttributesIfAvro(targetTable, this);
            return targetTable;
        }
        catch (HiveException he) {
            throw new IOException(he);
        }
    }

    @VisibleForTesting
    static void addMetadataToTargetTable(org.apache.hadoop.hive.ql.metadata.Table targetTable, Path targetLocation, String targetDatabase, long startTime) throws IOException {
        targetTable.setDbName(targetDatabase);
        targetTable.setDataLocation(targetLocation);
        targetTable.setOwner(UserGroupInformation.getCurrentUser().getShortUserName());
        targetTable.getTTable().putToParameters("registerer", GOBBLIN_DISTCP);
        targetTable.getTTable().putToParameters("registrationGenerationTimeMillis", Long.toString(startTime));
        targetTable.getTTable().getSd().getSerdeInfo().getParameters().computeIfPresent("path", (k, v) -> targetLocation.toString());
        targetTable.getTTable().unsetCreateTime();
    }

    int addPartitionDeregisterSteps(List<CopyEntity> copyEntities, String fileSet, int initialPriority, org.apache.hadoop.hive.ql.metadata.Table table, Partition partition) throws IOException {
        int stepPriority = initialPriority;
        Collection<Object> partitionPaths = Lists.newArrayList();
        if (this.deleteMethod == DeregisterFileDeleteMethod.RECURSIVE) {
            partitionPaths = Lists.newArrayList((Object[])new Path[]{partition.getDataLocation()});
        } else if (this.deleteMethod == DeregisterFileDeleteMethod.INPUT_FORMAT) {
            InputFormat<?, ?> inputFormat = HiveUtils.getInputFormat(partition.getTPartition().getSd());
            HiveLocationDescriptor targetLocation = new HiveLocationDescriptor(partition.getDataLocation(), inputFormat, this.targetFs, this.dataset.getProperties());
            partitionPaths = targetLocation.getPaths().keySet();
        } else if (this.deleteMethod == DeregisterFileDeleteMethod.NO_DELETE) {
            partitionPaths = Lists.newArrayList();
        }
        if (!partitionPaths.isEmpty()) {
            DeleteFileCommitStep deletePaths = DeleteFileCommitStep.fromPaths(this.targetFs, partitionPaths, this.dataset.getProperties(), table.getDataLocation());
            copyEntities.add(new PostPublishStep(fileSet, Maps.newHashMap(), deletePaths, stepPriority++));
        }
        PartitionDeregisterStep deregister = new PartitionDeregisterStep(table.getTTable(), partition.getTPartition(), this.targetURI, this.hiveRegProps);
        copyEntities.add(new PostPublishStep(fileSet, Maps.newHashMap(), (CommitStep)deregister, stepPriority++));
        return stepPriority;
    }

    @VisibleForTesting
    protected int addTableDeregisterSteps(List<CopyEntity> copyEntities, String fileSet, int initialPriority, org.apache.hadoop.hive.ql.metadata.Table table) throws IOException {
        int stepPriority = initialPriority;
        Collection<Object> tablePaths = Lists.newArrayList();
        switch (this.getDeleteMethod()) {
            case RECURSIVE: {
                tablePaths = Lists.newArrayList((Object[])new Path[]{table.getDataLocation()});
                break;
            }
            case INPUT_FORMAT: {
                InputFormat<?, ?> inputFormat = HiveUtils.getInputFormat(table.getSd());
                HiveLocationDescriptor targetLocation = new HiveLocationDescriptor(table.getDataLocation(), inputFormat, this.getTargetFs(), this.getDataset().getProperties());
                tablePaths = targetLocation.getPaths().keySet();
                break;
            }
            case NO_DELETE: {
                tablePaths = Lists.newArrayList();
                break;
            }
            default: {
                tablePaths = Lists.newArrayList();
            }
        }
        if (!tablePaths.isEmpty()) {
            DeleteFileCommitStep deletePaths = DeleteFileCommitStep.fromPaths(this.getTargetFs(), tablePaths, this.getDataset().getProperties(), table.getDataLocation());
            copyEntities.add(new PostPublishStep(fileSet, Maps.newHashMap(), deletePaths, stepPriority++));
        }
        TableDeregisterStep deregister = new TableDeregisterStep(table.getTTable(), this.getTargetURI(), this.getHiveRegProps());
        copyEntities.add(new PostPublishStep(fileSet, Maps.newHashMap(), (CommitStep)deregister, stepPriority++));
        return stepPriority;
    }

    int addSharedSteps(List<CopyEntity> copyEntities, String fileSet, int initialPriority) {
        int priority = initialPriority;
        if (this.tableRegistrationStep.isPresent()) {
            copyEntities.add(new PostPublishStep(fileSet, Maps.newHashMap(), (CommitStep)this.tableRegistrationStep.get(), priority++));
        }
        return priority;
    }

    @VisibleForTesting
    protected static DiffPathSet fullPathDiff(HiveLocationDescriptor sourceLocation, HiveLocationDescriptor desiredTargetLocation, Optional<HiveLocationDescriptor> currentTargetLocation, Optional<Partition> partition, MultiTimingEvent multiTimer, HiveCopyEntityHelper helper) throws IOException {
        HashMap desiredTargetExistingPaths;
        sourceLocation.populateDataFileVersionStrategy();
        desiredTargetLocation.populateDataFileVersionStrategy();
        DiffPathSet.DiffPathSetBuilder builder = DiffPathSet.builder();
        if (!sourceLocation.versionStrategy.isPresent() || !desiredTargetLocation.versionStrategy.isPresent()) {
            log.warn("Version strategy doesn't exist ({},{}), cannot handle copy.", (Object)sourceLocation.versionStrategy.isPresent(), (Object)desiredTargetLocation.versionStrategy.isPresent());
            return builder.build();
        }
        if (!((DataFileVersionStrategy)sourceLocation.versionStrategy.get()).getClass().getName().equals(((DataFileVersionStrategy)desiredTargetLocation.versionStrategy.get()).getClass().getName())) {
            log.warn("Version strategy src: {} and dst: {} doesn't match, cannot handle copy.", (Object)((DataFileVersionStrategy)sourceLocation.versionStrategy.get()).getClass().getName(), (Object)((DataFileVersionStrategy)desiredTargetLocation.versionStrategy.get()).getClass().getName());
            return builder.build();
        }
        multiTimer.nextStage("SourcePathListing");
        Map<Path, FileStatus> sourcePaths = sourceLocation.getPaths();
        multiTimer.nextStage("TargetExistingPathListing");
        HashMap targetExistingPaths = currentTargetLocation.isPresent() ? ((HiveLocationDescriptor)currentTargetLocation.get()).getPaths() : Maps.newHashMap();
        multiTimer.nextStage("DesiredPathsListing");
        try {
            desiredTargetExistingPaths = desiredTargetLocation.getPaths();
        }
        catch (InvalidInputException ioe) {
            desiredTargetExistingPaths = Maps.newHashMap();
        }
        multiTimer.nextStage("PathDiff");
        for (FileStatus sourcePath : sourcePaths.values()) {
            boolean useDirectGetModTime;
            Path newPath = helper.getTargetPathHelper().getTargetPath(sourcePath.getPath(), desiredTargetLocation.getFileSystem(), partition, true);
            boolean shouldCopy = true;
            boolean bl = useDirectGetModTime = sourceLocation.versionStrategy.isPresent() && ((DataFileVersionStrategy)sourceLocation.versionStrategy.get()).getClass().getName().equals(ModTimeDataFileVersionStrategy.class.getName());
            if (desiredTargetExistingPaths.containsKey(newPath)) {
                Long dstVer;
                FileStatus existingTargetStatus = (FileStatus)desiredTargetExistingPaths.get(newPath);
                Long srcVer = useDirectGetModTime ? Long.valueOf(sourcePath.getModificationTime()) : ((DataFileVersionStrategy)sourceLocation.versionStrategy.get()).getVersion(sourcePath.getPath());
                Comparable<Long> comparable = dstVer = useDirectGetModTime ? Long.valueOf(existingTargetStatus.getModificationTime()) : ((DataFileVersionStrategy)desiredTargetLocation.versionStrategy.get()).getVersion(existingTargetStatus.getPath());
                if (srcVer.compareTo(dstVer) <= 0) {
                    if (!helper.isEnforceFileSizeMatch() || existingTargetStatus.getLen() == sourcePath.getLen()) {
                        log.debug("Copy from src {} (version:{}) to dst {} (version:{}) can be skipped since file size ({} bytes) is matching", new Object[]{sourcePath.getPath(), srcVer, existingTargetStatus.getPath(), dstVer, sourcePath.getLen()});
                        shouldCopy = false;
                    } else {
                        log.debug("Copy from src {} (version:{}) to dst {} (version:{}) can not be skipped because the file size is not matching or it is enforced by this config: {}", new Object[]{sourcePath.getPath(), srcVer, existingTargetStatus.getPath(), dstVer, "gobblin.copyenforce.fileLength.match"});
                    }
                } else {
                    log.debug("Copy from src {} (v:{}) to dst {} (v:{}) is needed due to a higher version.", new Object[]{sourcePath.getPath(), srcVer, existingTargetStatus.getPath(), dstVer});
                }
            }
            if (shouldCopy) {
                builder.copyFile(sourcePath);
                continue;
            }
            targetExistingPaths.remove(newPath);
            desiredTargetExistingPaths.remove(newPath);
        }
        multiTimer.nextStage("ComputeDeletePaths");
        for (Path delete : targetExistingPaths.keySet()) {
            builder.deleteFile(delete);
            desiredTargetExistingPaths.remove(delete);
        }
        if (desiredTargetExistingPaths.size() > 0 && helper.getUnmanagedDataPolicy() != UnmanagedDataPolicy.DELETE_UNMANAGED_DATA) {
            throw new IOException(String.format("New table / partition would pick up existing, undesired files in target file system. %s, files %s.", partition.isPresent() ? ((Partition)partition.get()).getCompleteName() : helper.getDataset().getTable().getCompleteName(), Arrays.toString(desiredTargetExistingPaths.keySet().toArray())));
        }
        if (desiredTargetExistingPaths.size() > 0) {
            for (Path delete : desiredTargetExistingPaths.keySet()) {
                builder.deleteFile(delete);
            }
            log.warn(String.format("Un-managed files detected in target file system, however deleting them because of the policy: %s Files to be deleted are: %s", new Object[]{UnmanagedDataPolicy.DELETE_UNMANAGED_DATA, StringUtils.join(desiredTargetExistingPaths.keySet(), (String)",")}));
        }
        return builder.build();
    }

    private void checkPartitionedTableCompatibility(org.apache.hadoop.hive.ql.metadata.Table desiredTargetTable, org.apache.hadoop.hive.ql.metadata.Table existingTargetTable) throws IOException {
        if (!desiredTargetTable.getDataLocation().equals((Object)existingTargetTable.getDataLocation())) {
            throw new HiveTableLocationNotMatchException(desiredTargetTable.getDataLocation(), existingTargetTable.getDataLocation());
        }
        if (desiredTargetTable.isPartitioned() != existingTargetTable.isPartitioned()) {
            throw new IOException(String.format("%s: Desired target table %s partitioned, existing target table %s partitioned. Tables are incompatible.", this.dataset.tableIdentifier, desiredTargetTable.isPartitioned() ? "is" : "is not", existingTargetTable.isPartitioned() ? "is" : "is not"));
        }
        if (desiredTargetTable.isPartitioned() && !desiredTargetTable.getPartitionKeys().equals(existingTargetTable.getPartitionKeys())) {
            throw new IOException(String.format("%s: Desired target table has partition keys %s, existing target table has partition keys %s. Tables are incompatible.", this.dataset.tableIdentifier, gson.toJson((Object)desiredTargetTable.getPartitionKeys()), gson.toJson((Object)existingTargetTable.getPartitionKeys())));
        }
    }

    List<CopyableFile.Builder> getCopyableFilesFromPaths(Collection<FileStatus> paths, CopyConfiguration configuration, Optional<Partition> partition) throws IOException {
        ArrayList builders = Lists.newArrayList();
        ArrayList dataFiles = Lists.newArrayList();
        Configuration hadoopConfiguration = new Configuration();
        FileSystem actualSourceFs = null;
        String referenceScheme = null;
        String referenceAuthority = null;
        for (FileStatus status : paths) {
            dataFiles.add(new SourceAndDestination(status, this.getTargetPathHelper().getTargetPath(status.getPath(), this.targetFs, partition, true)));
        }
        for (SourceAndDestination sourceAndDestination : dataFiles) {
            URI uri = sourceAndDestination.getSource().getPath().toUri();
            if (actualSourceFs == null || !StringUtils.equals(referenceScheme, (CharSequence)uri.getScheme()) || !StringUtils.equals(referenceAuthority, (CharSequence)uri.getAuthority())) {
                actualSourceFs = sourceAndDestination.getSource().getPath().getFileSystem(hadoopConfiguration);
                referenceScheme = uri.getScheme();
                referenceAuthority = uri.getAuthority();
            }
            if (!this.dataset.getTableRootPath().isPresent()) {
                throw new IOException(String.format("Table %s does not have a concrete table root path.", this.dataset.getTable().getCompleteName()));
            }
            List<OwnerAndPermission> ancestorOwnerAndPermission = CopyableFile.resolveReplicatedOwnerAndPermissionsRecursively(actualSourceFs, sourceAndDestination.getSource().getPath().getParent(), ((Path)this.dataset.getTableRootPath().get()).getParent(), configuration);
            builders.add(CopyableFile.fromOriginAndDestination(actualSourceFs, sourceAndDestination.getSource(), sourceAndDestination.getDestination(), configuration).ancestorsOwnerAndPermission(ancestorOwnerAndPermission));
        }
        return builders;
    }

    Path getTargetLocation(FileSystem sourceFs, FileSystem targetFs, Path path, Optional<Partition> partition) throws IOException {
        return this.getTargetPathHelper().getTargetPath(path, targetFs, partition, false);
    }

    protected static Path replacedPrefix(Path sourcePath, Path prefixTobeReplaced, Path prefixReplacement) {
        Path sourcePathWithoutSchemeAndAuthority = PathUtils.getPathWithoutSchemeAndAuthority((Path)sourcePath);
        Preconditions.checkArgument((boolean)PathUtils.isAncestor((Path)prefixTobeReplaced, (Path)sourcePathWithoutSchemeAndAuthority), (String)"When replacing prefix, all locations must be descendants of the prefix. The prefix: %s, file location: %s.", (Object[])new Object[]{prefixTobeReplaced, sourcePathWithoutSchemeAndAuthority});
        Path relativePath = PathUtils.relativizePath((Path)sourcePathWithoutSchemeAndAuthority, (Path)prefixTobeReplaced);
        Path result = new Path(prefixReplacement, relativePath);
        return result;
    }

    public FileSystem getTargetFileSystem() {
        return this.targetFs;
    }

    DatasetDescriptor getSourceDataset() {
        String sourceTable = this.dataset.getTable().getDbName() + "." + this.dataset.getTable().getTableName();
        DatasetDescriptor sourceDataset = new DatasetDescriptor("hive", sourceTable);
        sourceDataset.addMetadata("fsUri", this.dataset.getFs().getUri().toString());
        return sourceDataset;
    }

    DatasetDescriptor getDestinationDataset() {
        String destinationTable = this.getTargetDatabase() + "." + this.getTargetTable();
        DatasetDescriptor destinationDataset = new DatasetDescriptor("hive", destinationTable);
        destinationDataset.addMetadata("fsUri", this.getTargetFs().getUri().toString());
        return destinationDataset;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public HiveDataset getDataset() {
        return this.dataset;
    }

    public CopyConfiguration getConfiguration() {
        return this.configuration;
    }

    public FileSystem getTargetFs() {
        return this.targetFs;
    }

    public HiveMetastoreClientPool getTargetClientPool() {
        return this.targetClientPool;
    }

    public String getTargetDatabase() {
        return this.targetDatabase;
    }

    public HiveRegProps getHiveRegProps() {
        return this.hiveRegProps;
    }

    public Optional<org.apache.hadoop.hive.ql.metadata.Table> getExistingTargetTable() {
        return this.existingTargetTable;
    }

    public org.apache.hadoop.hive.ql.metadata.Table getTargetTable() {
        return this.targetTable;
    }

    public Optional<String> getTargetURI() {
        return this.targetURI;
    }

    public ExistingEntityPolicy getExistingEntityPolicy() {
        return this.existingEntityPolicy;
    }

    public UnmanagedDataPolicy getUnmanagedDataPolicy() {
        return this.unmanagedDataPolicy;
    }

    public Optional<String> getPartitionFilter() {
        return this.partitionFilter;
    }

    public Optional<? extends HivePartitionExtendedFilter> getHivePartitionExtendedFilter() {
        return this.hivePartitionExtendedFilter;
    }

    public Optional<Predicate<HivePartitionFileSet>> getFastPartitionSkip() {
        return this.fastPartitionSkip;
    }

    public Optional<Predicate<HiveCopyEntityHelper>> getFastTableSkip() {
        return this.fastTableSkip;
    }

    public DeregisterFileDeleteMethod getDeleteMethod() {
        return this.deleteMethod;
    }

    public Optional<CommitStep> getTableRegistrationStep() {
        return this.tableRegistrationStep;
    }

    public Map<List<String>, Partition> getSourcePartitions() {
        return this.sourcePartitions;
    }

    public Map<List<String>, Partition> getTargetPartitions() {
        return this.targetPartitions;
    }

    public boolean isEnforceFileSizeMatch() {
        return this.enforceFileSizeMatch;
    }

    public EventSubmitter getEventSubmitter() {
        return this.eventSubmitter;
    }

    public HiveTargetPathHelper getTargetPathHelper() {
        return this.targetPathHelper;
    }

    private class PartitionIterator
    implements Iterator<FileSet<CopyEntity>> {
        static final String DEREGISTER_FILE_SET = "deregister";
        private final List<FileSet<CopyEntity>> allFileSets;
        private final Iterator<FileSet<CopyEntity>> fileSetIterator;

        public PartitionIterator(Map<List<String>, Partition> partitionMap, CopyConfiguration configuration, Comparator<FileSet<CopyEntity>> prioritizer, PushDownRequestor<FileSet<CopyEntity>> requestor) {
            this.allFileSets = this.generateAllFileSets(partitionMap);
            for (FileSet<CopyEntity> fileSet : this.allFileSets) {
                fileSet.setRequestor((Requestor<FileSet<CopyEntity>>)requestor);
            }
            if (prioritizer != null) {
                Collections.sort(this.allFileSets, prioritizer);
            }
            this.fileSetIterator = this.allFileSets.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.fileSetIterator.hasNext();
        }

        @Override
        public FileSet<CopyEntity> next() {
            return this.fileSetIterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private List<FileSet<CopyEntity>> generateAllFileSets(Map<List<String>, Partition> partitionMap) {
            ArrayList fileSets = Lists.newArrayList();
            for (Map.Entry<List<String>, Partition> partition : partitionMap.entrySet()) {
                fileSets.add(this.fileSetForPartition(partition.getValue()));
                HiveCopyEntityHelper.this.targetPartitions.remove(partition.getKey());
            }
            if (!HiveCopyEntityHelper.this.targetPartitions.isEmpty()) {
                fileSets.add(new HivePartitionsDeregisterFileSet(HiveCopyEntityHelper.this.dataset.getTable().getCompleteName() + DEREGISTER_FILE_SET, HiveCopyEntityHelper.this.dataset, HiveCopyEntityHelper.this.targetPartitions.values(), HiveCopyEntityHelper.this));
            }
            return fileSets;
        }

        private FileSet<CopyEntity> fileSetForPartition(Partition partition) {
            return new HivePartitionFileSet(HiveCopyEntityHelper.this, partition, HiveCopyEntityHelper.this.dataset.getProperties());
        }
    }

    private static class SourceAndDestination {
        private final FileStatus source;
        private final Path destination;

        @ConstructorProperties(value={"source", "destination"})
        public SourceAndDestination(FileStatus source, Path destination) {
            this.source = source;
            this.destination = destination;
        }

        public FileStatus getSource() {
            return this.source;
        }

        public Path getDestination() {
            return this.destination;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SourceAndDestination)) {
                return false;
            }
            SourceAndDestination other = (SourceAndDestination)o;
            if (!other.canEqual(this)) {
                return false;
            }
            FileStatus this$source = this.getSource();
            FileStatus other$source = other.getSource();
            if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
                return false;
            }
            Path this$destination = this.getDestination();
            Path other$destination = other.getDestination();
            return !(this$destination == null ? other$destination != null : !this$destination.equals(other$destination));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SourceAndDestination;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            FileStatus $source = this.getSource();
            result = result * 59 + ($source == null ? 43 : $source.hashCode());
            Path $destination = this.getDestination();
            result = result * 59 + ($destination == null ? 43 : $destination.hashCode());
            return result;
        }

        public String toString() {
            return "HiveCopyEntityHelper.SourceAndDestination(source=" + this.getSource() + ", destination=" + this.getDestination() + ")";
        }
    }

    protected static class DiffPathSet {
        Collection<FileStatus> filesToCopy;
        Collection<Path> pathsToDelete;

        DiffPathSet(Collection<FileStatus> filesToCopy, Collection<Path> pathsToDelete) {
            this.filesToCopy = filesToCopy;
            this.pathsToDelete = pathsToDelete;
        }

        public static DiffPathSetBuilder builder() {
            return new DiffPathSetBuilder();
        }

        public String toString() {
            return "HiveCopyEntityHelper.DiffPathSet(filesToCopy=" + this.filesToCopy + ", pathsToDelete=" + this.pathsToDelete + ")";
        }

        public static class DiffPathSetBuilder {
            private ArrayList<FileStatus> filesToCopy;
            private ArrayList<Path> pathsToDelete;

            DiffPathSetBuilder() {
            }

            public DiffPathSetBuilder copyFile(FileStatus copyFile) {
                if (this.filesToCopy == null) {
                    this.filesToCopy = new ArrayList();
                }
                this.filesToCopy.add(copyFile);
                return this;
            }

            public DiffPathSetBuilder filesToCopy(Collection<? extends FileStatus> filesToCopy) {
                if (this.filesToCopy == null) {
                    this.filesToCopy = new ArrayList();
                }
                this.filesToCopy.addAll(filesToCopy);
                return this;
            }

            public DiffPathSetBuilder clearFilesToCopy() {
                if (this.filesToCopy != null) {
                    this.filesToCopy.clear();
                }
                return this;
            }

            public DiffPathSetBuilder deleteFile(Path deleteFile) {
                if (this.pathsToDelete == null) {
                    this.pathsToDelete = new ArrayList();
                }
                this.pathsToDelete.add(deleteFile);
                return this;
            }

            public DiffPathSetBuilder pathsToDelete(Collection<? extends Path> pathsToDelete) {
                if (this.pathsToDelete == null) {
                    this.pathsToDelete = new ArrayList();
                }
                this.pathsToDelete.addAll(pathsToDelete);
                return this;
            }

            public DiffPathSetBuilder clearPathsToDelete() {
                if (this.pathsToDelete != null) {
                    this.pathsToDelete.clear();
                }
                return this;
            }

            public DiffPathSet build() {
                List<Object> pathsToDelete;
                List<FileStatus> filesToCopy;
                switch (this.filesToCopy == null ? 0 : this.filesToCopy.size()) {
                    case 0: {
                        filesToCopy = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        filesToCopy = Collections.singletonList(this.filesToCopy.get(0));
                        break;
                    }
                    default: {
                        filesToCopy = Collections.unmodifiableList(new ArrayList<FileStatus>(this.filesToCopy));
                    }
                }
                switch (this.pathsToDelete == null ? 0 : this.pathsToDelete.size()) {
                    case 0: {
                        pathsToDelete = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        pathsToDelete = Collections.singletonList(this.pathsToDelete.get(0));
                        break;
                    }
                    default: {
                        pathsToDelete = Collections.unmodifiableList(new ArrayList<Path>(this.pathsToDelete));
                    }
                }
                return new DiffPathSet(filesToCopy, pathsToDelete);
            }

            public String toString() {
                return "HiveCopyEntityHelper.DiffPathSet.DiffPathSetBuilder(filesToCopy=" + this.filesToCopy + ", pathsToDelete=" + this.pathsToDelete + ")";
            }
        }
    }

    public static enum DeregisterFileDeleteMethod {
        INPUT_FORMAT,
        RECURSIVE,
        NO_DELETE;

    }

    public static enum UnmanagedDataPolicy {
        DELETE_UNMANAGED_DATA,
        ABORT;

    }

    public static enum ExistingEntityPolicy {
        REPLACE_PARTITIONS,
        REPLACE_TABLE,
        REPLACE_TABLE_AND_PARTITIONS,
        UPDATE_TABLE,
        ABORT;

    }

    public static class Stages {
        public static final String EXISTING_PARTITION = "ExistingPartition";
        public static final String PARTITION_SKIP_PREDICATE = "PartitionSkipPredicate";
        public static final String CREATE_LOCATIONS = "CreateLocations";
        public static final String FULL_PATH_DIFF = "FullPathDiff";
        public static final String CREATE_DELETE_UNITS = "CreateDeleteUnits";
        public static final String CREATE_COPY_UNITS = "CreateCopyUnits";
        public static final String SOURCE_PATH_LISTING = "SourcePathListing";
        public static final String TARGET_EXISTING_PATH_LISTING = "TargetExistingPathListing";
        public static final String DESIRED_PATHS_LISTING = "DesiredPathsListing";
        public static final String PATH_DIFF = "PathDiff";
        public static final String COMPUTE_DELETE_PATHS = "ComputeDeletePaths";
        public static final String GET_TABLES = "GetTables";
        public static final String COMPUTE_TARGETS = "ComputeTargets";
    }
}

