/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.gobblin.data.management.copy.CopyConfiguration;
import org.apache.gobblin.data.management.copy.CopyEntity;
import org.apache.gobblin.data.management.copy.CopyableDataset;
import org.apache.gobblin.data.management.copy.CopyableFile;
import org.apache.gobblin.data.management.copy.CopyableFileFilter;
import org.apache.gobblin.data.management.copy.entities.PrePublishStep;
import org.apache.gobblin.data.management.dataset.DatasetUtils;
import org.apache.gobblin.dataset.FileSystemDataset;
import org.apache.gobblin.util.FileListUtils;
import org.apache.gobblin.util.PathUtils;
import org.apache.gobblin.util.commit.DeleteFileCommitStep;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;

public class RecursiveCopyableDataset
implements CopyableDataset,
FileSystemDataset {
    private static final String CONFIG_PREFIX = "gobblin.copy.recursive";
    public static final String UPDATE_KEY = "gobblin.copy.recursive.update";
    public static final String DELETE_KEY = "gobblin.copy.recursive.delete";
    public static final String DELETE_EMPTY_DIRECTORIES_KEY = "gobblin.copy.recursive.deleteEmptyDirectories";
    private final Path rootPath;
    private final FileSystem fs;
    private final PathFilter pathFilter;
    private final Path glob;
    private final CopyableFileFilter copyableFileFilter;
    private final boolean update;
    private final boolean delete;
    private final boolean includeEmptyDirectories;
    private final boolean deleteEmptyDirectories;
    private final boolean applyFilterToDirectories;
    private final Properties properties;

    public RecursiveCopyableDataset(FileSystem fs, Path rootPath, Properties properties, Path glob) {
        this.rootPath = PathUtils.getPathWithoutSchemeAndAuthority((Path)rootPath);
        this.fs = fs;
        this.pathFilter = DatasetUtils.instantiatePathFilter(properties);
        this.copyableFileFilter = DatasetUtils.instantiateCopyableFileFilter(properties, new Object[0]);
        this.glob = glob;
        this.update = Boolean.parseBoolean(properties.getProperty(UPDATE_KEY));
        this.delete = Boolean.parseBoolean(properties.getProperty(DELETE_KEY));
        this.deleteEmptyDirectories = Boolean.parseBoolean(properties.getProperty(DELETE_EMPTY_DIRECTORIES_KEY));
        this.includeEmptyDirectories = Boolean.parseBoolean(properties.getProperty("gobblin.copy.includeEmptyDirectories"));
        this.applyFilterToDirectories = Boolean.parseBoolean(properties.getProperty("gobblin.copy.applyFilterToDirectories", "false"));
        this.properties = properties;
    }

    protected Collection<? extends CopyEntity> getCopyableFilesImpl(CopyConfiguration configuration, Map<Path, FileStatus> filesInSource, Map<Path, FileStatus> filesInTarget, FileSystem targetFs, Path replacedPrefix, Path replacingPrefix, Path deleteEmptyDirectoriesUpTo) throws IOException {
        ArrayList toCopy = Lists.newArrayList();
        HashMap toDelete = Maps.newHashMap();
        boolean requiresUpdate = false;
        for (Map.Entry<Path, FileStatus> entry : filesInSource.entrySet()) {
            FileStatus statusInTarget = filesInTarget.remove(entry.getKey());
            if (statusInTarget != null) {
                if (RecursiveCopyableDataset.sameFile(filesInSource.get(entry.getKey()), statusInTarget)) continue;
                toCopy.add(entry.getKey());
                toDelete.put(entry.getKey(), statusInTarget);
                requiresUpdate = true;
                continue;
            }
            toCopy.add(entry.getKey());
        }
        if (!this.update && requiresUpdate) {
            throw new IOException("Some files need to be copied but they already exist in the destination. Aborting because not running in update mode.");
        }
        if (this.delete) {
            toDelete.putAll(filesInTarget);
        }
        ArrayList copyEntities = Lists.newArrayList();
        ArrayList copyableFiles = Lists.newArrayList();
        for (Path path : toCopy) {
            FileStatus file = filesInSource.get(path);
            Path filePathRelativeToSearchPath = PathUtils.relativizePath((Path)file.getPath(), (Path)replacedPrefix);
            Path thisTargetPath = new Path(replacingPrefix, filePathRelativeToSearchPath);
            CopyableFile copyableFile = CopyableFile.fromOriginAndDestination(this.fs, file, thisTargetPath, configuration).fileSet(this.datasetURN()).datasetOutputPath(thisTargetPath.toString()).ancestorsOwnerAndPermission(CopyableFile.resolveReplicatedOwnerAndPermissionsRecursively(this.fs, file.getPath().getParent(), replacedPrefix, configuration)).build();
            copyableFile.setFsDatasets(this.fs, targetFs);
            copyableFiles.add(copyableFile);
        }
        copyEntities.addAll(this.copyableFileFilter.filter(this.fs, targetFs, copyableFiles));
        if (!toDelete.isEmpty()) {
            DeleteFileCommitStep step = new DeleteFileCommitStep(targetFs, toDelete.values(), this.properties, (Optional<Path>)(this.deleteEmptyDirectories ? Optional.of((Object)deleteEmptyDirectoriesUpTo) : Optional.absent()));
            copyEntities.add(new PrePublishStep(this.datasetURN(), Maps.newHashMap(), step, 1));
        }
        return copyEntities;
    }

    @Override
    public Collection<? extends CopyEntity> getCopyableFiles(FileSystem targetFs, CopyConfiguration configuration) throws IOException {
        Path nonGlobSearchPath = PathUtils.deepestNonGlobPath((Path)this.glob);
        Path targetPath = new Path(configuration.getPublishDir(), PathUtils.relativizePath((Path)this.rootPath, (Path)nonGlobSearchPath));
        Map<Path, FileStatus> filesInSource = this.createPathMap(this.getFilesAtPath(this.fs, this.rootPath, this.pathFilter), this.rootPath);
        Map<Path, FileStatus> filesInTarget = this.createPathMap(this.getFilesAtPath(targetFs, targetPath, this.pathFilter), targetPath);
        return this.getCopyableFilesImpl(configuration, filesInSource, filesInTarget, targetFs, nonGlobSearchPath, configuration.getPublishDir(), targetPath);
    }

    @VisibleForTesting
    protected List<FileStatus> getFilesAtPath(FileSystem fs, Path path, PathFilter fileFilter) throws IOException {
        try {
            return FileListUtils.listFilesToCopyAtPath((FileSystem)fs, (Path)path, (PathFilter)fileFilter, (boolean)this.applyFilterToDirectories, (boolean)this.includeEmptyDirectories);
        }
        catch (FileNotFoundException fnfe) {
            return Lists.newArrayList();
        }
    }

    public Path datasetRoot() {
        return this.rootPath;
    }

    public String datasetURN() {
        return this.datasetRoot().toString();
    }

    private Map<Path, FileStatus> createPathMap(List<FileStatus> files, Path prefix) {
        HashMap map = Maps.newHashMap();
        for (FileStatus status : files) {
            map.put(PathUtils.relativizePath((Path)status.getPath(), (Path)prefix), status);
        }
        return map;
    }

    private static boolean sameFile(FileStatus fileInSource, FileStatus fileInTarget) {
        return fileInTarget.getLen() == fileInSource.getLen() && fileInSource.getModificationTime() <= fileInTarget.getModificationTime();
    }
}

