/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.typesafe.config.Config;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.gobblin.data.management.copy.CopyConfiguration;
import org.apache.gobblin.data.management.copy.CopyEntity;
import org.apache.gobblin.data.management.copy.OwnerAndPermission;
import org.apache.gobblin.data.management.copy.PreserveAttributes;
import org.apache.gobblin.data.management.partition.File;
import org.apache.gobblin.dataset.DatasetDescriptor;
import org.apache.gobblin.dataset.Descriptor;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.gobblin.util.PathUtils;
import org.apache.gobblin.util.guid.Guid;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;

public class CopyableFile
extends CopyEntity
implements File {
    private static final byte[] EMPTY_CHECKSUM = new byte[0];
    private transient Descriptor sourceData;
    private FileStatus origin;
    private Descriptor destinationData;
    private Path destination;
    public String datasetOutputPath;
    private OwnerAndPermission destinationOwnerAndPermission;
    private List<OwnerAndPermission> ancestorsOwnerAndPermission;
    private byte[] checksum;
    private PreserveAttributes preserve;
    private long originTimestamp;
    private long upstreamTimestamp;
    private String dataFileVersionStrategy;

    public CopyableFile(FileStatus origin, Path destination, OwnerAndPermission destinationOwnerAndPermission, List<OwnerAndPermission> ancestorsOwnerAndPermission, byte[] checksum, PreserveAttributes preserve, String fileSet, long originTimestamp, long upstreamTimestamp, Map<String, String> additionalMetadata, String datasetOutputPath, String dataFileVersionStrategy) {
        super(fileSet, additionalMetadata);
        this.origin = origin;
        this.destination = destination;
        this.destinationOwnerAndPermission = destinationOwnerAndPermission;
        this.ancestorsOwnerAndPermission = ancestorsOwnerAndPermission;
        this.checksum = checksum;
        this.preserve = preserve;
        this.dataFileVersionStrategy = dataFileVersionStrategy;
        this.originTimestamp = originTimestamp;
        this.upstreamTimestamp = upstreamTimestamp;
        this.datasetOutputPath = datasetOutputPath;
    }

    public void setFsDatasets(FileSystem originFs, FileSystem targetFs) {
        boolean isDir = this.origin.isDirectory();
        Path fullSourcePath = Path.getPathWithoutSchemeAndAuthority((Path)this.origin.getPath());
        String sourceDatasetName = isDir ? fullSourcePath.toString() : fullSourcePath.getParent().toString();
        DatasetDescriptor sourceDataset = new DatasetDescriptor(originFs.getScheme(), sourceDatasetName);
        sourceDataset.addMetadata("fsUri", originFs.getUri().toString());
        this.sourceData = sourceDataset;
        Path fullDestinationPath = Path.getPathWithoutSchemeAndAuthority((Path)this.destination);
        String destinationDatasetName = isDir ? fullDestinationPath.toString() : fullDestinationPath.getParent().toString();
        DatasetDescriptor destinationDataset = new DatasetDescriptor(targetFs.getScheme(), destinationDatasetName);
        destinationDataset.addMetadata("fsUri", targetFs.getUri().toString());
        this.destinationData = destinationDataset;
    }

    @Deprecated
    public static Builder builder(FileSystem originFs, FileStatus origin, Path datasetRoot, CopyConfiguration copyConfiguration) {
        Path relativePath = PathUtils.relativizePath((Path)origin.getPath(), (Path)datasetRoot);
        Path targetRoot = new Path(copyConfiguration.getPublishDir(), datasetRoot.getName());
        Path targetPath = new Path(targetRoot, relativePath);
        return CopyableFile._hiddenBuilder().originFS(originFs).origin(origin).destination(targetPath).preserve(copyConfiguration.getPreserve()).configuration(copyConfiguration);
    }

    public static Builder fromOriginAndDestination(FileSystem originFs, FileStatus origin, Path destination, CopyConfiguration copyConfiguration) {
        return CopyableFile._hiddenBuilder().originFS(originFs).origin(origin).destination(destination).configuration(copyConfiguration).preserve(copyConfiguration.getPreserve());
    }

    public static OwnerAndPermission resolveReplicatedOwnerAndPermission(FileSystem fs, Path path, CopyConfiguration copyConfiguration) throws IOException {
        PreserveAttributes preserve = copyConfiguration.getPreserve();
        Optional<FileStatus> originFileStatus = copyConfiguration.getCopyContext().getFileStatus(fs, path);
        if (!originFileStatus.isPresent()) {
            throw new IOException(String.format("Origin path %s does not exist.", path));
        }
        String group = null;
        if (copyConfiguration.getTargetGroup().isPresent()) {
            group = (String)copyConfiguration.getTargetGroup().get();
        } else if (preserve.preserve(PreserveAttributes.Option.GROUP)) {
            group = ((FileStatus)originFileStatus.get()).getGroup();
        }
        return new OwnerAndPermission(preserve.preserve(PreserveAttributes.Option.OWNER) ? ((FileStatus)originFileStatus.get()).getOwner() : null, group, preserve.preserve(PreserveAttributes.Option.PERMISSION) ? ((FileStatus)originFileStatus.get()).getPermission() : null);
    }

    public static List<OwnerAndPermission> resolveReplicatedOwnerAndPermissionsRecursively(FileSystem sourceFs, Path fromPath, Path toPath, CopyConfiguration copyConfiguration) throws IOException {
        if (!PathUtils.isAncestor((Path)toPath, (Path)fromPath)) {
            throw new IOException(String.format("toPath %s must be an ancestor of fromPath %s.", toPath, fromPath));
        }
        ArrayList ownerAndPermissions = Lists.newArrayList();
        Path currentPath = fromPath;
        while (PathUtils.isAncestor((Path)toPath, (Path)currentPath.getParent())) {
            ownerAndPermissions.add(CopyableFile.resolveReplicatedOwnerAndPermission(sourceFs, currentPath, copyConfiguration));
            currentPath = currentPath.getParent();
        }
        return ownerAndPermissions;
    }

    @Override
    public FileStatus getFileStatus() {
        return this.origin;
    }

    public long getBlockSize(FileSystem targetFs) {
        return this.getPreserve().preserve(PreserveAttributes.Option.BLOCK_SIZE) ? this.getOrigin().getBlockSize() : targetFs.getDefaultBlockSize(this.destination);
    }

    public short getReplication(FileSystem targetFs) {
        return this.getPreserve().preserve(PreserveAttributes.Option.REPLICATION) ? this.getOrigin().getReplication() : targetFs.getDefaultReplication(this.destination);
    }

    @Override
    public Guid guid() throws IOException {
        StringBuilder uniqueString = new StringBuilder();
        uniqueString.append(this.getFileStatus().getModificationTime());
        uniqueString.append(this.getFileStatus().getLen());
        uniqueString.append(this.getFileStatus().getPath());
        return Guid.fromStrings((String[])new String[]{uniqueString.toString()});
    }

    @Override
    public String explain() {
        String owner = this.destinationOwnerAndPermission != null && this.destinationOwnerAndPermission.getOwner() != null ? this.destinationOwnerAndPermission.getOwner() : "preserve";
        String group = this.destinationOwnerAndPermission != null && this.destinationOwnerAndPermission.getGroup() != null ? this.destinationOwnerAndPermission.getGroup() : "preserve";
        String permissions = this.destinationOwnerAndPermission != null && this.destinationOwnerAndPermission.getFsPermission() != null ? this.destinationOwnerAndPermission.getFsPermission().toString() : "preserve";
        return String.format("Copy file %s to %s with owner %s, group %s, permission %s.", this.origin.getPath(), this.destination, owner, group, permissions);
    }

    public static Builder _hiddenBuilder() {
        return new Builder();
    }

    public Descriptor getSourceData() {
        return this.sourceData;
    }

    public FileStatus getOrigin() {
        return this.origin;
    }

    public Descriptor getDestinationData() {
        return this.destinationData;
    }

    public Path getDestination() {
        return this.destination;
    }

    public String getDatasetOutputPath() {
        return this.datasetOutputPath;
    }

    public OwnerAndPermission getDestinationOwnerAndPermission() {
        return this.destinationOwnerAndPermission;
    }

    public List<OwnerAndPermission> getAncestorsOwnerAndPermission() {
        return this.ancestorsOwnerAndPermission;
    }

    public byte[] getChecksum() {
        return this.checksum;
    }

    public PreserveAttributes getPreserve() {
        return this.preserve;
    }

    public long getOriginTimestamp() {
        return this.originTimestamp;
    }

    public long getUpstreamTimestamp() {
        return this.upstreamTimestamp;
    }

    public String getDataFileVersionStrategy() {
        return this.dataFileVersionStrategy;
    }

    public void setSourceData(Descriptor sourceData) {
        this.sourceData = sourceData;
    }

    public void setOrigin(FileStatus origin) {
        this.origin = origin;
    }

    public void setDestinationData(Descriptor destinationData) {
        this.destinationData = destinationData;
    }

    public void setDestination(Path destination) {
        this.destination = destination;
    }

    public void setDatasetOutputPath(String datasetOutputPath) {
        this.datasetOutputPath = datasetOutputPath;
    }

    public void setDestinationOwnerAndPermission(OwnerAndPermission destinationOwnerAndPermission) {
        this.destinationOwnerAndPermission = destinationOwnerAndPermission;
    }

    public void setAncestorsOwnerAndPermission(List<OwnerAndPermission> ancestorsOwnerAndPermission) {
        this.ancestorsOwnerAndPermission = ancestorsOwnerAndPermission;
    }

    public void setChecksum(byte[] checksum) {
        this.checksum = checksum;
    }

    public void setPreserve(PreserveAttributes preserve) {
        this.preserve = preserve;
    }

    public void setOriginTimestamp(long originTimestamp) {
        this.originTimestamp = originTimestamp;
    }

    public void setUpstreamTimestamp(long upstreamTimestamp) {
        this.upstreamTimestamp = upstreamTimestamp;
    }

    public void setDataFileVersionStrategy(String dataFileVersionStrategy) {
        this.dataFileVersionStrategy = dataFileVersionStrategy;
    }

    protected CopyableFile() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CopyableFile)) {
            return false;
        }
        CopyableFile other = (CopyableFile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FileStatus this$origin = this.getOrigin();
        FileStatus other$origin = other.getOrigin();
        if (this$origin == null ? other$origin != null : !this$origin.equals(other$origin)) {
            return false;
        }
        Descriptor this$destinationData = this.getDestinationData();
        Descriptor other$destinationData = other.getDestinationData();
        if (this$destinationData == null ? other$destinationData != null : !this$destinationData.equals(other$destinationData)) {
            return false;
        }
        Path this$destination = this.getDestination();
        Path other$destination = other.getDestination();
        if (this$destination == null ? other$destination != null : !this$destination.equals(other$destination)) {
            return false;
        }
        String this$datasetOutputPath = this.getDatasetOutputPath();
        String other$datasetOutputPath = other.getDatasetOutputPath();
        if (this$datasetOutputPath == null ? other$datasetOutputPath != null : !this$datasetOutputPath.equals(other$datasetOutputPath)) {
            return false;
        }
        OwnerAndPermission this$destinationOwnerAndPermission = this.getDestinationOwnerAndPermission();
        OwnerAndPermission other$destinationOwnerAndPermission = other.getDestinationOwnerAndPermission();
        if (this$destinationOwnerAndPermission == null ? other$destinationOwnerAndPermission != null : !((Object)this$destinationOwnerAndPermission).equals(other$destinationOwnerAndPermission)) {
            return false;
        }
        List<OwnerAndPermission> this$ancestorsOwnerAndPermission = this.getAncestorsOwnerAndPermission();
        List<OwnerAndPermission> other$ancestorsOwnerAndPermission = other.getAncestorsOwnerAndPermission();
        if (this$ancestorsOwnerAndPermission == null ? other$ancestorsOwnerAndPermission != null : !((Object)this$ancestorsOwnerAndPermission).equals(other$ancestorsOwnerAndPermission)) {
            return false;
        }
        if (!Arrays.equals(this.getChecksum(), other.getChecksum())) {
            return false;
        }
        PreserveAttributes this$preserve = this.getPreserve();
        PreserveAttributes other$preserve = other.getPreserve();
        if (this$preserve == null ? other$preserve != null : !((Object)this$preserve).equals(other$preserve)) {
            return false;
        }
        if (this.getOriginTimestamp() != other.getOriginTimestamp()) {
            return false;
        }
        if (this.getUpstreamTimestamp() != other.getUpstreamTimestamp()) {
            return false;
        }
        String this$dataFileVersionStrategy = this.getDataFileVersionStrategy();
        String other$dataFileVersionStrategy = other.getDataFileVersionStrategy();
        return !(this$dataFileVersionStrategy == null ? other$dataFileVersionStrategy != null : !this$dataFileVersionStrategy.equals(other$dataFileVersionStrategy));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CopyableFile;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        FileStatus $origin = this.getOrigin();
        result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
        Descriptor $destinationData = this.getDestinationData();
        result = result * 59 + ($destinationData == null ? 43 : $destinationData.hashCode());
        Path $destination = this.getDestination();
        result = result * 59 + ($destination == null ? 43 : $destination.hashCode());
        String $datasetOutputPath = this.getDatasetOutputPath();
        result = result * 59 + ($datasetOutputPath == null ? 43 : $datasetOutputPath.hashCode());
        OwnerAndPermission $destinationOwnerAndPermission = this.getDestinationOwnerAndPermission();
        result = result * 59 + ($destinationOwnerAndPermission == null ? 43 : ((Object)$destinationOwnerAndPermission).hashCode());
        List<OwnerAndPermission> $ancestorsOwnerAndPermission = this.getAncestorsOwnerAndPermission();
        result = result * 59 + ($ancestorsOwnerAndPermission == null ? 43 : ((Object)$ancestorsOwnerAndPermission).hashCode());
        result = result * 59 + Arrays.hashCode(this.getChecksum());
        PreserveAttributes $preserve = this.getPreserve();
        result = result * 59 + ($preserve == null ? 43 : ((Object)$preserve).hashCode());
        long $originTimestamp = this.getOriginTimestamp();
        result = result * 59 + (int)($originTimestamp >>> 32 ^ $originTimestamp);
        long $upstreamTimestamp = this.getUpstreamTimestamp();
        result = result * 59 + (int)($upstreamTimestamp >>> 32 ^ $upstreamTimestamp);
        String $dataFileVersionStrategy = this.getDataFileVersionStrategy();
        result = result * 59 + ($dataFileVersionStrategy == null ? 43 : $dataFileVersionStrategy.hashCode());
        return result;
    }

    public static class Builder {
        private FileStatus origin;
        private Path destination;
        private OwnerAndPermission destinationOwnerAndPermission;
        private List<OwnerAndPermission> ancestorsOwnerAndPermission;
        private byte[] checksum;
        private PreserveAttributes preserve;
        private String fileSet;
        private long originTimestamp;
        private long upstreamTimestamp;
        private String dataFileVersionStrategy;
        private CopyConfiguration configuration;
        private FileSystem originFs;
        private Map<String, String> additionalMetadata;
        private String datasetOutputPath;

        private Builder originFS(FileSystem originFs) {
            this.originFs = originFs;
            return this;
        }

        private Builder configuration(CopyConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public CopyableFile build() throws IOException {
            if (!this.destination.isAbsolute()) {
                throw new IOException("Destination must be absolute: " + this.destination);
            }
            if (this.destinationOwnerAndPermission == null) {
                String owner = this.preserve.preserve(PreserveAttributes.Option.OWNER) ? this.origin.getOwner() : null;
                String group = null;
                if (this.preserve.preserve(PreserveAttributes.Option.GROUP)) {
                    group = this.origin.getGroup();
                } else if (this.configuration.getTargetGroup().isPresent()) {
                    group = (String)this.configuration.getTargetGroup().get();
                }
                FsPermission permission = this.preserve.preserve(PreserveAttributes.Option.PERMISSION) ? this.origin.getPermission() : null;
                this.destinationOwnerAndPermission = new OwnerAndPermission(owner, group, permission);
            }
            if (this.ancestorsOwnerAndPermission == null) {
                this.ancestorsOwnerAndPermission = this.replicateAncestorsOwnerAndPermission(this.originFs, this.origin.getPath(), this.configuration.getTargetFs(), this.destination);
            }
            if (this.checksum == null) {
                if (ConfigUtils.getBoolean((Config)this.configuration.getConfig(), (String)"copy.skipChecksum", (boolean)true)) {
                    this.checksum = EMPTY_CHECKSUM;
                } else {
                    FileChecksum checksumTmp = this.origin.isDirectory() ? null : this.originFs.getFileChecksum(this.origin.getPath());
                    byte[] byArray = this.checksum = checksumTmp == null ? EMPTY_CHECKSUM : checksumTmp.getBytes();
                }
            }
            if (this.fileSet == null) {
                this.fileSet = "";
            }
            if (this.originTimestamp == 0L) {
                this.originTimestamp = this.origin.getModificationTime();
            }
            if (this.upstreamTimestamp == 0L) {
                this.upstreamTimestamp = this.origin.getModificationTime();
            }
            return new CopyableFile(this.origin, this.destination, this.destinationOwnerAndPermission, this.ancestorsOwnerAndPermission, this.checksum, this.preserve, this.fileSet, this.originTimestamp, this.upstreamTimestamp, this.additionalMetadata, this.datasetOutputPath, this.dataFileVersionStrategy);
        }

        private List<OwnerAndPermission> replicateAncestorsOwnerAndPermission(FileSystem originFs, Path originPath, FileSystem targetFs, Path destinationPath) throws IOException {
            ArrayList ancestorOwnerAndPermissions = Lists.newArrayList();
            Path currentOriginPath = originPath.getParent();
            for (Path currentTargetPath = destinationPath.getParent(); currentOriginPath != null && currentTargetPath != null && currentOriginPath.getName().equals(currentTargetPath.getName()); currentOriginPath = currentOriginPath.getParent(), currentTargetPath = currentTargetPath.getParent()) {
                Optional<FileStatus> targetFileStatus = this.configuration.getCopyContext().getFileStatus(targetFs, currentTargetPath);
                if (targetFileStatus.isPresent()) {
                    return ancestorOwnerAndPermissions;
                }
                ancestorOwnerAndPermissions.add(CopyableFile.resolveReplicatedOwnerAndPermission(originFs, currentOriginPath, this.configuration));
            }
            return ancestorOwnerAndPermissions;
        }

        Builder() {
        }

        public Builder origin(FileStatus origin) {
            this.origin = origin;
            return this;
        }

        public Builder destination(Path destination) {
            this.destination = destination;
            return this;
        }

        public Builder destinationOwnerAndPermission(OwnerAndPermission destinationOwnerAndPermission) {
            this.destinationOwnerAndPermission = destinationOwnerAndPermission;
            return this;
        }

        public Builder ancestorsOwnerAndPermission(List<OwnerAndPermission> ancestorsOwnerAndPermission) {
            this.ancestorsOwnerAndPermission = ancestorsOwnerAndPermission;
            return this;
        }

        public Builder checksum(byte[] checksum) {
            this.checksum = checksum;
            return this;
        }

        public Builder preserve(PreserveAttributes preserve) {
            this.preserve = preserve;
            return this;
        }

        public Builder fileSet(String fileSet) {
            this.fileSet = fileSet;
            return this;
        }

        public Builder originTimestamp(long originTimestamp) {
            this.originTimestamp = originTimestamp;
            return this;
        }

        public Builder upstreamTimestamp(long upstreamTimestamp) {
            this.upstreamTimestamp = upstreamTimestamp;
            return this;
        }

        public Builder additionalMetadata(Map<String, String> additionalMetadata) {
            this.additionalMetadata = additionalMetadata;
            return this;
        }

        public Builder datasetOutputPath(String datasetOutputPath) {
            this.datasetOutputPath = datasetOutputPath;
            return this;
        }

        public Builder dataFileVersionStrategy(String dataFileVersionStrategy) {
            this.dataFileVersionStrategy = dataFileVersionStrategy;
            return this;
        }

        public String toString() {
            return "CopyableFile.Builder(origin=" + this.origin + ", destination=" + this.destination + ", destinationOwnerAndPermission=" + this.destinationOwnerAndPermission + ", ancestorsOwnerAndPermission=" + this.ancestorsOwnerAndPermission + ", checksum=" + Arrays.toString(this.checksum) + ", preserve=" + this.preserve + ", fileSet=" + this.fileSet + ", originTimestamp=" + this.originTimestamp + ", upstreamTimestamp=" + this.upstreamTimestamp + ", additionalMetadata=" + this.additionalMetadata + ", datasetOutputPath=" + this.datasetOutputPath + ", dataFileVersionStrategy=" + this.dataFileVersionStrategy + ")";
        }
    }
}

