/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.conversion.hive.materializer;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.data.management.conversion.hive.entities.QueryBasedHivePublishEntity;
import org.apache.gobblin.data.management.conversion.hive.entities.StageableTableMetadata;
import org.apache.gobblin.data.management.conversion.hive.materializer.CopyTableQueryGenerator;
import org.apache.gobblin.data.management.conversion.hive.materializer.HiveMaterializerTaskFactory;
import org.apache.gobblin.data.management.conversion.hive.materializer.MaterializeTableQueryGenerator;
import org.apache.gobblin.data.management.conversion.hive.materializer.QueryBasedMaterializerQueryGenerator;
import org.apache.gobblin.data.management.conversion.hive.source.HiveSource;
import org.apache.gobblin.data.management.conversion.hive.source.HiveWorkUnit;
import org.apache.gobblin.data.management.conversion.hive.task.HiveConverterUtils;
import org.apache.gobblin.data.management.conversion.hive.task.HiveTask;
import org.apache.gobblin.data.management.conversion.hive.task.QueryGenerator;
import org.apache.gobblin.data.management.copy.hive.HiveDataset;
import org.apache.gobblin.runtime.TaskContext;
import org.apache.gobblin.runtime.task.TaskUtils;
import org.apache.gobblin.source.workunit.WorkUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveMaterializer
extends HiveTask {
    private static final Logger log = LoggerFactory.getLogger(HiveMaterializer.class);
    protected static final String STAGEABLE_TABLE_METADATA_KEY = "internal.hiveMaterializer.stageableTableMetadata";
    protected static final String MATERIALIZER_MODE_KEY = "internal.hiveMaterializer.materializerMode";
    protected static final String STORAGE_FORMAT_KEY = "internal.hiveMaterializer.storageFormat";
    protected static final String QUERY_RESULT_TO_MATERIALIZE_KEY = "internal.hiveMaterializer.queryResultToMaterialize";
    private final QueryGenerator queryGenerator;

    public static HiveWorkUnit tableCopyWorkUnit(HiveDataset dataset, StageableTableMetadata destinationTable, @Nullable String partitionName) {
        HiveWorkUnit workUnit = new HiveWorkUnit(dataset);
        workUnit.setProp(MATERIALIZER_MODE_KEY, MaterializerMode.TABLE_COPY.name());
        workUnit.setProp(STAGEABLE_TABLE_METADATA_KEY, HiveSource.GENERICS_AWARE_GSON.toJson((Object)destinationTable));
        if (!Strings.isNullOrEmpty((String)partitionName)) {
            workUnit.setPartitionName(partitionName);
        }
        TaskUtils.setTaskFactoryClass((State)workUnit, HiveMaterializerTaskFactory.class);
        return workUnit;
    }

    public static HiveWorkUnit viewMaterializationWorkUnit(HiveDataset dataset, HiveConverterUtils.StorageFormat storageFormat, StageableTableMetadata destinationTable, @Nullable String partitionName) {
        HiveWorkUnit workUnit = new HiveWorkUnit(dataset);
        workUnit.setProp(MATERIALIZER_MODE_KEY, MaterializerMode.TABLE_MATERIALIZATION.name());
        workUnit.setProp(STORAGE_FORMAT_KEY, storageFormat.name());
        workUnit.setProp(STAGEABLE_TABLE_METADATA_KEY, HiveSource.GENERICS_AWARE_GSON.toJson((Object)destinationTable));
        if (!Strings.isNullOrEmpty((String)partitionName)) {
            workUnit.setPartitionName(partitionName);
        }
        TaskUtils.setTaskFactoryClass((State)workUnit, HiveMaterializerTaskFactory.class);
        return workUnit;
    }

    public static WorkUnit queryResultMaterializationWorkUnit(String query, HiveConverterUtils.StorageFormat storageFormat, StageableTableMetadata destinationTable) {
        WorkUnit workUnit = new WorkUnit();
        workUnit.setProp(MATERIALIZER_MODE_KEY, (Object)MaterializerMode.QUERY_RESULT_MATERIALIZATION.name());
        workUnit.setProp(STORAGE_FORMAT_KEY, (Object)storageFormat.name());
        workUnit.setProp(QUERY_RESULT_TO_MATERIALIZE_KEY, (Object)query);
        workUnit.setProp(STAGEABLE_TABLE_METADATA_KEY, (Object)HiveSource.GENERICS_AWARE_GSON.toJson((Object)destinationTable));
        TaskUtils.setTaskFactoryClass((State)workUnit, HiveMaterializerTaskFactory.class);
        HiveTask.disableHiveWatermarker((State)workUnit);
        return workUnit;
    }

    public static StageableTableMetadata parseStageableTableMetadata(WorkUnit workUnit) {
        return (StageableTableMetadata)HiveSource.GENERICS_AWARE_GSON.fromJson(workUnit.getProp(STAGEABLE_TABLE_METADATA_KEY), StageableTableMetadata.class);
    }

    public HiveMaterializer(TaskContext taskContext) throws IOException {
        super(taskContext);
        MaterializerMode materializerMode = MaterializerMode.valueOf(this.workUnitState.getProp(MATERIALIZER_MODE_KEY));
        this.queryGenerator = materializerMode.createQueryGenerator(this.workUnitState);
    }

    @Override
    public List<String> generateHiveQueries() {
        return this.queryGenerator.generateQueries();
    }

    @Override
    public QueryBasedHivePublishEntity generatePublishQueries() throws Exception {
        return this.queryGenerator.generatePublishQueries();
    }

    private static enum MaterializerMode {
        TABLE_MATERIALIZATION{

            @Override
            public QueryGenerator createQueryGenerator(WorkUnitState state) throws IOException {
                return new MaterializeTableQueryGenerator(state);
            }
        }
        ,
        TABLE_COPY{

            @Override
            public QueryGenerator createQueryGenerator(WorkUnitState state) throws IOException {
                return new CopyTableQueryGenerator(state);
            }
        }
        ,
        QUERY_RESULT_MATERIALIZATION{

            @Override
            public QueryGenerator createQueryGenerator(WorkUnitState state) throws IOException {
                return new QueryBasedMaterializerQueryGenerator(state);
            }
        };


        public abstract QueryGenerator createQueryGenerator(WorkUnitState var1) throws IOException;
    }
}

