/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.version.finder;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.IOException;
import java.util.Properties;
import org.apache.gobblin.data.management.version.FileSystemDatasetVersion;
import org.apache.gobblin.data.management.version.TimestampedDatasetVersion;
import org.apache.gobblin.data.management.version.finder.DatasetVersionFinder;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.joda.time.DateTime;

public class GlobModTimeDatasetVersionFinder
extends DatasetVersionFinder<TimestampedDatasetVersion> {
    private final Path globPattern;
    private static final String VERSION_FINDER_GLOB_PATTERN_KEY = "version.globPattern";

    public GlobModTimeDatasetVersionFinder(FileSystem fs, Config config) {
        this(fs, config.hasPath(VERSION_FINDER_GLOB_PATTERN_KEY) ? new Path(config.getString(VERSION_FINDER_GLOB_PATTERN_KEY)) : new Path("*"));
    }

    public GlobModTimeDatasetVersionFinder(FileSystem fs, Properties props) {
        this(fs, ConfigFactory.parseProperties((Properties)props));
    }

    public GlobModTimeDatasetVersionFinder(FileSystem fs, Path globPattern) {
        super(fs);
        this.globPattern = globPattern;
    }

    @Override
    public Class<? extends FileSystemDatasetVersion> versionClass() {
        return TimestampedDatasetVersion.class;
    }

    @Override
    public Path globVersionPattern() {
        return this.globPattern;
    }

    @Override
    public TimestampedDatasetVersion getDatasetVersion(Path pathRelativeToDatasetRoot, Path fullPath) {
        try {
            return new TimestampedDatasetVersion(new DateTime(this.fs.getFileStatus(fullPath).getModificationTime()), fullPath);
        }
        catch (IOException e) {
            return null;
        }
    }
}

