/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.trash;

import java.util.Properties;
import org.apache.gobblin.data.management.trash.SnapshotCleanupPolicy;
import org.apache.gobblin.data.management.trash.Trash;
import org.apache.hadoop.fs.FileStatus;
import org.joda.time.DateTime;

public class TimeBasedSnapshotCleanupPolicy
implements SnapshotCleanupPolicy {
    public static final String SNAPSHOT_RETENTION_POLICY_MINUTES_KEY = "gobblin.trash.snapshot.retention.minutes";
    public static final int SNAPSHOT_RETENTION_POLICY_MINUTES_DEFAULT = 1440;
    private final int retentionMinutes;

    public TimeBasedSnapshotCleanupPolicy(Properties props) {
        this.retentionMinutes = Integer.parseInt(props.getProperty(SNAPSHOT_RETENTION_POLICY_MINUTES_KEY, Integer.toString(1440)));
    }

    @Override
    public boolean shouldDeleteSnapshot(FileStatus snapshot, Trash trash) {
        DateTime snapshotTime = Trash.TRASH_SNAPSHOT_NAME_FORMATTER.parseDateTime(snapshot.getPath().getName());
        return snapshotTime.plusMinutes(this.retentionMinutes).isBeforeNow();
    }
}

