/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.retention.version;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import java.io.IOException;
import java.util.HashSet;
import org.apache.gobblin.data.management.retention.dataset.CleanableDataset;
import org.apache.gobblin.data.management.retention.dataset.CleanableHiveDataset;
import org.apache.gobblin.data.management.retention.version.VersionCleaner;
import org.apache.gobblin.data.management.version.DatasetVersion;
import org.apache.gobblin.data.management.version.HiveDatasetVersion;
import org.apache.gobblin.util.AutoReturnableObject;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveDatasetVersionCleaner
extends VersionCleaner {
    private static final Logger log = LoggerFactory.getLogger(HiveDatasetVersionCleaner.class);
    public static final String REPLACEMENT_HIVE_DB_NAME_KEY = "hive.replacementHiveDbName";
    public static final String REPLACEMENT_HIVE_TABLE_NAME_KEY = "hive.replacementHiveTableName";
    public static final String SHOULD_REPLACE_PARTITION_KEY = "hive.shouldReplacePartition";
    private final CleanableHiveDataset cleanableHiveDataset;
    private final HiveDatasetVersion hiveDatasetVersion;
    private final Optional<String> replacementDbName;
    private final Optional<String> replacementTableName;

    public HiveDatasetVersionCleaner(DatasetVersion datasetVersion, CleanableDataset cleanableDataset) {
        super(datasetVersion, cleanableDataset);
        Preconditions.checkArgument((boolean)(cleanableDataset instanceof CleanableHiveDataset), (Object)String.format("%s only supports %s, found: %s", this.getClass(), CleanableHiveDataset.class, cleanableDataset.getClass()));
        Preconditions.checkArgument((boolean)(datasetVersion instanceof HiveDatasetVersion), (Object)String.format("%s only supports %s, found: %s", this.getClass(), HiveDatasetVersionCleaner.class, datasetVersion.getClass()));
        this.cleanableHiveDataset = (CleanableHiveDataset)cleanableDataset;
        this.hiveDatasetVersion = (HiveDatasetVersion)datasetVersion;
        this.replacementDbName = Optional.fromNullable((Object)ConfigUtils.getString((Config)this.cleanableHiveDataset.getDatasetConfig(), (String)REPLACEMENT_HIVE_DB_NAME_KEY, null));
        this.replacementTableName = Optional.fromNullable((Object)ConfigUtils.getString((Config)this.cleanableHiveDataset.getDatasetConfig(), (String)REPLACEMENT_HIVE_TABLE_NAME_KEY, null));
    }

    @Override
    public void preCleanAction() throws IOException {
    }

    @Override
    public void clean() throws IOException {
        HashSet<Path> possiblyEmptyDirectories = new HashSet<Path>();
        try (AutoReturnableObject client = this.cleanableHiveDataset.getClientPool().getClient();){
            Partition partition = this.hiveDatasetVersion.getPartition();
            try {
                if (!this.cleanableHiveDataset.isSimulate()) {
                    ((IMetaStoreClient)client.get()).dropPartition(partition.getTable().getDbName(), partition.getTable().getTableName(), partition.getValues(), false);
                    log.info("Successfully dropped partition " + partition.getCompleteName());
                } else {
                    log.info("Simulating drop partition " + partition.getCompleteName());
                }
                if (this.cleanableHiveDataset.isShouldDeleteData()) {
                    this.cleanableHiveDataset.getFsCleanableHelper().clean(this.hiveDatasetVersion, possiblyEmptyDirectories);
                }
            }
            catch (IOException | TException e) {
                log.warn(String.format("Failed to completely delete partition %s.", partition.getCompleteName()), e);
                throw new IOException(e);
            }
        }
        this.cleanableHiveDataset.getFsCleanableHelper().cleanEmptyDirectories(possiblyEmptyDirectories, this.cleanableHiveDataset);
    }

    @Override
    public void postCleanAction() throws IOException {
        boolean shouldReplacePartition = HiveDatasetVersionCleaner.shouldReplacePartition(this.cleanableHiveDataset.getDatasetConfig(), this.hiveDatasetVersion.getPartition().getTable().getDbName(), this.hiveDatasetVersion.getPartition().getTable().getTableName(), this.replacementDbName, this.replacementTableName);
        if (shouldReplacePartition) {
            try (AutoReturnableObject client = this.cleanableHiveDataset.getClientPool().getClient();){
                org.apache.hadoop.hive.metastore.api.Partition sourcePartition = ((IMetaStoreClient)client.get()).getPartition((String)this.replacementDbName.get(), (String)this.replacementTableName.get(), this.hiveDatasetVersion.getPartition().getValues());
                org.apache.hadoop.hive.metastore.api.Partition replacementPartition = new org.apache.hadoop.hive.metastore.api.Partition(this.hiveDatasetVersion.getPartition().getValues(), this.hiveDatasetVersion.getPartition().getTable().getDbName(), this.hiveDatasetVersion.getPartition().getTable().getTableName(), sourcePartition.getCreateTime(), sourcePartition.getLastAccessTime(), sourcePartition.getSd(), sourcePartition.getParameters());
                if (!this.cleanableHiveDataset.isSimulate()) {
                    ((IMetaStoreClient)client.get()).add_partition(replacementPartition);
                    log.info("Successfully swapped partition " + replacementPartition);
                } else {
                    log.info("Simulating swap partition " + replacementPartition);
                }
            }
            catch (TException e) {
                log.warn(String.format("Failed to swap-in replacement partition for partition being deleted: %s", this.hiveDatasetVersion.getPartition().getCompleteName()), (Throwable)e);
                throw new IOException(e);
            }
        }
    }

    @VisibleForTesting
    protected static boolean shouldReplacePartition(Config config, String replacedPartitionDbName, String replacedPartitionTableName, Optional<String> replacementPartitionDbName, Optional<String> replacementPartitionTableName) {
        boolean shouldReplacePartition = ConfigUtils.getBoolean((Config)config, (String)SHOULD_REPLACE_PARTITION_KEY, (boolean)false);
        if (!replacementPartitionDbName.isPresent() || !replacementPartitionTableName.isPresent()) {
            return false;
        }
        return shouldReplacePartition && (!replacedPartitionDbName.equalsIgnoreCase((String)replacementPartitionDbName.get()) || !replacedPartitionTableName.equalsIgnoreCase((String)replacementPartitionTableName.get()));
    }
}

