/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.policy;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.typesafe.config.Config;
import java.util.Collection;
import java.util.List;
import org.apache.gobblin.annotation.Alias;
import org.apache.gobblin.data.management.policy.VersionSelectionPolicy;
import org.apache.gobblin.data.management.version.FileSystemDatasetVersion;
import org.apache.gobblin.data.management.version.TimestampedDatasetVersion;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;

@Alias(value="SelectBetweenTimeBasedPolicy")
public class SelectBetweenTimeBasedPolicy
implements VersionSelectionPolicy<TimestampedDatasetVersion> {
    protected final Optional<Period> minLookBackPeriod;
    protected final Optional<Period> maxLookBackPeriod;
    public static final String TIME_BASED_SELECTION_MAX_LOOK_BACK_TIME_KEY = "selection.timeBased.maxLookbackTime";
    public static final String TIME_BASED_SELECTION_MIN_LOOK_BACK_TIME_KEY = "selection.timeBased.minLookbackTime";

    public SelectBetweenTimeBasedPolicy(Config conf) {
        this((Optional<Period>)(conf.hasPath(TIME_BASED_SELECTION_MIN_LOOK_BACK_TIME_KEY) ? Optional.of((Object)SelectBetweenTimeBasedPolicy.getLookBackPeriod(conf.getString(TIME_BASED_SELECTION_MIN_LOOK_BACK_TIME_KEY))) : Optional.absent()), (Optional<Period>)(conf.hasPath(TIME_BASED_SELECTION_MAX_LOOK_BACK_TIME_KEY) ? Optional.of((Object)SelectBetweenTimeBasedPolicy.getLookBackPeriod(conf.getString(TIME_BASED_SELECTION_MAX_LOOK_BACK_TIME_KEY))) : Optional.absent()));
    }

    public SelectBetweenTimeBasedPolicy(Optional<Period> minLookBackPeriod, Optional<Period> maxLookBackPeriod) {
        this.minLookBackPeriod = minLookBackPeriod;
        this.maxLookBackPeriod = maxLookBackPeriod;
    }

    @Override
    public Class<? extends FileSystemDatasetVersion> versionClass() {
        return TimestampedDatasetVersion.class;
    }

    @Override
    public Collection<TimestampedDatasetVersion> listSelectedVersions(List<TimestampedDatasetVersion> allVersions) {
        return Lists.newArrayList((Iterable)Collections2.filter(allVersions, this.getSelectionPredicate()));
    }

    private Predicate<TimestampedDatasetVersion> getSelectionPredicate() {
        return new Predicate<TimestampedDatasetVersion>(){

            public boolean apply(TimestampedDatasetVersion version) {
                return version.getDateTime().plus((ReadablePeriod)SelectBetweenTimeBasedPolicy.this.maxLookBackPeriod.or((Object)new Period(DateTime.now().getMillis()))).isAfterNow() && version.getDateTime().plus((ReadablePeriod)SelectBetweenTimeBasedPolicy.this.minLookBackPeriod.or((Object)new Period(0L))).isBeforeNow();
            }
        };
    }

    protected static Period getLookBackPeriod(String lookbackTime) {
        PeriodFormatter periodFormatter = new PeriodFormatterBuilder().appendYears().appendSuffix("y").appendMonths().appendSuffix("M").appendDays().appendSuffix("d").appendHours().appendSuffix("h").appendMinutes().appendSuffix("m").toFormatter();
        return periodFormatter.parsePeriod(lookbackTime);
    }

    public String toString() {
        return "SelectBetweenTimeBasedPolicy(minLookBackPeriod=" + this.minLookBackPeriod + ", maxLookBackPeriod=" + this.maxLookBackPeriod + ")";
    }
}

