/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy.splitter;

import com.google.common.base.Optional;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.math3.util.ArithmeticUtils;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.IdentityConverter;
import org.apache.gobblin.data.management.copy.CopyEntity;
import org.apache.gobblin.data.management.copy.CopySource;
import org.apache.gobblin.data.management.copy.CopyableFile;
import org.apache.gobblin.data.management.copy.writer.FileAwareInputStreamDataWriter;
import org.apache.gobblin.data.management.copy.writer.FileAwareInputStreamDataWriterBuilder;
import org.apache.gobblin.source.workunit.WorkUnit;
import org.apache.gobblin.util.guid.Guid;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistcpFileSplitter {
    private static final Logger log = LoggerFactory.getLogger(DistcpFileSplitter.class);
    public static final String SPLIT_ENABLED = "gobblin.copy.split.enabled";
    public static final String MAX_SPLIT_SIZE_KEY = "gobblin.copy.file.max.split.size";
    public static final long DEFAULT_MAX_SPLIT_SIZE = Long.MAX_VALUE;
    public static final Set<String> KNOWN_SCHEMES_SUPPORTING_CONCAT = Sets.newHashSet((Object[])new String[]{"hdfs", "adl"});
    private static final String SPLIT_KEY = "gobblin.copy.file.splitter.split";
    private static final Gson GSON = new Gson();

    public static Collection<WorkUnit> splitFile(CopyableFile file, WorkUnit workUnit, FileSystem targetFs) throws IOException {
        long len = file.getFileStatus().getLen();
        long blockSize = ArithmeticUtils.lcm((long)file.getFileStatus().getBlockSize(), (long)file.getBlockSize(targetFs));
        long maxSplitSize = workUnit.getPropAsLong(MAX_SPLIT_SIZE_KEY, Long.MAX_VALUE);
        if (maxSplitSize < blockSize) {
            log.warn(String.format("Max split size must be at least block size. Adjusting to %d.", blockSize));
            maxSplitSize = blockSize;
        }
        if (len < maxSplitSize) {
            return Lists.newArrayList((Object[])new WorkUnit[]{workUnit});
        }
        ArrayList newWorkUnits = Lists.newArrayList();
        long lengthPerSplit = maxSplitSize / blockSize * blockSize;
        int splits = (int)(len / lengthPerSplit + 1L);
        for (int i = 0; i < splits; ++i) {
            WorkUnit newWorkUnit = WorkUnit.copyOf((WorkUnit)workUnit);
            long lowPos = lengthPerSplit * (long)i;
            long highPos = Math.min(lengthPerSplit * (long)(i + 1), len);
            Split split = new Split(lowPos, highPos, i, splits, String.format("%s.__PART%d__", file.getDestination().getName(), i));
            String serializedSplit = GSON.toJson((Object)split);
            newWorkUnit.setProp(SPLIT_KEY, (Object)serializedSplit);
            Guid oldGuid = (Guid)CopySource.getWorkUnitGuid((State)newWorkUnit).get();
            Guid newGuid = oldGuid.append(new Guid[]{Guid.fromStrings((String[])new String[]{serializedSplit})});
            CopySource.setWorkUnitGuid((State)workUnit, newGuid);
            newWorkUnits.add(newWorkUnit);
        }
        return newWorkUnits;
    }

    public static Collection<WorkUnitState> mergeAllSplitWorkUnits(FileSystem fs, Collection<WorkUnitState> workUnits) throws IOException {
        ArrayListMultimap splitWorkUnitsMap = ArrayListMultimap.create();
        for (WorkUnitState workUnit : workUnits) {
            if (!DistcpFileSplitter.isSplitWorkUnit((State)workUnit)) continue;
            CopyableFile copyableFile = (CopyableFile)CopySource.deserializeCopyEntity((State)workUnit);
            splitWorkUnitsMap.put((Object)copyableFile, (Object)workUnit);
        }
        for (CopyableFile file : splitWorkUnitsMap.keySet()) {
            log.info(String.format("Merging split file %s.", file.getDestination()));
            WorkUnitState oldWorkUnit = (WorkUnitState)splitWorkUnitsMap.get((Object)file).get(0);
            Path outputDir = FileAwareInputStreamDataWriter.getOutputDir((State)oldWorkUnit);
            CopyEntity.DatasetAndPartition datasetAndPartition = file.getDatasetAndPartition(CopySource.deserializeCopyableDataset((State)oldWorkUnit));
            Path parentPath = FileAwareInputStreamDataWriter.getOutputFilePath(file, outputDir, datasetAndPartition).getParent();
            WorkUnitState newWorkUnit = DistcpFileSplitter.mergeSplits(fs, file, splitWorkUnitsMap.get((Object)file), parentPath);
            for (WorkUnitState wu : splitWorkUnitsMap.get((Object)file)) {
                wu.setWorkingState(WorkUnitState.WorkingState.COMMITTED);
                workUnits.remove(wu);
            }
            workUnits.add(newWorkUnit);
        }
        return workUnits;
    }

    private static WorkUnitState mergeSplits(FileSystem fs, CopyableFile file, Collection<WorkUnitState> workUnits, Path parentPath) throws IOException {
        log.info(String.format("File %s was written in %d parts. Merging.", file.getDestination(), workUnits.size()));
        Path[] parts = new Path[workUnits.size()];
        for (WorkUnitState workUnit : workUnits) {
            if (!DistcpFileSplitter.isSplitWorkUnit((State)workUnit)) {
                throw new IOException("Not a split work unit.");
            }
            Split split = (Split)DistcpFileSplitter.getSplit((State)workUnit).get();
            parts[split.getSplitNumber()] = new Path(parentPath, split.getPartName());
        }
        Path target = new Path(parentPath, file.getDestination().getName());
        fs.rename(parts[0], target);
        fs.concat(target, Arrays.copyOfRange(parts, 1, parts.length));
        WorkUnitState finalWorkUnit = workUnits.iterator().next();
        finalWorkUnit.removeProp(SPLIT_KEY);
        return finalWorkUnit;
    }

    public static boolean isSplitWorkUnit(State workUnit) {
        return workUnit.contains(SPLIT_KEY);
    }

    public static Optional<Split> getSplit(State workUnit) {
        return workUnit.contains(SPLIT_KEY) ? Optional.of((Object)GSON.fromJson(workUnit.getProp(SPLIT_KEY), Split.class)) : Optional.absent();
    }

    public static boolean allowSplit(State state, FileSystem targetFs) {
        List converterClassNames = Collections.emptyList();
        if (state.contains("converter.classes")) {
            converterClassNames = state.getPropAsList("converter.classes");
        }
        return state.getPropAsBoolean(SPLIT_ENABLED, false) && KNOWN_SCHEMES_SUPPORTING_CONCAT.contains(targetFs.getUri().getScheme()) && state.getProp("writer.builder.class", "").equals(FileAwareInputStreamDataWriterBuilder.class.getName()) && converterClassNames.stream().noneMatch(s -> !s.equals(IdentityConverter.class.getName()));
    }

    public static class Split {
        private final long lowPosition;
        private final long highPosition;
        private final int splitNumber;
        private final int totalSplits;
        private final String partName;

        public final boolean isLastSplit() {
            return this.splitNumber == this.totalSplits - 1;
        }

        @ConstructorProperties(value={"lowPosition", "highPosition", "splitNumber", "totalSplits", "partName"})
        public Split(long lowPosition, long highPosition, int splitNumber, int totalSplits, String partName) {
            this.lowPosition = lowPosition;
            this.highPosition = highPosition;
            this.splitNumber = splitNumber;
            this.totalSplits = totalSplits;
            this.partName = partName;
        }

        public long getLowPosition() {
            return this.lowPosition;
        }

        public long getHighPosition() {
            return this.highPosition;
        }

        public int getSplitNumber() {
            return this.splitNumber;
        }

        public int getTotalSplits() {
            return this.totalSplits;
        }

        public String getPartName() {
            return this.partName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Split)) {
                return false;
            }
            Split other = (Split)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getLowPosition() != other.getLowPosition()) {
                return false;
            }
            if (this.getHighPosition() != other.getHighPosition()) {
                return false;
            }
            if (this.getSplitNumber() != other.getSplitNumber()) {
                return false;
            }
            if (this.getTotalSplits() != other.getTotalSplits()) {
                return false;
            }
            String this$partName = this.getPartName();
            String other$partName = other.getPartName();
            return !(this$partName == null ? other$partName != null : !this$partName.equals(other$partName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Split;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $lowPosition = this.getLowPosition();
            result = result * 59 + (int)($lowPosition >>> 32 ^ $lowPosition);
            long $highPosition = this.getHighPosition();
            result = result * 59 + (int)($highPosition >>> 32 ^ $highPosition);
            result = result * 59 + this.getSplitNumber();
            result = result * 59 + this.getTotalSplits();
            String $partName = this.getPartName();
            result = result * 59 + ($partName == null ? 43 : $partName.hashCode());
            return result;
        }

        public String toString() {
            return "DistcpFileSplitter.Split(lowPosition=" + this.getLowPosition() + ", highPosition=" + this.getHighPosition() + ", splitNumber=" + this.getSplitNumber() + ", totalSplits=" + this.getTotalSplits() + ", partName=" + this.getPartName() + ")";
        }
    }
}

