/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy.replication;

import com.google.common.base.Splitter;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.List;
import org.apache.gobblin.source.extractor.Watermark;
import org.apache.gobblin.source.extractor.WatermarkSerializerHelper;

public class WatermarkMetadataUtil {
    public static final String DELIMITER = "\n";

    public static String serialize(Watermark watermark) {
        return watermark.getClass().getCanonicalName() + DELIMITER + watermark.toJson().toString();
    }

    public static Watermark deserialize(String content) throws WatermarkMetadataMulFormatException {
        List tmp = Splitter.on((String)DELIMITER).trimResults().omitEmptyStrings().splitToList((CharSequence)content);
        if (tmp.size() < 2) {
            throw new WatermarkMetadataMulFormatException("wrong format " + content);
        }
        String classname = (String)tmp.get(0);
        String jsonStr = (String)tmp.get(1);
        try {
            Class<?> watermarkClass = Class.forName(classname);
            return WatermarkSerializerHelper.convertJsonToWatermark((JsonElement)new JsonParser().parse(jsonStr), watermarkClass);
        }
        catch (ClassNotFoundException e) {
            throw new WatermarkMetadataMulFormatException("wrong format " + e.getMessage());
        }
    }

    static class WatermarkMetadataMulFormatException
    extends Exception {
        private static final long serialVersionUID = 6748785718027224698L;

        public WatermarkMetadataMulFormatException(String s) {
            super(s);
        }
    }
}

