/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy.replication;

import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import org.apache.gobblin.annotation.Alias;
import org.apache.gobblin.data.management.copy.replication.EndPointFactory;
import org.apache.gobblin.data.management.copy.replication.HadoopFsEndPoint;
import org.apache.gobblin.data.management.copy.replication.HadoopFsReplicaConfig;
import org.apache.gobblin.data.management.copy.replication.ReplicaHadoopFsEndPoint;
import org.apache.gobblin.data.management.copy.replication.SourceHadoopFsEndPoint;

@Alias(value="HadoopFsEndPointFactory")
public class HadoopFsEndPointFactory
implements EndPointFactory {
    public static final String HADOOP_FS_CONFIG_KEY = "hadoopfs";

    @Override
    public HadoopFsEndPoint buildSource(Config sourceConfig, Config selectionConfig) {
        Preconditions.checkArgument((boolean)sourceConfig.hasPath(HADOOP_FS_CONFIG_KEY), (Object)"missing required config entery hadoopfs");
        return new SourceHadoopFsEndPoint(new HadoopFsReplicaConfig(sourceConfig.getConfig(HADOOP_FS_CONFIG_KEY)), selectionConfig);
    }

    @Override
    public HadoopFsEndPoint buildReplica(Config replicaConfig, String replicaName, Config selectionConfig) {
        Preconditions.checkArgument((boolean)replicaConfig.hasPath(HADOOP_FS_CONFIG_KEY), (Object)"missing required config entery hadoopfs");
        return new ReplicaHadoopFsEndPoint(new HadoopFsReplicaConfig(replicaConfig.getConfig(HADOOP_FS_CONFIG_KEY)), replicaName, selectionConfig);
    }
}

