/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy.replication;

import java.io.IOException;
import java.net.URI;
import org.apache.gobblin.data.management.copy.replication.HadoopFsEndPoint;
import org.apache.gobblin.dataset.FileSystemDataset;
import org.apache.gobblin.util.HadoopUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class HadoopFsEndPointDataset
implements FileSystemDataset {
    private final HadoopFsEndPoint endPoint;
    private Path qualifiedDatasetRoot;

    public HadoopFsEndPointDataset(HadoopFsEndPoint endPoint) {
        this.endPoint = endPoint;
        Configuration conf = HadoopUtils.newConfiguration();
        try {
            FileSystem fs = FileSystem.get((URI)this.endPoint.getFsURI(), (Configuration)conf);
            this.qualifiedDatasetRoot = fs.makeQualified(this.endPoint.getDatasetPath());
        }
        catch (IOException e1) {
            this.qualifiedDatasetRoot = this.endPoint.getDatasetPath();
        }
    }

    public String datasetURN() {
        return this.qualifiedDatasetRoot.toString();
    }

    public Path datasetRoot() {
        return this.qualifiedDatasetRoot;
    }
}

