/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy.replication;

import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import org.apache.gobblin.annotation.Alias;
import org.apache.gobblin.data.management.copy.replication.DataFlowTopologyPickerBySource;
import org.apache.gobblin.data.management.copy.replication.EndPoint;
import org.apache.gobblin.data.management.copy.replication.HadoopFsEndPoint;

@Alias(value="DataFlowTopologyPickerByHadoopFsSource")
public class DataFlowTopologyPickerByHadoopFsSource
implements DataFlowTopologyPickerBySource {
    @Override
    public Config getPreferredRoutes(Config allTopologies, EndPoint source) {
        Preconditions.checkArgument((boolean)(source instanceof HadoopFsEndPoint), (Object)("source is NOT expectecd class " + HadoopFsEndPoint.class.getCanonicalName()));
        HadoopFsEndPoint hadoopFsSource = (HadoopFsEndPoint)source;
        String clusterName = hadoopFsSource.getClusterName();
        Preconditions.checkArgument((boolean)allTopologies.hasPath(clusterName), (Object)("Can not find preferred topology for cluster name " + clusterName));
        return allTopologies.getConfig(clusterName);
    }
}

