/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy.replication;

import com.google.common.base.Optional;
import com.typesafe.config.Config;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import org.apache.gobblin.config.client.ConfigClient;
import org.apache.gobblin.data.management.copy.replication.ConfigBasedDatasetsFinder;
import org.apache.gobblin.data.management.copy.replication.ConfigBasedMultiDatasets;
import org.apache.gobblin.dataset.Dataset;
import org.apache.hadoop.fs.FileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigBasedCopyableDatasetFinder
extends ConfigBasedDatasetsFinder {
    private static final Logger log = LoggerFactory.getLogger(ConfigBasedCopyableDatasetFinder.class);

    public ConfigBasedCopyableDatasetFinder(FileSystem fs, Properties jobProps) throws IOException {
        super(fs, jobProps);
    }

    @Override
    protected Callable<Void> findDatasetsCallable(final ConfigClient confClient, final URI u, final Properties p, final Optional<List<String>> blacklistPatterns, final Collection<Dataset> datasets) {
        return new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Config c = confClient.getConfig(u);
                List<Dataset> datasetForConfig = new ConfigBasedMultiDatasets(c, p, (Optional<List<String>>)blacklistPatterns).getConfigBasedDatasetList();
                datasets.addAll(datasetForConfig);
                return null;
            }
        };
    }
}

