/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.conversion.hive.entities;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.gobblin.data.management.conversion.hive.dataset.ConvertibleHiveDataset;
import org.apache.gobblin.data.management.conversion.hive.entities.HiveProcessingEntity;
import org.apache.gobblin.data.management.conversion.hive.entities.SchemaAwareHivePartition;
import org.apache.gobblin.data.management.conversion.hive.entities.SchemaAwareHiveTable;
import org.apache.hadoop.hive.ql.metadata.Partition;

public class QueryBasedHiveConversionEntity
extends HiveProcessingEntity {
    private final ConvertibleHiveDataset convertibleHiveDataset;
    private final SchemaAwareHiveTable hiveTable;
    private final Optional<SchemaAwareHivePartition> hivePartition;
    private final List<String> queries;

    public QueryBasedHiveConversionEntity(ConvertibleHiveDataset convertibleHiveDataset, SchemaAwareHiveTable hiveTable) {
        this(convertibleHiveDataset, hiveTable, (Optional<SchemaAwareHivePartition>)Optional.absent());
    }

    public QueryBasedHiveConversionEntity(ConvertibleHiveDataset convertibleHiveDataset, SchemaAwareHiveTable hiveTable, Optional<SchemaAwareHivePartition> hivePartition) {
        super(convertibleHiveDataset, hiveTable, (Optional<Partition>)Optional.fromNullable((Object)hivePartition.orNull()));
        this.convertibleHiveDataset = convertibleHiveDataset;
        this.hiveTable = hiveTable;
        this.hivePartition = hivePartition;
        this.queries = Lists.newArrayList();
    }

    public String toString() {
        return "QueryBasedHiveConversionEntity(convertibleHiveDataset=" + this.getConvertibleHiveDataset() + ", hiveTable=" + (Object)((Object)this.getHiveTable()) + ", hivePartition=" + this.getHivePartition() + ", queries=" + this.getQueries() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryBasedHiveConversionEntity)) {
            return false;
        }
        QueryBasedHiveConversionEntity other = (QueryBasedHiveConversionEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ConvertibleHiveDataset this$convertibleHiveDataset = this.getConvertibleHiveDataset();
        ConvertibleHiveDataset other$convertibleHiveDataset = other.getConvertibleHiveDataset();
        if (this$convertibleHiveDataset == null ? other$convertibleHiveDataset != null : !this$convertibleHiveDataset.equals(other$convertibleHiveDataset)) {
            return false;
        }
        SchemaAwareHiveTable this$hiveTable = this.getHiveTable();
        SchemaAwareHiveTable other$hiveTable = other.getHiveTable();
        if (this$hiveTable == null ? other$hiveTable != null : !((Object)((Object)this$hiveTable)).equals((Object)other$hiveTable)) {
            return false;
        }
        Optional<SchemaAwareHivePartition> this$hivePartition = this.getHivePartition();
        Optional<SchemaAwareHivePartition> other$hivePartition = other.getHivePartition();
        if (this$hivePartition == null ? other$hivePartition != null : !this$hivePartition.equals(other$hivePartition)) {
            return false;
        }
        List<String> this$queries = this.getQueries();
        List<String> other$queries = other.getQueries();
        return !(this$queries == null ? other$queries != null : !((Object)this$queries).equals(other$queries));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QueryBasedHiveConversionEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ConvertibleHiveDataset $convertibleHiveDataset = this.getConvertibleHiveDataset();
        result = result * 59 + ($convertibleHiveDataset == null ? 43 : $convertibleHiveDataset.hashCode());
        SchemaAwareHiveTable $hiveTable = this.getHiveTable();
        result = result * 59 + ($hiveTable == null ? 43 : ((Object)((Object)$hiveTable)).hashCode());
        Optional<SchemaAwareHivePartition> $hivePartition = this.getHivePartition();
        result = result * 59 + ($hivePartition == null ? 43 : $hivePartition.hashCode());
        List<String> $queries = this.getQueries();
        result = result * 59 + ($queries == null ? 43 : ((Object)$queries).hashCode());
        return result;
    }

    public ConvertibleHiveDataset getConvertibleHiveDataset() {
        return this.convertibleHiveDataset;
    }

    public SchemaAwareHiveTable getHiveTable() {
        return this.hiveTable;
    }

    public Optional<SchemaAwareHivePartition> getHivePartition() {
        return this.hivePartition;
    }

    public List<String> getQueries() {
        return this.queries;
    }
}

