/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.version.finder;

import java.util.Properties;
import org.apache.gobblin.data.management.version.FileSystemDatasetVersion;
import org.apache.gobblin.data.management.version.StringDatasetVersion;
import org.apache.gobblin.data.management.version.TimestampedDatasetVersion;
import org.apache.gobblin.data.management.version.finder.DatasetVersionFinder;
import org.apache.gobblin.data.management.version.finder.WatermarkDatasetVersionFinder;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnixTimestampVersionFinder
extends DatasetVersionFinder<TimestampedDatasetVersion> {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnixTimestampVersionFinder.class);
    private final WatermarkDatasetVersionFinder embeddedFinder;

    public UnixTimestampVersionFinder(FileSystem fs, Properties props) {
        super(fs, props);
        this.embeddedFinder = new WatermarkDatasetVersionFinder(fs, props);
    }

    @Override
    public Class<? extends FileSystemDatasetVersion> versionClass() {
        return TimestampedDatasetVersion.class;
    }

    @Override
    public Path globVersionPattern() {
        return this.embeddedFinder.globVersionPattern();
    }

    @Override
    public TimestampedDatasetVersion getDatasetVersion(Path pathRelativeToDatasetRoot, Path fullPath) {
        StringDatasetVersion version = this.embeddedFinder.getDatasetVersion(pathRelativeToDatasetRoot, fullPath);
        if (version == null) {
            return null;
        }
        try {
            Long timestamp = Long.parseLong(version.getVersion());
            return new TimestampedDatasetVersion(new DateTime((Object)timestamp), fullPath);
        }
        catch (NumberFormatException nfe) {
            LOGGER.warn(String.format("Could not parse long from dataset version %s. Skipping.", pathRelativeToDatasetRoot));
            return null;
        }
        catch (IllegalArgumentException iae) {
            LOGGER.warn(String.format("Could not parse unix datetime for dataset version %s. Skipping.", pathRelativeToDatasetRoot));
            return null;
        }
    }
}

