/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.policy;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import java.util.Properties;
import org.apache.gobblin.annotation.Alias;
import org.apache.gobblin.data.management.policy.SelectBetweenTimeBasedPolicy;
import org.apache.gobblin.util.ConfigUtils;
import org.joda.time.Period;

@Alias(value="SelectAfterTimeBasedPolicy")
public class SelectAfterTimeBasedPolicy
extends SelectBetweenTimeBasedPolicy {
    public static final String TIME_BASED_SELECTION_LOOK_BACK_TIME_KEY = "selection.timeBased.lookbackTime";

    public SelectAfterTimeBasedPolicy(Config conf) {
        super((Optional<Period>)Optional.absent(), (Optional<Period>)Optional.of((Object)SelectAfterTimeBasedPolicy.getMaxLookbackTime(conf)));
    }

    public SelectAfterTimeBasedPolicy(Properties props) {
        this(ConfigUtils.propertiesToConfig((Properties)props));
    }

    private static Period getMaxLookbackTime(Config conf) {
        Preconditions.checkArgument((boolean)conf.hasPath(TIME_BASED_SELECTION_LOOK_BACK_TIME_KEY), (Object)String.format("Required property %s is not specified", TIME_BASED_SELECTION_LOOK_BACK_TIME_KEY));
        return SelectBetweenTimeBasedPolicy.getLookBackPeriod(conf.getString(TIME_BASED_SELECTION_LOOK_BACK_TIME_KEY));
    }

    @Override
    public String toString() {
        return "SelectAfterTimeBasedPolicy(super=" + super.toString() + ")";
    }
}

