/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy.writer;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.data.management.copy.CopyableFile;
import org.apache.gobblin.data.management.copy.writer.FileAwareInputStreamDataWriter;
import org.apache.gobblin.util.FileUtils;
import org.apache.gobblin.util.io.StreamCopier;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TarArchiveInputStreamDataWriter
extends FileAwareInputStreamDataWriter {
    private static final Logger log = LoggerFactory.getLogger(TarArchiveInputStreamDataWriter.class);

    public TarArchiveInputStreamDataWriter(State state, int numBranches, int branchId) throws IOException {
        super(state, numBranches, branchId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeImpl(InputStream inputStream, Path writeAt, CopyableFile copyableFile) throws IOException {
        this.closer.register((Closeable)inputStream);
        TarArchiveInputStream tarIn = new TarArchiveInputStream(inputStream);
        ReadableByteChannel inputChannel = Channels.newChannel((InputStream)tarIn);
        TarArchiveEntry tarEntry = tarIn.getNextTarEntry();
        String tarEntryRootName = StringUtils.remove((String)tarEntry.getName(), (String)"/");
        log.info("Unarchiving at " + writeAt);
        try {
            while ((tarEntry = tarIn.getNextTarEntry()) != null) {
                String newTarEntryPath = tarEntry.getName().replace(tarEntryRootName, writeAt.getName());
                Path tarEntryStagingPath = new Path(writeAt.getParent(), newTarEntryPath);
                if (!FileUtils.isSubPath((Path)writeAt.getParent(), (Path)tarEntryStagingPath)) {
                    throw new IOException(String.format("Extracted file: %s is trying to write outside of output directory: %s", tarEntryStagingPath, writeAt.getParent()));
                }
                if (tarEntry.isDirectory() && !this.fs.exists(tarEntryStagingPath)) {
                    this.fs.mkdirs(tarEntryStagingPath);
                    continue;
                }
                if (tarEntry.isDirectory()) continue;
                FSDataOutputStream out = this.fs.create(tarEntryStagingPath, true);
                WritableByteChannel outputChannel = Channels.newChannel((OutputStream)out);
                try {
                    StreamCopier copier = new StreamCopier(inputChannel, outputChannel);
                    if (this.isInstrumentationEnabled()) {
                        copier.withCopySpeedMeter(this.copySpeedMeter);
                    }
                    this.bytesWritten.addAndGet(copier.copy());
                    if (this.isInstrumentationEnabled()) {
                        log.info("File {}: copied {} bytes, average rate: {} B/s", new Object[]{copyableFile.getOrigin().getPath(), this.copySpeedMeter.getCount(), this.copySpeedMeter.getMeanRate()});
                        continue;
                    }
                    log.info("File {} copied.", (Object)copyableFile.getOrigin().getPath());
                }
                finally {
                    out.close();
                    outputChannel.close();
                }
            }
        }
        finally {
            tarIn.close();
            inputChannel.close();
            inputStream.close();
        }
    }
}

