/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy.converter;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.gobblin.codec.StreamCodec;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.Converter;
import org.apache.gobblin.crypto.EncryptionConfigParser;
import org.apache.gobblin.crypto.EncryptionFactory;
import org.apache.gobblin.data.management.copy.FileAwareInputStream;
import org.apache.gobblin.data.management.copy.converter.DistcpConverter;
import org.apache.gobblin.password.PasswordManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecryptConverter
extends DistcpConverter {
    private static final Logger log = LoggerFactory.getLogger(DecryptConverter.class);
    private static final String DEFAULT_ALGORITHM = "gpg";
    private static final String DECRYPTION_PASSPHRASE_KEY = "converter.decrypt.passphrase";
    private StreamCodec decryptor;

    @Override
    public Converter<String, String, FileAwareInputStream, FileAwareInputStream> init(WorkUnitState workUnit) {
        Map config = EncryptionConfigParser.getConfigForBranch((EncryptionConfigParser.EntityType)EncryptionConfigParser.EntityType.CONVERTER_ENCRYPT, (WorkUnitState)workUnit);
        if (config == null) {
            log.info("Assuming GPG decryption since no other config parameters are set");
            config = Maps.newHashMap();
            config.put("algorithm", DEFAULT_ALGORITHM);
            Preconditions.checkArgument((boolean)workUnit.contains(DECRYPTION_PASSPHRASE_KEY), (Object)"Passphrase is required while using DecryptConverter. Please specify converter.decrypt.passphrase");
            String passphrase = PasswordManager.getInstance((State)workUnit).readPassword(workUnit.getProp(DECRYPTION_PASSPHRASE_KEY));
            config.put("keystore_password", passphrase);
        }
        this.decryptor = EncryptionFactory.buildStreamCryptoProvider((Map)config);
        return super.init(workUnit);
    }

    @Override
    public Function<InputStream, InputStream> inputStreamTransformation() {
        return new Function<InputStream, InputStream>(){

            @Nullable
            public InputStream apply(InputStream input) {
                try {
                    return DecryptConverter.this.decryptor.decodeInputStream(input);
                }
                catch (IOException exception) {
                    throw new RuntimeException(exception);
                }
            }
        };
    }

    @Override
    public List<String> extensionsToRemove() {
        return Lists.newArrayList((Object[])new String[]{"." + this.decryptor.getTag()});
    }
}

