/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.beans.ConstructorProperties;
import java.util.regex.Pattern;

public class PreserveAttributes {
    public static final Pattern ATTRIBUTES_REGEXP = PreserveAttributes.getAllowedRegexp();
    private int options;

    public boolean preserve(Option option) {
        return 0 < (this.options & 1 << option.ordinal());
    }

    public String toMnemonicString() {
        int value = this.options;
        StringBuilder mnemonicString = new StringBuilder();
        for (Option option : Option.values()) {
            if (value % 2 != 0) {
                mnemonicString.append(option.token);
            }
            value >>= 1;
        }
        return mnemonicString.toString();
    }

    public static PreserveAttributes fromMnemonicString(String s) {
        if (Strings.isNullOrEmpty((String)s)) {
            return new PreserveAttributes(0);
        }
        s = s.toLowerCase();
        Preconditions.checkArgument((boolean)ATTRIBUTES_REGEXP.matcher(s).matches(), (String)"Invalid %s string %s, must be of the form %s.", (Object[])new Object[]{PreserveAttributes.class.getSimpleName(), s, ATTRIBUTES_REGEXP.pattern()});
        int value = 0;
        for (Option option : Option.values()) {
            if (s.indexOf(option.token) < 0) continue;
            value |= 1 << option.ordinal();
        }
        return new PreserveAttributes(value);
    }

    private static Pattern getAllowedRegexp() {
        StringBuilder builder = new StringBuilder("[");
        for (Option option : Option.values()) {
            builder.append(option.token);
        }
        builder.append("]*");
        return Pattern.compile(builder.toString());
    }

    @ConstructorProperties(value={"options"})
    public PreserveAttributes(int options) {
        this.options = options;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PreserveAttributes)) {
            return false;
        }
        PreserveAttributes other = (PreserveAttributes)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.options == other.options;
    }

    protected boolean canEqual(Object other) {
        return other instanceof PreserveAttributes;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.options;
        return result;
    }

    public static enum Option {
        REPLICATION('r'),
        BLOCK_SIZE('b'),
        OWNER('u'),
        GROUP('g'),
        PERMISSION('p');

        private final char token;

        private Option(char token) {
            this.token = token;
        }
    }
}

