/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.conversion.hive.converter;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import org.apache.avro.Schema;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.Converter;
import org.apache.gobblin.converter.DataConversionException;
import org.apache.gobblin.converter.SingleRecordIterable;
import org.apache.gobblin.data.management.conversion.hive.dataset.ConvertibleHiveDataset;
import org.apache.gobblin.data.management.conversion.hive.entities.HiveProcessingEntity;
import org.apache.gobblin.data.management.conversion.hive.entities.QueryBasedHiveConversionEntity;
import org.apache.gobblin.data.management.conversion.hive.entities.QueryBasedHivePublishEntity;
import org.apache.gobblin.data.management.conversion.hive.events.EventWorkunitUtils;
import org.apache.gobblin.data.management.conversion.hive.query.HiveAvroORCQueryGenerator;
import org.apache.gobblin.data.management.conversion.hive.task.HiveConverterUtils;
import org.apache.gobblin.data.management.copy.hive.WhitelistBlacklist;
import org.apache.gobblin.hive.HiveMetastoreClientPool;
import org.apache.gobblin.util.AutoReturnableObject;
import org.apache.gobblin.util.HadoopUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAvroToOrcConverter
extends Converter<Schema, Schema, QueryBasedHiveConversionEntity, QueryBasedHiveConversionEntity> {
    private static final Logger log = LoggerFactory.getLogger(AbstractAvroToOrcConverter.class);
    private static final String PUBLISHED_TABLE_SUBDIRECTORY = "final";
    private static final String ORC_FORMAT = "orc";
    private static final String GOBBLIN_DATASET_URN_KEY = "gobblin.datasetUrn";
    private static final String GOBBLIN_PARTITION_NAME_KEY = "gobblin.partitionName";
    private static final String GOBBLIN_WORKUNIT_CREATE_TIME_KEY = "gobblin.workunitCreateTime";
    private static final String HIVE_PARTITIONS_INFO = "/";
    private static final String HIVE_PARTITIONS_TYPE = ":";
    protected final FileSystem fs;
    public static final String REPLACED_PARTITIONS_HIVE_METASTORE_KEY = "gobblin.replaced.partitions";
    protected ConvertibleHiveDataset hiveDataset;
    public static final String HIVE_DATASET_DESTINATION_SKIP_SETGROUP = "hive.dataset.destination.skip.setGroup";
    public static final boolean DEFAULT_HIVE_DATASET_DESTINATION_SKIP_SETGROUP = false;
    public static final String HIVE_DATASET_DESTINATION_GROUP_NAME = "hive.dataset.destination.groupName";
    public static final String HIVE_DATASET_STAGING_GROUP_NAME = "hive.dataset.staging.groupName";
    public static final String HIVE_CONVERSION_SETSERDETOAVROEXPLICITELY = "hive.conversion.setSerdeToAvroExplicitly";
    public static final boolean DEFAULT_HIVE_CONVERSION_SETSERDETOAVROEXPLICITELY = true;
    public static final String HIVE_CONVERSION_VIEW_REGISTRATION_WHITELIST = "hive.conversion.view.registration.whitelist";
    public static final String HIVE_CONVERSION_VIEW_REGISTRATION_BLACKLIST = "hive.conversion.view.registration.blacklist";

    public abstract Schema convertSchema(Schema var1, WorkUnitState var2);

    protected abstract boolean hasConversionConfig();

    protected abstract ConvertibleHiveDataset.ConversionConfig getConversionConfig();

    public AbstractAvroToOrcConverter() {
        try {
            this.fs = FileSystem.get((Configuration)HadoopUtils.newConfiguration());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Iterable<QueryBasedHiveConversionEntity> convertRecord(Schema outputAvroSchema, QueryBasedHiveConversionEntity conversionEntity, WorkUnitState workUnit) throws DataConversionException {
        Preconditions.checkNotNull((Object)outputAvroSchema, (Object)"Avro schema must not be null");
        Preconditions.checkNotNull((Object)conversionEntity, (Object)"Conversion entity must not be null");
        Preconditions.checkNotNull((Object)workUnit, (Object)"Workunit state must not be null");
        Preconditions.checkNotNull((Object)conversionEntity.getTable(), (Object)"Hive table within conversion entity must not be null");
        EventWorkunitUtils.setBeginDDLBuildTimeMetadata((State)workUnit, System.currentTimeMillis());
        this.hiveDataset = conversionEntity.getConvertibleHiveDataset();
        if (!this.hasConversionConfig()) {
            return new SingleRecordIterable((Object)conversionEntity);
        }
        String avroTableName = conversionEntity.getTable().getTableName();
        String orcTableName = this.getConversionConfig().getDestinationTableName();
        String orcStagingTableName = this.getOrcStagingTableName(this.getConversionConfig().getDestinationStagingTableName());
        String orcTableDatabase = this.getConversionConfig().getDestinationDbName();
        String orcDataLocation = this.getOrcDataLocation();
        String orcStagingDataLocation = this.getOrcStagingDataLocation(orcStagingTableName);
        boolean isEvolutionEnabled = this.getConversionConfig().isEvolutionEnabled();
        Pair<Optional<org.apache.hadoop.hive.metastore.api.Table>, Optional<List<Partition>>> destinationMeta = HiveConverterUtils.getDestinationTableMeta(orcTableDatabase, orcTableName, workUnit.getProperties());
        Optional destinationTableMeta = (Optional)destinationMeta.getLeft();
        Optional<WhitelistBlacklist> optionalViewRegistrationWhiteBlacklist = AbstractAvroToOrcConverter.getViewWhiteBackListFromWorkUnit(workUnit);
        Optional<String> wrapperViewName = Optional.absent();
        wrapperViewName = optionalViewRegistrationWhiteBlacklist.isPresent() ? (((WhitelistBlacklist)optionalViewRegistrationWhiteBlacklist.get()).acceptTable(orcTableDatabase, orcTableName) ? this.getConversionConfig().getDestinationViewName() : wrapperViewName) : this.getConversionConfig().getDestinationViewName();
        boolean shouldUpdateView = this.getConversionConfig().isUpdateViewAlwaysEnabled();
        Optional clusterBy = this.getConversionConfig().getClusterBy().isEmpty() ? Optional.absent() : Optional.of(this.getConversionConfig().getClusterBy());
        Optional<Integer> numBuckets = this.getConversionConfig().getNumBuckets();
        Optional<Integer> rowLimit = this.getConversionConfig().getRowLimit();
        Properties tableProperties = this.getConversionConfig().getDestinationTableProperties();
        List<String> sourceDataPathIdentifier = this.getConversionConfig().getSourceDataPathIdentifier();
        HashMap partitionsDDLInfo = Maps.newHashMap();
        HashMap partitionsDMLInfo = Maps.newHashMap();
        HiveConverterUtils.populatePartitionInfo(conversionEntity, partitionsDDLInfo, partitionsDMLInfo);
        try {
            FileStatus sourceDataFileStatus = this.fs.getFileStatus(conversionEntity.getTable().getDataLocation());
            FsPermission sourceDataPermission = sourceDataFileStatus.getPermission();
            if (!this.fs.mkdirs(new Path(this.getConversionConfig().getDestinationDataPath()), sourceDataPermission)) {
                throw new RuntimeException(String.format("Failed to create path %s with permissions %s", new Path(this.getConversionConfig().getDestinationDataPath()), sourceDataPermission));
            }
            this.fs.setPermission(new Path(this.getConversionConfig().getDestinationDataPath()), sourceDataPermission);
            String destinationGroupName = workUnit.contains(HIVE_DATASET_DESTINATION_GROUP_NAME) ? workUnit.getProp(HIVE_DATASET_DESTINATION_GROUP_NAME) : sourceDataFileStatus.getGroup();
            if (!workUnit.getPropAsBoolean(HIVE_DATASET_DESTINATION_SKIP_SETGROUP, false)) {
                this.fs.setOwner(new Path(this.getConversionConfig().getDestinationDataPath()), null, destinationGroupName);
            }
            log.info(String.format("Created %s with permissions %s and group %s", new Path(this.getConversionConfig().getDestinationDataPath()), sourceDataPermission, sourceDataFileStatus.getGroup()));
            if (workUnit.contains(HIVE_DATASET_STAGING_GROUP_NAME)) {
                String stagingGroupName = workUnit.getProp(HIVE_DATASET_STAGING_GROUP_NAME);
                log.info("Setting staging directory group name as " + stagingGroupName);
                this.fs.mkdirs(new Path(this.getOrcStagingDataLocation(orcStagingTableName)));
                this.fs.setOwner(new Path(this.getOrcStagingDataLocation(orcStagingTableName)), null, stagingGroupName);
                this.fs.mkdirs(new Path(this.getOrcDataLocation()));
                this.fs.setOwner(new Path(this.getOrcDataLocation()), null, stagingGroupName);
            }
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
        }
        for (Map.Entry<Object, Object> entry : this.getConversionConfig().getHiveRuntimeProperties().entrySet()) {
            conversionEntity.getQueries().add(String.format("SET %s=%s", entry.getKey(), entry.getValue()));
        }
        conversionEntity.getQueries().add(String.format("SET %s=%s", GOBBLIN_DATASET_URN_KEY, conversionEntity.getTable().getCompleteName()));
        if (conversionEntity.getPartition().isPresent()) {
            conversionEntity.getQueries().add(String.format("SET %s=%s", GOBBLIN_PARTITION_NAME_KEY, ((Partition)conversionEntity.getPartition().get()).getCompleteName()));
        }
        conversionEntity.getQueries().add(String.format("SET %s=%s", GOBBLIN_WORKUNIT_CREATE_TIME_KEY, workUnit.getWorkunit().getProp("event.sla.originTimestamp")));
        LinkedHashMap<String, String> hiveColumns = new LinkedHashMap<String, String>();
        String createStagingTableDDL = HiveAvroORCQueryGenerator.generateCreateTableDDL(outputAvroSchema, orcStagingTableName, orcStagingDataLocation, (Optional<String>)Optional.of((Object)orcTableDatabase), (Optional<Map<String, String>>)Optional.of((Object)partitionsDDLInfo), (Optional<List<String>>)clusterBy, (Optional<Map<String, HiveAvroORCQueryGenerator.COLUMN_SORT_ORDER>>)Optional.absent(), numBuckets, (Optional<String>)Optional.absent(), (Optional<String>)Optional.absent(), (Optional<String>)Optional.absent(), tableProperties, isEvolutionEnabled, (Optional<org.apache.hadoop.hive.metastore.api.Table>)destinationTableMeta, hiveColumns);
        conversionEntity.getQueries().add(createStagingTableDDL);
        log.debug("Create staging table DDL: " + createStagingTableDDL);
        String orcStagingDataPartitionDirName = HiveConverterUtils.getStagingDataPartitionDirName(conversionEntity, sourceDataPathIdentifier);
        String orcStagingDataPartitionLocation = orcStagingDataLocation + HIVE_PARTITIONS_INFO + orcStagingDataPartitionDirName;
        if (partitionsDMLInfo.size() > 0) {
            List<String> createStagingPartitionDDL = HiveAvroORCQueryGenerator.generateCreatePartitionDDL(orcTableDatabase, orcStagingTableName, orcStagingDataPartitionLocation, partitionsDMLInfo);
            conversionEntity.getQueries().addAll(createStagingPartitionDDL);
            log.debug("Create staging partition DDL: " + createStagingPartitionDDL);
        }
        String insertInORCStagingTableDML = HiveAvroORCQueryGenerator.generateTableMappingDML(conversionEntity.getHiveTable().getAvroSchema(), outputAvroSchema, avroTableName, orcStagingTableName, (Optional<String>)Optional.of((Object)conversionEntity.getTable().getDbName()), (Optional<String>)Optional.of((Object)orcTableDatabase), (Optional<Map<String, String>>)Optional.of((Object)partitionsDMLInfo), (Optional<Boolean>)Optional.absent(), (Optional<Boolean>)Optional.absent(), isEvolutionEnabled, (Optional<org.apache.hadoop.hive.metastore.api.Table>)destinationTableMeta, rowLimit);
        conversionEntity.getQueries().add(insertInORCStagingTableDML);
        log.debug("Conversion staging DML: " + insertInORCStagingTableDML);
        QueryBasedHivePublishEntity publishEntity = new QueryBasedHivePublishEntity();
        List<String> publishQueries = publishEntity.getPublishQueries();
        Map<String, String> publishDirectories = publishEntity.getPublishDirectories();
        List<String> cleanupQueries = publishEntity.getCleanupQueries();
        List<String> cleanupDirectories = publishEntity.getCleanupDirectories();
        if (!destinationTableMeta.isPresent()) {
            String createTargetTableDDL = HiveAvroORCQueryGenerator.generateCreateTableDDL(outputAvroSchema, orcTableName, orcDataLocation, (Optional<String>)Optional.of((Object)orcTableDatabase), (Optional<Map<String, String>>)Optional.of((Object)partitionsDDLInfo), (Optional<List<String>>)clusterBy, (Optional<Map<String, HiveAvroORCQueryGenerator.COLUMN_SORT_ORDER>>)Optional.absent(), numBuckets, (Optional<String>)Optional.absent(), (Optional<String>)Optional.absent(), (Optional<String>)Optional.absent(), tableProperties, isEvolutionEnabled, (Optional<org.apache.hadoop.hive.metastore.api.Table>)destinationTableMeta, new HashMap<String, String>());
            publishQueries.add(createTargetTableDDL);
            log.debug("Create final table DDL: " + createTargetTableDDL);
        }
        List<String> evolutionDDLs = HiveAvroORCQueryGenerator.generateEvolutionDDL(orcStagingTableName, orcTableName, (Optional<String>)Optional.of((Object)orcTableDatabase), (Optional<String>)Optional.of((Object)orcTableDatabase), outputAvroSchema, isEvolutionEnabled, hiveColumns, (Optional<org.apache.hadoop.hive.metastore.api.Table>)destinationTableMeta);
        log.debug("Evolve final table DDLs: " + evolutionDDLs);
        EventWorkunitUtils.setEvolutionMetadata((State)workUnit, evolutionDDLs);
        shouldUpdateView |= evolutionDDLs.size() > 0;
        publishQueries.addAll(evolutionDDLs);
        if (partitionsDDLInfo.size() == 0) {
            log.info("Snapshot directory to move: " + orcStagingDataLocation + " to: " + orcDataLocation);
            publishDirectories.put(orcStagingDataLocation, orcDataLocation);
            String dropStagingTableDDL = HiveAvroORCQueryGenerator.generateDropTableDDL(orcTableDatabase, orcStagingTableName);
            log.debug("Drop staging table DDL: " + dropStagingTableDDL);
            cleanupQueries.add(dropStagingTableDDL);
            log.info("Staging table directory to delete: " + orcStagingDataLocation);
            cleanupDirectories.add(orcStagingDataLocation);
        } else {
            List<String> createFinalPartitionDDL;
            String orcFinalDataPartitionLocation = orcDataLocation + HIVE_PARTITIONS_INFO + orcStagingDataPartitionDirName;
            Optional<Path> destPartitionLocation = this.getDestinationPartitionLocation((Optional<org.apache.hadoop.hive.metastore.api.Table>)destinationTableMeta, workUnit, ((Partition)conversionEntity.getPartition().get()).getName());
            orcFinalDataPartitionLocation = HiveConverterUtils.updatePartitionLocation(orcFinalDataPartitionLocation, workUnit, destPartitionLocation);
            log.info("Partition directory to move: " + orcStagingDataPartitionLocation + " to: " + orcFinalDataPartitionLocation);
            publishDirectories.put(orcStagingDataPartitionLocation, orcFinalDataPartitionLocation);
            List<String> dropPartitionsDDL = HiveAvroORCQueryGenerator.generateDropPartitionsDDL(orcTableDatabase, orcTableName, partitionsDMLInfo);
            log.debug("Drop partitions if exist in final table: " + dropPartitionsDDL);
            publishQueries.addAll(dropPartitionsDDL);
            if (workUnit.getPropAsBoolean(HIVE_CONVERSION_SETSERDETOAVROEXPLICITELY, true)) {
                createFinalPartitionDDL = HiveAvroORCQueryGenerator.generateCreatePartitionDDL(orcTableDatabase, orcTableName, orcFinalDataPartitionLocation, partitionsDMLInfo, (Optional<String>)Optional.absent());
                log.debug("Create final partition DDL: " + createFinalPartitionDDL);
                publishQueries.addAll(createFinalPartitionDDL);
                List<String> updatePartitionStorageFormatDDL = HiveAvroORCQueryGenerator.generateAlterTableOrPartitionStorageFormatDDL(orcTableDatabase, orcTableName, (Optional<Map<String, String>>)Optional.of((Object)partitionsDMLInfo), ORC_FORMAT);
                log.debug("Update final partition storage format to ORC (if not already in ORC)");
                publishQueries.addAll(updatePartitionStorageFormatDDL);
            } else {
                createFinalPartitionDDL = HiveAvroORCQueryGenerator.generateCreatePartitionDDL(orcTableDatabase, orcTableName, orcFinalDataPartitionLocation, partitionsDMLInfo, (Optional<String>)Optional.fromNullable((Object)ORC_FORMAT));
                log.debug("Create final partition DDL: " + createFinalPartitionDDL);
                publishQueries.addAll(createFinalPartitionDDL);
            }
            String dropStagingTableDDL = HiveAvroORCQueryGenerator.generateDropTableDDL(orcTableDatabase, orcStagingTableName);
            log.debug("Drop staging table DDL: " + dropStagingTableDDL);
            cleanupQueries.add(dropStagingTableDDL);
            log.info("Staging table directory to delete: " + orcStagingDataLocation);
            cleanupDirectories.add(orcStagingDataLocation);
        }
        publishQueries.addAll(HiveAvroORCQueryGenerator.generateDropPartitionsDDL(orcTableDatabase, orcTableName, AbstractAvroToOrcConverter.getDropPartitionsDDLInfo(conversionEntity)));
        if (wrapperViewName.isPresent()) {
            String viewName = (String)wrapperViewName.get();
            List<String> createOrUpdateViewDDLs = HiveAvroORCQueryGenerator.generateCreateOrUpdateViewDDL(orcTableDatabase, orcTableName, orcTableDatabase, viewName, shouldUpdateView);
            log.debug("Create or update View DDLs: " + createOrUpdateViewDDLs);
            publishQueries.addAll(createOrUpdateViewDDLs);
        }
        HiveAvroORCQueryGenerator.serializePublishCommands((State)workUnit, publishEntity);
        log.debug("Publish partition entity: " + publishEntity);
        log.debug("Conversion Query " + conversionEntity.getQueries());
        EventWorkunitUtils.setEndDDLBuildTimeMetadata((State)workUnit, System.currentTimeMillis());
        return new SingleRecordIterable((Object)conversionEntity);
    }

    @VisibleForTesting
    public static Optional<WhitelistBlacklist> getViewWhiteBackListFromWorkUnit(WorkUnitState workUnit) {
        Optional optionalViewWhiteBlacklist = Optional.absent();
        if (workUnit == null) {
            return optionalViewWhiteBlacklist;
        }
        if (workUnit.contains(HIVE_CONVERSION_VIEW_REGISTRATION_WHITELIST) || workUnit.contains(HIVE_CONVERSION_VIEW_REGISTRATION_BLACKLIST)) {
            String viewWhiteList = workUnit.getProp(HIVE_CONVERSION_VIEW_REGISTRATION_WHITELIST, "");
            String viewBlackList = workUnit.getProp(HIVE_CONVERSION_VIEW_REGISTRATION_BLACKLIST, "");
            try {
                optionalViewWhiteBlacklist = Optional.of((Object)new WhitelistBlacklist(viewWhiteList, viewBlackList));
            }
            catch (IOException e) {
                Throwables.propagate((Throwable)e);
            }
        }
        return optionalViewWhiteBlacklist;
    }

    private String getOrcStagingTableName(String stagingTableNamePrefix) {
        int randomNumber = new Random().nextInt(10);
        String uniqueStagingTableQualifier = String.format("%s%s", System.currentTimeMillis(), randomNumber);
        return stagingTableNamePrefix + "_" + uniqueStagingTableQualifier;
    }

    private String getOrcDataLocation() {
        String orcDataLocation = this.getConversionConfig().getDestinationDataPath();
        return orcDataLocation + HIVE_PARTITIONS_INFO + PUBLISHED_TABLE_SUBDIRECTORY;
    }

    private String getOrcStagingDataLocation(String orcStagingTableName) {
        String orcDataLocation = this.getConversionConfig().getDestinationDataPath();
        return orcDataLocation + HIVE_PARTITIONS_INFO + orcStagingTableName;
    }

    @VisibleForTesting
    public static List<Map<String, String>> getDropPartitionsDDLInfo(HiveProcessingEntity conversionEntity) {
        if (!conversionEntity.getPartition().isPresent()) {
            return Collections.emptyList();
        }
        return AbstractAvroToOrcConverter.getDropPartitionsDDLInfo((Partition)conversionEntity.getPartition().get());
    }

    public static List<Map<String, String>> getDropPartitionsDDLInfo(Partition hivePartition) {
        ArrayList replacedPartitionsDDLInfo = Lists.newArrayList();
        List partitionKeys = hivePartition.getTable().getPartitionKeys();
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)hivePartition.getParameters().get(REPLACED_PARTITIONS_HIVE_METASTORE_KEY)))) {
            for (String partitionsInfoString : Splitter.on((String)"|").omitEmptyStrings().split((CharSequence)hivePartition.getParameters().get(REPLACED_PARTITIONS_HIVE_METASTORE_KEY))) {
                List partitionValues = Splitter.on((String)",").omitEmptyStrings().trimResults().splitToList((CharSequence)partitionsInfoString);
                if (partitionValues.equals(hivePartition.getValues())) continue;
                ImmutableMap.Builder partitionDDLInfoMap = ImmutableMap.builder();
                for (int i = 0; i < partitionKeys.size(); ++i) {
                    partitionDDLInfoMap.put((Object)((FieldSchema)partitionKeys.get(i)).getName(), partitionValues.get(i));
                }
                replacedPartitionsDDLInfo.add(partitionDDLInfoMap.build());
            }
        }
        return replacedPartitionsDDLInfo;
    }

    private Optional<Path> getDestinationPartitionLocation(Optional<org.apache.hadoop.hive.metastore.api.Table> table, WorkUnitState state, String partitionName) throws DataConversionException {
        Optional partitionOptional = Optional.absent();
        if (!table.isPresent()) {
            return Optional.absent();
        }
        try {
            HiveMetastoreClientPool pool = HiveMetastoreClientPool.get((Properties)state.getJobState().getProperties(), (Optional)Optional.fromNullable((Object)state.getJobState().getProp("hive.dataset.hive.metastore.uri")));
            try (AutoReturnableObject client = pool.getClient();){
                partitionOptional = Optional.of((Object)((IMetaStoreClient)client.get()).getPartition(((org.apache.hadoop.hive.metastore.api.Table)table.get()).getDbName(), ((org.apache.hadoop.hive.metastore.api.Table)table.get()).getTableName(), partitionName));
            }
            catch (NoSuchObjectException e) {
                return Optional.absent();
            }
            if (partitionOptional.isPresent()) {
                Table qlTable = new Table((org.apache.hadoop.hive.metastore.api.Table)table.get());
                Partition qlPartition = new Partition(qlTable, (org.apache.hadoop.hive.metastore.api.Partition)partitionOptional.get());
                return Optional.of((Object)qlPartition.getDataLocation());
            }
        }
        catch (IOException | HiveException | TException e) {
            throw new DataConversionException(String.format("Could not fetch destination table %s.%s metadata", ((org.apache.hadoop.hive.metastore.api.Table)table.get()).getDbName(), ((org.apache.hadoop.hive.metastore.api.Table)table.get()).getTableName()), e);
        }
        return Optional.absent();
    }

    protected static enum OrcFormats {
        FLATTENED_ORC("flattenedOrc"),
        NESTED_ORC("nestedOrc");

        private final String configPrefix;

        private OrcFormats(String configPrefix) {
            this.configPrefix = configPrefix;
        }

        public String getConfigPrefix() {
            return this.configPrefix;
        }
    }
}

