/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.version.finder;

import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.gobblin.data.management.version.FileStatusTimestampedDatasetVersion;
import org.apache.gobblin.data.management.version.FileSystemDatasetVersion;
import org.apache.gobblin.data.management.version.TimestampedDatasetVersion;
import org.apache.gobblin.data.management.version.finder.AbstractDatasetVersionFinder;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateTimeDatasetVersionFinder
extends AbstractDatasetVersionFinder<TimestampedDatasetVersion> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DateTimeDatasetVersionFinder.class);
    public static final String DATE_TIME_PATTERN_KEY = "version.datetime.pattern";
    public static final String DATE_TIME_PATTERN_TIMEZONE_KEY = "version.datetime.timezone";
    public static final String OPTIONAL_GLOB_PATTERN_TIMEZONE_KEY = "version.globPattern";
    public static final String DEFAULT_DATE_TIME_PATTERN_TIMEZONE = "America/Los_Angeles";
    private final Path globPattern;
    protected final DateTimeFormatter formatter;
    private final String datePartitionPattern;

    public DateTimeDatasetVersionFinder(FileSystem fs, Config config) {
        super(fs);
        Preconditions.checkArgument((boolean)config.hasPath(DATE_TIME_PATTERN_KEY), (Object)"Missing required property version.datetime.pattern");
        String pattern = config.getString(DATE_TIME_PATTERN_KEY);
        this.globPattern = config.hasPath(OPTIONAL_GLOB_PATTERN_TIMEZONE_KEY) ? new Path(config.getString(OPTIONAL_GLOB_PATTERN_TIMEZONE_KEY)) : new Path(pattern.replaceAll("[^/]+", "*"));
        LOGGER.debug(String.format("Setting timezone for patthern: %s. By default it is %s", pattern, DEFAULT_DATE_TIME_PATTERN_TIMEZONE));
        this.formatter = config.hasPath(DATE_TIME_PATTERN_TIMEZONE_KEY) ? DateTimeFormat.forPattern((String)pattern).withZone(DateTimeZone.forID((String)config.getString(DATE_TIME_PATTERN_TIMEZONE_KEY))) : DateTimeFormat.forPattern((String)pattern).withZone(DateTimeZone.forID((String)DEFAULT_DATE_TIME_PATTERN_TIMEZONE));
        this.datePartitionPattern = pattern;
    }

    public DateTimeDatasetVersionFinder(FileSystem fs, Properties props) {
        this(fs, ConfigFactory.parseProperties((Properties)props));
    }

    @Override
    public Class<? extends FileSystemDatasetVersion> versionClass() {
        return TimestampedDatasetVersion.class;
    }

    @Override
    public Path globVersionPattern() {
        return this.globPattern;
    }

    @Override
    public TimestampedDatasetVersion getDatasetVersion(Path pathRelativeToDatasetRoot, FileStatus versionFileStatus) {
        String dateTimeString = null;
        try {
            dateTimeString = StringUtils.substring((String)pathRelativeToDatasetRoot.toString(), (int)(pathRelativeToDatasetRoot.toString().length() - this.datePartitionPattern.length()));
            return new FileStatusTimestampedDatasetVersion(this.formatter.parseDateTime(dateTimeString), versionFileStatus);
        }
        catch (IllegalArgumentException exception) {
            LOGGER.warn(String.format("Candidate dataset version with pathRelativeToDatasetRoot: %s has inferred dataTimeString:%s. It does not match expected datetime pattern %s. Ignoring.", pathRelativeToDatasetRoot, dateTimeString, this.datePartitionPattern));
            return null;
        }
    }
}

