/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy.hive;

import com.google.common.collect.Maps;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.gobblin.data.management.copy.RecursivePathFinder;
import org.apache.gobblin.data.management.copy.hive.HiveUtils;
import org.apache.gobblin.util.PathUtils;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.mapred.InputFormat;

public class HiveLocationDescriptor {
    public static final String HIVE_DATASET_COPY_ADDITIONAL_PATHS_RECURSIVELY_ENABLED = "hive.dataset.copy.additional.paths.recursively.enabled";
    public static final String HIVE_LOCATION_LISTING_METHOD = "hive.dataset.copy.location.listing.method";
    public static final String SKIP_HIDDEN_PATHS = "hive.dataset.copy.locations.listing.skipHiddenPaths";
    public static final String DEFAULT_SKIP_HIDDEN_PATHS = Boolean.toString(false);
    public static final String DEFAULT_HIVE_LOCATION_LISTING_METHOD = PathFindingMethod.INPUT_FORMAT.name();
    protected final Path location;
    protected final InputFormat<?, ?> inputFormat;
    protected final FileSystem fileSystem;
    protected final Properties properties;

    public Map<Path, FileStatus> getPaths() throws IOException {
        PathFindingMethod pathFindingMethod = PathFindingMethod.valueOf(this.properties.getProperty(HIVE_LOCATION_LISTING_METHOD, DEFAULT_HIVE_LOCATION_LISTING_METHOD).toUpperCase());
        HashMap result = Maps.newHashMap();
        if (pathFindingMethod == PathFindingMethod.INPUT_FORMAT) {
            for (Path path : HiveUtils.getPaths(this.inputFormat, this.location)) {
                result.put(path, this.fileSystem.getFileStatus(path));
            }
            boolean useHiveLocationDescriptorWithAdditionalData = Boolean.valueOf(this.properties.getProperty(HIVE_DATASET_COPY_ADDITIONAL_PATHS_RECURSIVELY_ENABLED, "false"));
            if (useHiveLocationDescriptorWithAdditionalData) {
                if (PathUtils.isGlob((Path)this.location)) {
                    throw new IOException("can not get additional data for glob pattern path " + this.location);
                }
                RecursivePathFinder finder = new RecursivePathFinder(this.fileSystem, this.location, this.properties);
                for (FileStatus status : finder.getPaths(false)) {
                    result.put(status.getPath(), status);
                }
            }
            return result;
        }
        if (pathFindingMethod == PathFindingMethod.RECURSIVE) {
            if (PathUtils.isGlob((Path)this.location)) {
                throw new IOException("Cannot use recursive listing for globbed locations.");
            }
            boolean skipHiddenPaths = Boolean.parseBoolean(this.properties.getProperty(SKIP_HIDDEN_PATHS, DEFAULT_SKIP_HIDDEN_PATHS));
            RecursivePathFinder finder = new RecursivePathFinder(this.fileSystem, this.location, this.properties);
            for (FileStatus status : finder.getPaths(skipHiddenPaths)) {
                result.put(status.getPath(), status);
            }
            return result;
        }
        throw new IOException("Hive location listing method not recognized: " + (Object)((Object)pathFindingMethod));
    }

    public static HiveLocationDescriptor forTable(Table table, FileSystem fs, Properties properties) throws IOException {
        return new HiveLocationDescriptor(table.getDataLocation(), HiveUtils.getInputFormat(table.getTTable().getSd()), fs, properties);
    }

    public static HiveLocationDescriptor forPartition(Partition partition, FileSystem fs, Properties properties) throws IOException {
        return new HiveLocationDescriptor(partition.getDataLocation(), HiveUtils.getInputFormat(partition.getTPartition().getSd()), fs, properties);
    }

    @ConstructorProperties(value={"location", "inputFormat", "fileSystem", "properties"})
    public HiveLocationDescriptor(Path location, InputFormat<?, ?> inputFormat, FileSystem fileSystem, Properties properties) {
        this.location = location;
        this.inputFormat = inputFormat;
        this.fileSystem = fileSystem;
        this.properties = properties;
    }

    public Path getLocation() {
        return this.location;
    }

    public InputFormat<?, ?> getInputFormat() {
        return this.inputFormat;
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HiveLocationDescriptor)) {
            return false;
        }
        HiveLocationDescriptor other = (HiveLocationDescriptor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Path this$location = this.getLocation();
        Path other$location = other.getLocation();
        if (this$location == null ? other$location != null : !this$location.equals(other$location)) {
            return false;
        }
        InputFormat<?, ?> this$inputFormat = this.getInputFormat();
        InputFormat<?, ?> other$inputFormat = other.getInputFormat();
        if (this$inputFormat == null ? other$inputFormat != null : !this$inputFormat.equals(other$inputFormat)) {
            return false;
        }
        FileSystem this$fileSystem = this.getFileSystem();
        FileSystem other$fileSystem = other.getFileSystem();
        if (this$fileSystem == null ? other$fileSystem != null : !this$fileSystem.equals(other$fileSystem)) {
            return false;
        }
        Properties this$properties = this.getProperties();
        Properties other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HiveLocationDescriptor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Path $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : $location.hashCode());
        InputFormat<?, ?> $inputFormat = this.getInputFormat();
        result = result * 59 + ($inputFormat == null ? 43 : $inputFormat.hashCode());
        FileSystem $fileSystem = this.getFileSystem();
        result = result * 59 + ($fileSystem == null ? 43 : $fileSystem.hashCode());
        Properties $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "HiveLocationDescriptor(location=" + this.getLocation() + ", inputFormat=" + this.getInputFormat() + ", fileSystem=" + this.getFileSystem() + ", properties=" + this.getProperties() + ")";
    }

    public static enum PathFindingMethod {
        INPUT_FORMAT,
        RECURSIVE;

    }
}

