/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.conversion.hive.provider;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.concurrent.Callable;
import org.apache.gobblin.data.management.conversion.hive.provider.HiveUnitUpdateProvider;
import org.apache.gobblin.data.management.conversion.hive.provider.UpdateNotFoundException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;

public class HdfsBasedUpdateProvider
implements HiveUnitUpdateProvider {
    private final FileSystem fs;
    private static final Cache<Path, Long> PATH_TO_MOD_TIME_CACHE = CacheBuilder.newBuilder().maximumSize(2000L).build();

    @Override
    public long getUpdateTime(Partition partition) throws UpdateNotFoundException {
        try {
            return this.getUpdateTime(partition.getDataLocation());
        }
        catch (IOException e) {
            throw new UpdateNotFoundException(String.format("Failed to get update time for %s", partition.getCompleteName()), e);
        }
    }

    @Override
    public long getUpdateTime(Table table) throws UpdateNotFoundException {
        try {
            return this.getUpdateTime(table.getDataLocation());
        }
        catch (IOException e) {
            throw new UpdateNotFoundException(String.format("Failed to get update time for %s.", table.getCompleteName()), e);
        }
    }

    private long getUpdateTime(final Path path) throws IOException, UpdateNotFoundException {
        try {
            return (Long)PATH_TO_MOD_TIME_CACHE.get((Object)path, (Callable)new Callable<Long>(){

                @Override
                public Long call() throws Exception {
                    if (HdfsBasedUpdateProvider.this.fs.exists(path)) {
                        return HdfsBasedUpdateProvider.this.fs.getFileStatus(path).getModificationTime();
                    }
                    throw new UpdateNotFoundException(String.format("Data file does not exist at path %s", path));
                }
            });
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @ConstructorProperties(value={"fs"})
    public HdfsBasedUpdateProvider(FileSystem fs) {
        this.fs = fs;
    }
}

