/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.conversion.hive.avro;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.hash.Hashing;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.commons.io.IOUtils;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.data.management.conversion.hive.avro.SchemaNotFoundException;
import org.apache.gobblin.data.management.conversion.hive.query.HiveAvroORCQueryGenerator;
import org.apache.gobblin.util.AvroUtils;
import org.apache.gobblin.util.HadoopUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroSchemaManager {
    private static final Logger log = LoggerFactory.getLogger(AvroSchemaManager.class);
    private static final String HIVE_SCHEMA_TEMP_DIR_PATH_KEY = "hive.schema.dir";
    private static final String DEFAULT_HIVE_SCHEMA_TEMP_DIR_PATH_KEY = "/tmp/gobblin_schemas";
    private final FileSystem fs;
    private final Map<String, Path> schemaPaths;
    private final Path schemaDir;

    public AvroSchemaManager(FileSystem fs, State state) {
        this.fs = fs;
        this.schemaPaths = Maps.newHashMap();
        this.schemaDir = new Path(state.getProp(HIVE_SCHEMA_TEMP_DIR_PATH_KEY, DEFAULT_HIVE_SCHEMA_TEMP_DIR_PATH_KEY), state.getProp("job.id"));
    }

    public Path getSchemaUrl(Table table) throws IOException {
        return this.getSchemaUrl(table.getTTable().getSd());
    }

    public Path getSchemaUrl(Partition partition) throws IOException {
        return this.getSchemaUrl(partition.getTPartition().getSd());
    }

    public void cleanupTempSchemas() throws IOException {
        HadoopUtils.deleteIfExists((FileSystem)this.fs, (Path)this.schemaDir, (boolean)true);
    }

    public static Schema getSchemaFromUrl(Path schemaUrl, FileSystem fs) throws IOException {
        return AvroUtils.parseSchemaFromFile((Path)schemaUrl, (FileSystem)fs);
    }

    private Path getSchemaUrl(StorageDescriptor sd) throws IOException {
        String schemaString = "";
        try {
            if (sd.getSerdeInfo().getParameters().containsKey("avro.schema.url")) {
                String schemaUrl = (String)sd.getSerdeInfo().getParameters().get("avro.schema.url");
                if (schemaUrl.startsWith("http")) {
                    schemaString = IOUtils.toString((URI)new URI(schemaUrl), (Charset)StandardCharsets.UTF_8);
                    log.debug("Schema string is: " + schemaString);
                    Schema schema = HiveAvroORCQueryGenerator.readSchemaFromString(schemaString);
                    return this.getOrGenerateSchemaFile(schema);
                }
                return new Path((String)sd.getSerdeInfo().getParameters().get("avro.schema.url"));
            }
            if (sd.getSerdeInfo().getParameters().containsKey("avro.schema.literal")) {
                schemaString = (String)sd.getSerdeInfo().getParameters().get("avro.schema.literal");
                log.debug("Schema string is: " + schemaString);
                Schema schema = HiveAvroORCQueryGenerator.readSchemaFromString(schemaString);
                return this.getOrGenerateSchemaFile(schema);
            }
        }
        catch (URISyntaxException e) {
            log.error(String.format("Failed to parse schema from schema string. Falling back to HDFS schema: %s", schemaString), (Throwable)e);
        }
        Schema schema = AvroUtils.getDirectorySchema((Path)new Path(sd.getLocation()), (FileSystem)this.fs, (boolean)true);
        if (schema == null) {
            throw new SchemaNotFoundException("Failed to get avro schema");
        }
        return this.getOrGenerateSchemaFile(schema);
    }

    private Path getOrGenerateSchemaFile(Schema schema) throws IOException {
        Preconditions.checkNotNull((Object)schema, (Object)"Avro Schema should not be null");
        String hashedSchema = Hashing.sha256().hashString((CharSequence)schema.toString(), StandardCharsets.UTF_8).toString();
        if (!this.schemaPaths.containsKey(hashedSchema)) {
            Path schemaFilePath = new Path(this.schemaDir, String.valueOf(System.currentTimeMillis() + ".avsc"));
            AvroUtils.writeSchemaToFile((Schema)schema, (Path)schemaFilePath, (FileSystem)this.fs, (boolean)true);
            this.schemaPaths.put(hashedSchema, schemaFilePath);
        }
        return this.schemaPaths.get(hashedSchema);
    }
}

