/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction.verify;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.gobblin.compaction.conditions.RecompactionConditionBasedOnRatio;
import org.apache.gobblin.compaction.parser.CompactionPathParser;
import org.apache.gobblin.compaction.verify.CompactionVerifier;
import org.apache.gobblin.compaction.verify.InputRecordCountHelper;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.dataset.FileSystemDataset;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionThresholdVerifier
implements CompactionVerifier<FileSystemDataset> {
    private static final Logger log = LoggerFactory.getLogger(CompactionThresholdVerifier.class);
    private final State state;

    public CompactionThresholdVerifier(State state) {
        this.state = state;
    }

    @Override
    public CompactionVerifier.Result verify(FileSystemDataset dataset) {
        Map<String, Double> thresholdMap = RecompactionConditionBasedOnRatio.getDatasetRegexAndRecompactThreshold(this.state.getProp("compaction.latedata.threshold.for.recompact.per.topic", ""));
        CompactionPathParser.CompactionParserResult result = new CompactionPathParser(this.state).parse(dataset);
        double threshold = RecompactionConditionBasedOnRatio.getRatioThresholdByDatasetName(result.getDatasetName(), thresholdMap);
        log.debug("Threshold is {} for dataset {}", (Object)threshold, (Object)result.getDatasetName());
        InputRecordCountHelper helper = new InputRecordCountHelper(this.state);
        try {
            double newRecords = 0.0;
            if (!dataset.isVirtual()) {
                newRecords = helper.calculateRecordCount(Lists.newArrayList((Object[])new Path[]{new Path(dataset.datasetURN())}));
            }
            double oldRecords = helper.readRecordCount(new Path(result.getDstAbsoluteDir()));
            State datasetState = helper.loadState(new Path(result.getDstAbsoluteDir()));
            if (oldRecords == 0.0) {
                return new CompactionVerifier.Result(true, "");
            }
            if (this.state.getPropAsBoolean("GobblinMetadataChangeEvent.enabled", false) && !datasetState.getPropAsBoolean("GMCE.emitted", true)) {
                return new CompactionVerifier.Result(true, "GMCE has not sent, need re-compact");
            }
            if (newRecords < oldRecords) {
                return new CompactionVerifier.Result(false, "Illegal state: Current records count should old be smaller.");
            }
            if ((newRecords - oldRecords) / oldRecords > threshold) {
                log.debug("Dataset {} records exceeded the threshold {}", (Object)dataset.datasetURN(), (Object)threshold);
                return new CompactionVerifier.Result(true, "");
            }
            return new CompactionVerifier.Result(false, String.format("%s is failed for dataset %s. Prev=%f, Cur=%f, not reaching to threshold %f", this.getName(), result.getDatasetName(), oldRecords, newRecords, threshold));
        }
        catch (IOException e) {
            return new CompactionVerifier.Result(false, ExceptionUtils.getFullStackTrace((Throwable)e));
        }
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public boolean isRetriable() {
        return false;
    }
}

