/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction.suite;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.gobblin.compaction.action.CompactionCompleteAction;
import org.apache.gobblin.compaction.action.CompactionCompleteFileOperationAction;
import org.apache.gobblin.compaction.action.CompactionHiveRegistrationAction;
import org.apache.gobblin.compaction.action.CompactionMarkDirectoryAction;
import org.apache.gobblin.compaction.action.CompactionWatermarkAction;
import org.apache.gobblin.compaction.suite.CompactionSuiteBase;
import org.apache.gobblin.compaction.verify.CompactionThresholdVerifier;
import org.apache.gobblin.compaction.verify.CompactionTimeRangeVerifier;
import org.apache.gobblin.compaction.verify.CompactionVerifier;
import org.apache.gobblin.compaction.verify.CompactionWatermarkChecker;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.dataset.FileSystemDataset;

public class CompactionWithWatermarkSuite
extends CompactionSuiteBase {
    public CompactionWithWatermarkSuite(State state) {
        super(state);
    }

    @Override
    public List<CompactionVerifier<FileSystemDataset>> getDatasetsFinderVerifiers() {
        LinkedList<CompactionVerifier<FileSystemDataset>> list = new LinkedList<CompactionVerifier<FileSystemDataset>>();
        list.add(new CompactionTimeRangeVerifier(this.state));
        list.add(new CompactionThresholdVerifier(this.state));
        return list;
    }

    @Override
    public List<CompactionVerifier<FileSystemDataset>> getMapReduceVerifiers() {
        LinkedList<CompactionVerifier<FileSystemDataset>> list = new LinkedList<CompactionVerifier<FileSystemDataset>>();
        list.add(new CompactionWatermarkChecker(this.state));
        return list;
    }

    @Override
    public List<CompactionCompleteAction<FileSystemDataset>> getCompactionCompleteActions() {
        ArrayList<CompactionCompleteAction<FileSystemDataset>> array = new ArrayList<CompactionCompleteAction<FileSystemDataset>>();
        array.add(new CompactionCompleteFileOperationAction(this.state, this.getConfigurator()));
        array.add(new CompactionHiveRegistrationAction(this.state));
        array.add(new CompactionWatermarkAction(this.state));
        array.add(new CompactionMarkDirectoryAction(this.state, this.getConfigurator()));
        return array;
    }
}

