/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction.mapreduce.orc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.gobblin.compaction.mapreduce.RecordKeyDedupReducerBase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.orc.mapred.OrcKey;
import org.apache.orc.mapred.OrcStruct;
import org.apache.orc.mapred.OrcValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrcKeyDedupReducer
extends RecordKeyDedupReducerBase<OrcKey, OrcValue, NullWritable, OrcValue> {
    private static final Logger log = LoggerFactory.getLogger(OrcKeyDedupReducer.class);
    @VisibleForTesting
    public static final String ORC_DELTA_SCHEMA_PROVIDER = "org.apache.gobblin.compaction." + OrcKeyDedupReducer.class.getSimpleName() + ".deltaFieldsProvider";
    public static final String USING_WHOLE_RECORD_FOR_COMPARE = "usingWholeRecordForCompareInReducer";
    private int recordCounter = 0;

    @Override
    protected void setOutValue(OrcValue valueToRetain) {
        ((OrcValue)this.outValue).value = valueToRetain.value;
    }

    @Override
    protected void setOutKey(OrcValue valueToRetain) {
    }

    @Override
    protected void reduce(OrcKey key, Iterable<OrcValue> values, Reducer.Context context) throws IOException, InterruptedException {
        HashMap<Integer, Integer> valuesToRetain = new HashMap<Integer, Integer>();
        int valueHash = 0;
        if (this.recordCounter == 0) {
            log.info("Starting to reduce values for the first key {}", (Object)key);
        }
        for (OrcValue orcValue : values) {
            if (this.recordCounter == 1) {
                log.info("Reduced first value");
            }
            ++this.recordCounter;
            if (this.recordCounter % 1000 == 0) {
                log.info("Reduced {} values so far", (Object)this.recordCounter);
            }
            if (valuesToRetain.containsKey(valueHash = ((OrcStruct)orcValue.value).hashCode())) {
                valuesToRetain.put(valueHash, (Integer)valuesToRetain.get(valueHash) + 1);
                continue;
            }
            valuesToRetain.put(valueHash, 1);
            this.writeRetainedValue(orcValue, context);
        }
        for (Map.Entry entry : valuesToRetain.entrySet()) {
            this.updateCounters((Integer)entry.getValue(), context);
        }
    }

    @Override
    protected void initDeltaComparator(Configuration conf) {
        this.deltaComparatorOptional = Optional.absent();
    }

    @Override
    protected void initReusableObject() {
        this.outKey = NullWritable.get();
        this.outValue = new OrcValue();
    }
}

