/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction.event;

import com.google.common.base.Optional;
import java.io.IOException;
import org.apache.gobblin.compaction.dataset.Dataset;
import org.apache.gobblin.compaction.event.DedupeStatus;
import org.apache.gobblin.compaction.mapreduce.RecordKeyDedupReducerBase;
import org.apache.gobblin.compaction.mapreduce.RecordKeyMapperBase;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.metrics.event.sla.SlaEventSubmitter;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionSlaEventHelper {
    private static final Logger LOG = LoggerFactory.getLogger(CompactionSlaEventHelper.class);
    public static final String RECOMPATED_METADATA_NAME = "recompacted";
    public static final String DATASET_URN = "datasetUrn";
    public static final String DATASET_OUTPUT_PATH = "datasetOutputPath";
    public static final String LATE_RECORD_COUNT = "lateRecordCount";
    public static final String REGULAR_RECORD_COUNT = "regularRecordCount";
    public static final String NEED_RECOMPACT = "needRecompact";
    public static final String PREV_RECORD_COUNT_TOTAL = "prevRecordCountTotal";
    public static final String LAST_RUN_START_TIME = "lastRunStartTime";
    public static final String EXEC_COUNT_TOTAL = "executionCountTotal";
    public static final String MR_JOB_ID = "mrJobId";
    public static final String RECORD_COUNT_TOTAL = "recordCountTotal";
    public static final String DUPLICATE_COUNT_TOTAL = "DuplicateRecordCount";
    public static final String HIVE_REGISTRATION_PATHS = "hiveRegistrationPaths";
    public static final String RENAME_DIR_PATHS = "renameDirPaths";
    public static final String COMPACTION_COMPLETED_EVENT_NAME = "CompactionCompleted";
    public static final String COMPACTION_FAILED_EVENT_NAME = "CompactionFailed";
    public static final String COMPLETION_VERIFICATION_FAILED_EVENT_NAME = "CompletenessCannotBeVerified";
    public static final String COMPLETION_VERIFICATION_SUCCESS_EVENT_NAME = "CompletenessVerified";
    public static final String COMPACTION_RECORD_COUNT_EVENT = "CompactionRecordCounts";
    public static final String COMPACTION_HIVE_REGISTRATION_EVENT = "CompactionHiveRegistration";
    public static final String COMPACTION_MARK_DIR_EVENT = "CompactionMarkDirComplete";

    public static SlaEventSubmitter.SlaEventSubmitterBuilder getEventSubmitterBuilder(Dataset dataset, Optional<Job> job, FileSystem fs) {
        SlaEventSubmitter.SlaEventSubmitterBuilder builder = SlaEventSubmitter.builder().datasetUrn(dataset.getUrn()).partition(dataset.jobProps().getProp("compaction.job.dest.partition", "")).dedupeStatus(CompactionSlaEventHelper.getOutputDedupeStatus(dataset.jobProps()));
        long previousPublishTime = CompactionSlaEventHelper.getPreviousPublishTime(dataset, fs);
        long upstreamTime = dataset.jobProps().getPropAsLong("event.sla.upstreamTimestamp", -1L);
        long recordCount = CompactionSlaEventHelper.getRecordCount(job);
        if (previousPublishTime != -1L) {
            builder.previousPublishTimestamp(Long.toString(previousPublishTime));
        }
        if (upstreamTime != -1L) {
            builder.upstreamTimestamp(Long.toString(upstreamTime));
        }
        if (recordCount != -1L) {
            builder.recordCount(Long.toString(recordCount));
        }
        return builder;
    }

    @Deprecated
    public static void populateState(Dataset dataset, Optional<Job> job, FileSystem fs) {
        dataset.jobProps().setProp("event.sla.datasetUrn", (Object)dataset.getUrn());
        dataset.jobProps().setProp("event.sla.partition", (Object)dataset.jobProps().getProp("compaction.job.dest.partition", ""));
        dataset.jobProps().setProp("event.sla.dedupeStatus", (Object)CompactionSlaEventHelper.getOutputDedupeStatus(dataset.jobProps()));
        dataset.jobProps().setProp("event.sla.previousPublishTs", (Object)CompactionSlaEventHelper.getPreviousPublishTime(dataset, fs));
        dataset.jobProps().setProp("event.sla.recordCount", (Object)CompactionSlaEventHelper.getRecordCount(job));
    }

    public static void setUpstreamTimeStamp(State state, long time) {
        state.setProp("event.sla.upstreamTimestamp", (Object)Long.toString(time));
    }

    private static long getPreviousPublishTime(Dataset dataset, FileSystem fs) {
        Path compactionCompletePath = new Path(dataset.outputPath(), "_COMPACTION_COMPLETE");
        try {
            return fs.getFileStatus(compactionCompletePath).getModificationTime();
        }
        catch (IOException e) {
            LOG.debug("Failed to get previous publish time.", (Throwable)e);
            return -1L;
        }
    }

    private static String getOutputDedupeStatus(State state) {
        return state.getPropAsBoolean("compaction.output.deduplicated", true) ? DedupeStatus.DEDUPED.toString() : DedupeStatus.NOT_DEDUPED.toString();
    }

    private static long getRecordCount(Optional<Job> job) {
        if (!job.isPresent()) {
            return -1L;
        }
        Counters counters = null;
        try {
            counters = ((Job)job.get()).getCounters();
        }
        catch (IOException e) {
            LOG.debug("Failed to get job counters. Record count will not be set. ", (Throwable)e);
            return -1L;
        }
        Counter recordCounter = counters.findCounter((Enum)RecordKeyDedupReducerBase.EVENT_COUNTER.RECORD_COUNT);
        if (recordCounter != null && recordCounter.getValue() != 0L) {
            return recordCounter.getValue();
        }
        recordCounter = counters.findCounter((Enum)RecordKeyMapperBase.EVENT_COUNTER.RECORD_COUNT);
        if (recordCounter != null && recordCounter.getValue() != 0L) {
            return recordCounter.getValue();
        }
        LOG.debug("Non zero record count not found in both mapper and reducer counters");
        return -1L;
    }
}

