/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction.parser;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import org.apache.commons.lang.StringUtils;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.dataset.FileSystemDataset;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class CompactionPathParser {
    State state;

    public CompactionParserResult parse(FileSystemDataset dataset) {
        CompactionParserResult result = new CompactionParserResult();
        result.srcBaseDir = this.getSrcBaseDir(this.state);
        result.srcSubDir = this.getSrcSubDir(this.state);
        result.dstBaseDir = this.getDstBaseDir(this.state);
        result.dstSubDir = this.getDstSubDir(this.state);
        this.parseTimeAndDatasetName(dataset, result);
        result.dstAbsoluteDir = Joiner.on((String)"/").join((Object)result.dstBaseDir, (Object)result.datasetName, new Object[]{result.dstSubDir, result.timeString});
        return result;
    }

    private void parseTimeAndDatasetName(FileSystemDataset dataset, CompactionParserResult rst) {
        int startPos;
        String commonBase = rst.getSrcBaseDir();
        String fullPath = dataset.datasetURN();
        String relative = StringUtils.removeStart((String)fullPath.substring(startPos = fullPath.indexOf(commonBase) + commonBase.length()), (String)"/");
        int delimiterStart = StringUtils.indexOf((String)relative, (String)rst.getSrcSubDir());
        if (delimiterStart == -1) {
            throw new StringIndexOutOfBoundsException();
        }
        int delimiterEnd = relative.indexOf("/", delimiterStart);
        String datasetName = StringUtils.removeEnd((String)relative.substring(0, delimiterStart), (String)"/");
        String timeString = StringUtils.removeEnd((String)relative.substring(delimiterEnd + 1), (String)"/");
        rst.datasetName = datasetName;
        rst.timeString = timeString;
        rst.time = this.getTime(timeString);
    }

    private DateTime getTime(String timeString) {
        DateTimeZone timeZone = DateTimeZone.forID((String)"America/Los_Angeles");
        int splits = StringUtils.countMatches((String)timeString, (String)"/");
        String timePattern = "";
        if (splits == 3) {
            timePattern = "YYYY/MM/dd/HH";
        } else if (splits == 2) {
            timePattern = "YYYY/MM/dd";
        }
        DateTimeFormatter timeFormatter = DateTimeFormat.forPattern((String)timePattern).withZone(timeZone);
        return timeFormatter.parseDateTime(timeString);
    }

    private String getSrcBaseDir(State state) {
        Preconditions.checkArgument((boolean)state.contains("compaction.input.dir"), (Object)"Missing required property compaction.input.dir");
        return state.getProp("compaction.input.dir");
    }

    private String getSrcSubDir(State state) {
        Preconditions.checkArgument((boolean)state.contains("compaction.input.subdir"), (Object)"Missing required property compaction.input.subdir");
        return state.getProp("compaction.input.subdir");
    }

    private String getDstBaseDir(State state) {
        Preconditions.checkArgument((boolean)state.contains("compaction.dest.dir"), (Object)"Missing required property compaction.dest.dir");
        return state.getProp("compaction.dest.dir");
    }

    private String getDstSubDir(State state) {
        Preconditions.checkArgument((boolean)state.contains("compaction.dest.subdir"), (Object)"Missing required property compaction.dest.subdir");
        return state.getProp("compaction.dest.subdir");
    }

    public CompactionPathParser(State state) {
        this.state = state;
    }

    public static class CompactionParserResult {
        private String srcBaseDir;
        private String dstBaseDir;
        private String srcSubDir;
        private String dstSubDir;
        private DateTime time;
        private String timeString;
        private String datasetName;
        private String dstAbsoluteDir;

        public String getSrcBaseDir() {
            return this.srcBaseDir;
        }

        public void setSrcBaseDir(String srcBaseDir) {
            this.srcBaseDir = srcBaseDir;
        }

        public String getDstBaseDir() {
            return this.dstBaseDir;
        }

        public void setDstBaseDir(String dstBaseDir) {
            this.dstBaseDir = dstBaseDir;
        }

        public String getSrcSubDir() {
            return this.srcSubDir;
        }

        public void setSrcSubDir(String srcSubDir) {
            this.srcSubDir = srcSubDir;
        }

        public String getDstSubDir() {
            return this.dstSubDir;
        }

        public void setDstSubDir(String dstSubDir) {
            this.dstSubDir = dstSubDir;
        }

        public DateTime getTime() {
            return this.time;
        }

        public String getTimeString() {
            return this.timeString;
        }

        public String getDatasetName() {
            return this.datasetName;
        }

        public String getDstAbsoluteDir() {
            return this.dstAbsoluteDir;
        }
    }
}

