/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction.mapreduce;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.gobblin.compaction.action.CompactionCompleteAction;
import org.apache.gobblin.compaction.mapreduce.CompactorOutputCommitter;
import org.apache.gobblin.compaction.mapreduce.RecordKeyDedupReducerBase;
import org.apache.gobblin.compaction.mapreduce.RecordKeyMapperBase;
import org.apache.gobblin.compaction.suite.CompactionSuite;
import org.apache.gobblin.compaction.suite.CompactionSuiteUtils;
import org.apache.gobblin.compaction.verify.CompactionVerifier;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.dataset.Dataset;
import org.apache.gobblin.dataset.FileSystemDataset;
import org.apache.gobblin.metrics.event.EventSubmitter;
import org.apache.gobblin.runtime.TaskContext;
import org.apache.gobblin.runtime.TaskState;
import org.apache.gobblin.runtime.mapreduce.MRTask;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormatCounter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MRCompactionTask
extends MRTask {
    private static final Logger log = LoggerFactory.getLogger(MRCompactionTask.class);
    public static final String RECORD_COUNT = "counter.recordCount";
    public static final String FILE_COUNT = "counter.fileCount";
    public static final String BYTE_COUNT = "counter.byteCount";
    protected final CompactionSuite suite;
    protected final Dataset dataset;
    protected final EventSubmitter eventSubmitter;

    public MRCompactionTask(TaskContext taskContext) throws IOException {
        super(taskContext);
        this.suite = CompactionSuiteUtils.getCompactionSuiteFactory((State)taskContext.getTaskState()).createSuite((State)taskContext.getTaskState());
        this.dataset = this.suite.load((State)taskContext.getTaskState());
        this.eventSubmitter = new EventSubmitter.Builder(this.metricContext, "compaction.tracking.events").addMetadata(this.additionalEventMetadata()).build();
    }

    public void run() {
        List verifiers = this.suite.getMapReduceVerifiers();
        for (CompactionVerifier<Dataset> compactionVerifier : verifiers) {
            if (compactionVerifier.verify(this.dataset).isSuccessful()) continue;
            log.error("Verification {} for {} is not passed.", (Object)compactionVerifier.getName(), (Object)this.dataset.getUrn());
            this.onMRTaskComplete(false, new IOException("Compaction verification for MR is failed"));
            return;
        }
        if (this.dataset instanceof FileSystemDataset && ((FileSystemDataset)this.dataset).isVirtual()) {
            log.info("A trivial compaction job as there is no physical data for {}.Will trigger a success complete directly", (Object)this.dataset.getUrn());
            this.onMRTaskComplete(true, null);
            return;
        }
        super.run();
    }

    public void onMRTaskComplete(boolean isSuccess, Throwable throwable) {
        if (isSuccess) {
            try {
                this.setCounterInfo(this.taskContext.getTaskState());
                List actions = this.suite.getCompactionCompleteActions();
                for (CompactionCompleteAction<Dataset> compactionCompleteAction : actions) {
                    compactionCompleteAction.addEventSubmitter(this.eventSubmitter);
                    compactionCompleteAction.onCompactionJobComplete(this.dataset);
                }
                this.submitEvent("CompactionCompleted");
                super.onMRTaskComplete(true, null);
            }
            catch (IOException e) {
                this.submitEvent("CompactionFailed");
                super.onMRTaskComplete(false, (Throwable)e);
            }
        } else {
            this.submitEvent("CompactionFailed");
            super.onMRTaskComplete(false, throwable);
        }
    }

    private void setCounterInfo(TaskState taskState) throws IOException {
        if (this.mrJob == null) {
            return;
        }
        long recordCount = this.getCounterValue(this.mrJob, RecordKeyDedupReducerBase.EVENT_COUNTER.RECORD_COUNT);
        if (recordCount == 0L) {
            recordCount = this.getCounterValue(this.mrJob, RecordKeyMapperBase.EVENT_COUNTER.RECORD_COUNT);
        }
        taskState.setProp(RECORD_COUNT, (Object)recordCount);
        taskState.setProp(FILE_COUNT, (Object)this.getCounterValue(this.mrJob, CompactorOutputCommitter.EVENT_COUNTER.OUTPUT_FILE_COUNT));
        taskState.setProp(BYTE_COUNT, (Object)this.getCounterValue(this.mrJob, (Enum<?>)FileOutputFormatCounter.BYTES_WRITTEN));
    }

    private long getCounterValue(Job job, Enum<?> key) throws IOException {
        return job.getCounters().findCounter(key).getValue();
    }

    private void submitEvent(String eventName) {
        ImmutableMap eventMetadataMap = ImmutableMap.of((Object)"datasetUrn", (Object)this.dataset.datasetURN());
        this.eventSubmitter.submit(eventName, (Map)eventMetadataMap);
    }

    protected Job createJob() throws IOException {
        return this.suite.createJob(this.dataset);
    }
}

